/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.AutoHideContainer;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.FrameContainer;
import com.jidesoft.swing.SidePaneGroup;
import com.jidesoft.swing.SidePaneItem;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class NotificationFlasher
implements ActionListener {
    private DockableFrame _frame;
    private FrameContainer _fc;
    private AutoHideContainer _ac;
    private Color _notificationBackground;
    private Color _notificationForeground;
    private int _steps;
    private Timer _timer;
    private int _currentStep;

    public NotificationFlasher(FrameContainer fc, DockableFrame frame, int initDelay, int delay, int steps) {
        this._fc = fc;
        this._frame = frame;
        this._steps = steps;
        this._currentStep = 0;
        this._timer = new Timer(delay, this);
        this._timer.setInitialDelay(initDelay);
        this._notificationBackground = this._frame.getDockingManager().getNotificationBackground();
        this._notificationForeground = this._frame.getDockingManager().getNotificationForeground();
    }

    public NotificationFlasher(AutoHideContainer ac, DockableFrame frame, int initDelay, int delay, int steps) {
        this._frame = frame;
        this._ac = ac;
        SidePaneItem item = ac.getSidePaneItem(frame);
        SidePaneGroup group = ac.getSidePaneGroup(frame);
        group.setSelectedItem(item);
        this._steps = steps;
        this._currentStep = 0;
        this._timer = new Timer(delay, this);
        this._timer.setInitialDelay(initDelay);
        this._notificationBackground = this._frame.getDockingManager().getNotificationBackground();
        this._notificationForeground = this._frame.getDockingManager().getNotificationForeground();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.flash(this._currentStep % 2 == 0);
        ++this._currentStep;
        if (this._steps != -1 && this._currentStep >= this._steps) {
            this.stop();
        }
    }

    public void start() {
        if (this._timer != null) {
            this._timer.start();
        }
    }

    public void stop() {
        this.flash(this._frame.isNotified() && !this._frame.isActive());
        if (this._timer != null) {
            this._timer.stop();
        }
    }

    public void interrupt() {
        this.stop();
    }

    public boolean isRunning() {
        return this._timer != null && this._timer.isRunning();
    }

    private void flash(boolean flashOn) {
        SidePaneItem item;
        Color background = null;
        Color foreground = null;
        if (flashOn) {
            background = this._notificationBackground;
            foreground = this._notificationForeground;
        }
        if (this._fc != null) {
            int index = this._fc.indexOfComponent(this._frame);
            if (index != -1) {
                this._fc.setBackgroundAt(index, background);
                this._fc.setForegroundAt(index, foreground);
                this._fc.repaint();
            }
        } else if (this._ac != null && (item = this._ac.getSidePaneItem(this._frame)) != null) {
            item.setForeground(foreground);
            item.setBackground(background);
            this._ac.repaint();
        }
    }
}

