/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.ContainerContainer;
import com.jidesoft.docking.DockID;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockableFrameMouseInputAdapter;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.docking.DockingUtils;
import com.jidesoft.docking.DragableDockable;
import com.jidesoft.docking.PreviousState;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.JideTabbedPane;
import com.jidesoft.utils.SystemInfo;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.plaf.UIResource;

public class FrameContainer
extends JideTabbedPane
implements ComponentListener,
ContainerListener,
DragableDockable,
PropertyChangeListener {
    private DockableFrameMouseInputAdapter _borderListener;
    private DockingManager _dockingManager;
    private int _dockedWidth;
    private int _dockedHeight;
    private int _autohideWidth;
    private int _autohideHeight;
    private DockableFrame _previousSelectedFrame;
    private int _dockID = 0;

    FrameContainer() {
        this(null);
    }

    public FrameContainer(DockingManager dockingManager) {
        this(dockingManager, 3, 1);
    }

    public FrameContainer(DockingManager dockingManager, int tabPlacement, int tabLayoutPolicy) {
        super(tabPlacement, tabLayoutPolicy);
        this._dockingManager = dockingManager;
        if (this._dockingManager != null) {
            this.setTabResizeMode(2);
            this.setHideOneTab(true);
            this.addContainerListener(this);
            this.addComponentListener(this);
            this.resetDockID();
            AbstractAction closeAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() instanceof DockableFrame) {
                        ((DockableFrame)e.getSource()).getCloseAction().actionPerformed(e);
                    }
                }
            };
            this.setCloseAction(closeAction);
            this.setOpaque(false);
            this.setAutoFocusOnTabHideClose(false);
            this.setAutoRequestFocus(false);
            this.setCloseTabOnMouseMiddleButton(true);
        }
    }

    @Override
    public void updateUI() {
        Insets contentBorderInsets;
        Insets insets;
        super.updateUI();
        if (this._borderListener == null) {
            this._borderListener = new DockableFrameMouseInputAdapter(this);
        }
        if (!JideSwingUtilities.isMouseListenerRegistered(this, this._borderListener)) {
            this.addMouseListener(this._borderListener);
        }
        if (!JideSwingUtilities.isMouseMotionListenerRegistered(this, this._borderListener)) {
            this.addMouseMotionListener(this._borderListener);
        }
        if (((insets = this.getContentBorderInsets()) == null || insets instanceof UIResource) && (contentBorderInsets = UIDefaultsLookup.getInsets("FrameContainer.contentBorderInsets")) != null) {
            this.setContentBorderInsets(contentBorderInsets);
        }
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        if (e.getChild() instanceof DockableFrame) {
            e.getChild().addPropertyChangeListener(this);
        }
        if (!SystemInfo.isJdk6Above() && !(e.getChild() instanceof UIResource)) {
            this.fireStateChanged();
        }
    }

    @Override
    public boolean isEnabledAt(int index) {
        DockableFrame frame = this.getFrame(index);
        return super.isEnabledAt(index) && (frame == null || frame.isEnabled());
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        if (e.getChild() instanceof DockableFrame) {
            e.getChild().removePropertyChangeListener(this);
        }
        if (this.getTabCount() == 0 || this.getTabCount() == 1 && this.getComponentAt(0).equals(e.getChild())) {
            if (this.getParent() == null) {
                return;
            }
            if (this.getParent() instanceof ContainerContainer) {
                ((ContainerContainer)this.getParent()).removePane(e.getComponent());
            } else {
                this.getParent().remove(e.getComponent());
            }
        }
        if (!SystemInfo.isJdk6Above() && !(e.getChild() instanceof UIResource)) {
            this.fireStateChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void componentResized(ComponentEvent e) {
        if (this.getDockingManager().getDockedFrameContainer() == null) {
            return;
        }
        if (!DockingUtils.containsInMainContainer(this.getDockingManager().getDockedFrameContainer(), this)) {
            for (int i = 0; i < this.getTabCount(); ++i) {
                Component component = this.getComponentAt(i);
                if (!(component instanceof DragableDockable)) continue;
                Rectangle bounds = component.getBounds();
                Point location = new Point(0, 0);
                SwingUtilities.convertPointToScreen(location, component);
                bounds.x = location.x;
                bounds.y = location.y;
                try {
                    if (component instanceof DockableFrame) {
                        ((DockableFrame)component).setSettingSize(true);
                    }
                    ((DragableDockable)((Object)component)).setUndockedBounds(bounds);
                    continue;
                }
                finally {
                    if (component instanceof DockableFrame) {
                        ((DockableFrame)component).setSettingSize(false);
                    }
                }
            }
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    public void addTab(DockableFrame frame) {
        this.addTab(frame, false);
    }

    public void addTab(DockableFrame frame, boolean suppressEvents) {
        boolean oldSuppressStateEvent = this.isSuppressStateChangedEvents();
        boolean oldSuppressSelectedEvent = this.isSuppressSetSelectedIndex();
        this.setSuppressStateChangedEvents(suppressEvents);
        int oldIndex = this.getSelectedIndex();
        if (oldIndex != -1) {
            this.setSuppressSetSelectedIndex(suppressEvents);
        }
        super.addTab(frame.getTabTitle(), frame.getFrameIcon(), frame, frame.getToolTipText());
        this.setSuppressStateChangedEvents(oldSuppressStateEvent);
        this.setSuppressSetSelectedIndex(oldSuppressSelectedEvent);
    }

    public void insertTab(DockableFrame frame, int index) {
        this.insertTab(frame, index, false);
    }

    public void insertTab(DockableFrame frame, int index, boolean suppressEvents) {
        boolean oldSuppressSelected = this.isSuppressSetSelectedIndex();
        boolean oldSuppressChanged = this.isSuppressStateChangedEvents();
        this.setSuppressSetSelectedIndex(suppressEvents);
        int oldIndex = this.getSelectedIndex();
        if (oldIndex != -1) {
            this.setSuppressSetSelectedIndex(suppressEvents);
        }
        this.setSuppressStateChangedEvents(suppressEvents);
        this.insertTab(frame.getTabTitle(), frame.getFrameIcon(), frame, frame.getToolTipText() == null ? frame.getTitle() : frame.getToolTipText(), index);
        this.setSuppressSetSelectedIndex(oldSuppressSelected);
        this.setSuppressStateChangedEvents(oldSuppressChanged);
    }

    @Override
    public void setTitleAt(int index, String title) {
        DockableFrame f = this.getFrame(index);
        if (f != null) {
            f.setTabTitle(title);
        }
        super.setTitleAt(index, title);
    }

    public void remove(Component component, boolean suppressEvents) {
        boolean oldSuppressSelected = this.isSuppressSetSelectedIndex();
        boolean oldSuppressChanged = this.isSuppressStateChangedEvents();
        this.setSuppressSetSelectedIndex(suppressEvents);
        int oldIndex = this.getSelectedIndex();
        if (oldIndex != -1) {
            this.setSuppressSetSelectedIndex(suppressEvents);
        }
        this.setSuppressStateChangedEvents(suppressEvents);
        super.remove(component);
        this.setSuppressSetSelectedIndex(oldSuppressSelected);
        this.setSuppressStateChangedEvents(oldSuppressChanged);
    }

    @Override
    public void setSelectedComponent(Component c) {
        super.setSelectedComponent(c);
        if (c instanceof DockableFrame) {
            this.setPreviousSelectedFrame((DockableFrame)c);
        }
    }

    public void setSelectedIndex(int index, boolean suppressEvents) {
        boolean oldSuppressSelected = this.isSuppressSetSelectedIndex();
        boolean oldSuppressChanged = this.isSuppressStateChangedEvents();
        this.setSuppressSetSelectedIndex(suppressEvents);
        int oldIndex = this.getSelectedIndex();
        if (oldIndex != -1) {
            this.setSuppressSetSelectedIndex(suppressEvents);
        }
        this.setSuppressStateChangedEvents(suppressEvents);
        this.setSelectedIndex(index);
        this.setSuppressSetSelectedIndex(oldSuppressSelected);
        this.setSuppressStateChangedEvents(oldSuppressChanged);
    }

    @Override
    public void setSelectedIndex(int index) {
        if (this.isSuppressSetSelectedIndex()) {
            return;
        }
        super.setSelectedIndex(index);
    }

    @Override
    public void popupSelectedIndex(int index) {
        super.popupSelectedIndex(index);
        DockableFrame frame = this.getFrame(index);
        if (frame != null) {
            this._dockingManager.activateFrame(frame.getKey());
        }
    }

    @Override
    public DockingManager getDockingManager() {
        return this._dockingManager;
    }

    @Override
    public void setDockingManager(DockingManager dockingManager) {
        this._dockingManager = dockingManager;
    }

    @Override
    public void setDockedWidth(int w) {
        this._dockedWidth = w;
    }

    @Override
    public void setDockedHeight(int h) {
        this._dockedHeight = h;
    }

    @Override
    public void setAutohideWidth(int w) {
        this._autohideWidth = w;
    }

    @Override
    public void setAutohideHeight(int h) {
        this._autohideHeight = h;
    }

    @Override
    public int getDockedWidth() {
        if (this._dockedWidth <= 0) {
            return this.getPreferredSize().width;
        }
        return this._dockedWidth;
    }

    @Override
    public int getDockedHeight() {
        if (this._dockedHeight <= 0) {
            return this.getPreferredSize().height;
        }
        return this._dockedHeight;
    }

    @Override
    public int getAutohideWidth() {
        if (this._autohideWidth <= 0) {
            return this.getPreferredSize().width;
        }
        return this._autohideWidth;
    }

    @Override
    public int getAutohideHeight() {
        if (this._autohideHeight <= 0) {
            return this.getPreferredSize().height;
        }
        return this._autohideHeight;
    }

    @Override
    public void setUndockedBounds(Rectangle bounds) {
        this.setBounds(bounds);
    }

    @Override
    public Rectangle getUndockedBounds() {
        return this.getBounds();
    }

    @Override
    public int getDockID() {
        return this._dockID;
    }

    @Override
    public void setDockID(int id) {
        this._dockID = id;
        if (this._dockingManager != null) {
            DockID.getInstance(this._dockingManager).reserveID(this._dockID);
        }
    }

    @Override
    public void resetDockID() {
        this._dockID = DockID.getInstance(this._dockingManager).getID(this.getDockID());
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (!(this.getComponentAt(i) instanceof DockableFrame)) continue;
            DockableFrame dockableFrame = (DockableFrame)this.getComponentAt(i);
            dockableFrame.resetDockID();
        }
    }

    public DockableFrame getSelectedFrame() {
        return (DockableFrame)this.getSelectedComponent();
    }

    public DockableFrame getFrame(int index) {
        return (DockableFrame)this.getComponentAt(index);
    }

    public int getFrameIndex(DockableFrame frame) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (this.getComponentAt(i) != frame) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void setHiddenPreviousState(PreviousState state) {
        if (this.getSelectedFrame() == null) {
            return;
        }
        this.getSelectedFrame().setHiddenPreviousState(state);
    }

    @Override
    public PreviousState getHiddenPreviousState() {
        return this.getSelectedFrame() == null ? null : this.getSelectedFrame().getHiddenPreviousState();
    }

    @Override
    public void setDockPreviousState(PreviousState state) {
    }

    @Override
    public PreviousState getDockPreviousState() {
        return null;
    }

    @Override
    public void setFloatPreviousState(PreviousState state) {
        if (this.getSelectedFrame() == null) {
            return;
        }
        this.getSelectedFrame().setFloatPreviousState(state);
    }

    @Override
    public PreviousState getFloatPreviousState() {
        return this.getSelectedFrame() == null ? null : this.getSelectedFrame().getFloatPreviousState();
    }

    @Override
    public void setAutohidePreviousState(PreviousState state) {
        if (this.getSelectedFrame() == null) {
            return;
        }
        this.getSelectedFrame().setAutohidePreviousState(state);
    }

    @Override
    public PreviousState getAutohidePreviousState() {
        return this.getSelectedFrame() == null ? null : this.getSelectedFrame().getAutohidePreviousState();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        int index;
        if ("tabTitle".equals(evt.getPropertyName())) {
            int index2 = this.indexOfComponent((Component)evt.getSource());
            if (index2 != -1) {
                this.setTitleAt(index2, (String)evt.getNewValue());
            }
        } else if ("ToolTipText".equals(evt.getPropertyName())) {
            int index3 = this.indexOfComponent((Component)evt.getSource());
            if (index3 != -1) {
                this.setToolTipTextAt(index3, (String)evt.getNewValue());
            }
        } else if ("frameIcon".equals(evt.getPropertyName()) && (index = this.indexOfComponent((Component)evt.getSource())) != -1) {
            this.setIconAt(index, (Icon)evt.getNewValue());
        }
    }

    protected DockableFrame getPreviousSelectedFrame() {
        if (this._previousSelectedFrame != null && this._previousSelectedFrame.getParent() == this) {
            return this._previousSelectedFrame;
        }
        return null;
    }

    protected void setPreviousSelectedFrame(DockableFrame previousSelectedFrame) {
        this._previousSelectedFrame = previousSelectedFrame;
    }

    public boolean isAllFloatable() {
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (((DockableFrame)this.getComponentAt(i)).isFloatable()) continue;
            return false;
        }
        return true;
    }

    public boolean isAllAutohidable() {
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (((DockableFrame)this.getComponentAt(i)).isAutohidable()) continue;
            return false;
        }
        return true;
    }

    public boolean isAllAutohidable(int side) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            DockableFrame dockableFrame = (DockableFrame)this.getComponentAt(i);
            if (dockableFrame.isAutohidable() && (dockableFrame.getPreferredAutohideSide() == -1 || dockableFrame.getPreferredAutohideSide() == side)) continue;
            return false;
        }
        return true;
    }

    public boolean isAllHidable() {
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (((DockableFrame)this.getComponentAt(i)).isHidable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isTabClosableAt(int tabIndex) {
        if (tabIndex >= this.getTabCount()) {
            return true;
        }
        if (this._dockingManager != null && !this._dockingManager.isHidable()) {
            return false;
        }
        Component component = this.getComponentAt(tabIndex);
        if (component instanceof DockableFrame && ((DockableFrame)component).getContext() != null) {
            return ((DockableFrame)component).isHidable();
        }
        return super.isTabClosableAt(tabIndex);
    }

    @Override
    public boolean hasFocusComponent() {
        DockableFrame frame = this.getSelectedFrame();
        return frame != null && frame.isActive() && (frame.getDockingManager() == null || frame.getDockingManager().isActive()) || this.isTabEditing();
    }

    @Override
    public void repaintTabAreaAndContentBorder() {
        super.repaintTabAreaAndContentBorder();
        DockableFrame frame = this.getSelectedFrame();
        if (frame != null && frame.getUI() != null && frame.getUI().getTitlePane() != null) {
            frame.getUI().getTitlePane().repaint();
        }
    }
}

