/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.DefaultDockingManager;
import com.jidesoft.docking.DockableHolder;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.swing.LayoutPersistence;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.HeadlessException;
import javax.swing.JApplet;
import javax.swing.JPanel;

public class DefaultAppletDockableHolder
extends JApplet
implements DockableHolder {
    private DockingManager _dockingManager;
    private JPanel _contentContainer;

    public DefaultAppletDockableHolder() throws HeadlessException {
        this.initFrame(this.getContentPane());
    }

    protected void initFrame(Container container) {
        this.setRootPaneCheckingEnabled(false);
        try {
            container.setLayout(new BorderLayout());
            this._contentContainer = new JPanel();
            this._contentContainer.setOpaque(false);
            container.add((Component)this._contentContainer, "Center");
            this._dockingManager = this.createDockableManager(this._contentContainer);
        }
        finally {
            this.setRootPaneCheckingEnabled(true);
        }
    }

    protected DockingManager createDockableManager(Container container) {
        return new DefaultDockingManager(this, container);
    }

    @Override
    public DockingManager getDockingManager() {
        return this._dockingManager;
    }

    public LayoutPersistence getLayoutPersistence() {
        return this._dockingManager;
    }

    @Override
    public void destroy() {
        super.destroy();
        this._contentContainer = null;
        if (this._dockingManager != null) {
            this._dockingManager.dispose();
            this._dockingManager = null;
        }
        if (this.getRootPane() != null && this.getRootPane().getJMenuBar() != null) {
            this.getJMenuBar().removeAll();
            this.setJMenuBar(null);
        }
    }

    protected boolean isContentPaneCheckingEnabled() {
        return this.isRootPaneCheckingEnabled();
    }

    protected void setContentPaneCheckingEnabled(boolean contentPaneCheckingEnabled) {
        this.setRootPaneCheckingEnabled(contentPaneCheckingEnabled);
    }
}

