/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.plaf.basic.BasicDockableFrameTitlePane;
import com.jidesoft.utils.SecurityUtils;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputListener;

public class AutoHideMouseListener
extends MouseAdapter
implements MouseInputListener {
    protected final DockableFrame _frame;
    protected final int _side;
    protected final DockingManager _dockingManager;
    private static final int NO_DELAY = 0;

    public AutoHideMouseListener(DockingManager dockingManager, DockableFrame frame, int side) {
        this._dockingManager = dockingManager;
        this._frame = frame;
        this._side = side;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger() && e.getSource() instanceof Component && this._frame.getUI().getTitlePane() instanceof BasicDockableFrameTitlePane && this._dockingManager.isShowContextMenu() && this._frame.isShowContextMenu()) {
            this._dockingManager.showContextMenu((Component)e.getSource(), e.getPoint(), this._frame, false);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger() && e.getSource() instanceof Component && this._frame.getUI().getTitlePane() instanceof BasicDockableFrameTitlePane && this._dockingManager.isShowContextMenu() && this._frame.isShowContextMenu()) {
            this._dockingManager.showContextMenu((Component)e.getSource(), e.getPoint(), this._frame, false);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!(e.isPopupTrigger() && e.getSource() instanceof Component && this._frame.getUI().getTitlePane() instanceof BasicDockableFrameTitlePane || this._frame == null)) {
            if (this._frame.isActive()) {
                this._dockingManager.stopShowingAutohideFrame(0, false);
            } else {
                this._dockingManager.requestFocusInDockingManager();
                this._dockingManager.activateFrame(this._frame.getKey());
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (e.isPopupTrigger() && e.getSource() instanceof Component && this._frame != null && this._frame.getUI().getTitlePane() instanceof BasicDockableFrameTitlePane) {
            return;
        }
        if (this._frame != null) {
            DockableFrame activeFrame;
            int openDelay = this._dockingManager.getInitDelay();
            if (this._dockingManager.getAutohideShowingFrame() != null) {
                openDelay = 0;
            }
            if (e.getID() == 506) {
                this._dockingManager.activateFrame(this._frame.getKey());
                openDelay = 0;
            }
            String activeFrameKey = this._dockingManager.getActiveFrameKey();
            boolean needStartShowing = true;
            if (activeFrameKey != null && (activeFrame = this._dockingManager.getFrame(activeFrameKey)).isAutohideShowing()) {
                needStartShowing = false;
            }
            if (needStartShowing) {
                this._dockingManager.startShowingAutohideFrame(this._frame.getKey(), this._side, openDelay);
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (e.getID() != 506) {
            if (SecurityUtils.isAWTEventListenerDisabled() || "true".equals(SecurityUtils.getProperty("jide.disableAWTEventListener", "false"))) {
                return;
            }
            String autohideShowingFrame = this._dockingManager.getAutohideShowingFrame();
            if ((!this._frame.isActive() || this._frame.isAutohideWhenActive()) && autohideShowingFrame != null && this._frame == this._dockingManager.getFrame(autohideShowingFrame)) {
                this._dockingManager.stopShowingAutohideFrame(this._dockingManager.getInitDelay(), false);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this._dockingManager.getAutohideShowingFrame() == null) {
            this._dockingManager.startShowingAutohideFrame(this._frame.getKey(), this._side, this._dockingManager.getInitDelay() * 2);
        }
    }
}

