/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.docking.DockingUtils;
import com.jidesoft.docking.FrameContainer;
import com.jidesoft.docking.event.DockableFrameEvent;
import com.jidesoft.docking.event.DockableFrameListener;
import com.jidesoft.swing.SidePane;
import com.jidesoft.swing.SidePaneGroup;
import com.jidesoft.swing.SidePaneItem;
import com.jidesoft.swing.SimpleScrollPane;
import java.awt.Container;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;

public class AutoHideContainer
extends SidePane
implements PropertyChangeListener,
DockableFrameListener {
    private final DockingManager _dockingManager;
    private final MouseInputCreator _mouseInputCreator;

    AutoHideContainer(int attachedSide) {
        this(attachedSide, null, null);
    }

    public AutoHideContainer(int attachedSide, DockingManager dockingManager, MouseInputCreator mouseInputCreator) {
        super(attachedSide);
        this.setOpaque(false);
        this._dockingManager = dockingManager;
        this._mouseInputCreator = mouseInputCreator;
    }

    public int getGroupIndex(DockableFrame frame) {
        for (int i = 0; i < this.getGroups().size(); ++i) {
            SidePaneGroup group = this.getGroups().get(i);
            if (!group.exists(frame)) continue;
            return i;
        }
        return -1;
    }

    public SidePaneGroup getSidePaneGroup(DockableFrame frame) {
        for (int i = 0; i < this.getGroups().size(); ++i) {
            SidePaneGroup group = this.getGroups().get(i);
            if (!group.exists(frame)) continue;
            return group;
        }
        return null;
    }

    public SidePaneItem getSidePaneItem(DockableFrame frame) {
        SidePaneGroup group = this.getSidePaneGroup(frame);
        if (group != null) {
            return group.getSidePaneItem(frame);
        }
        return null;
    }

    public int getSelectedItemIndex(Point p) {
        return this.getUI().getSelectedItemIndex(p);
    }

    public SidePaneGroup getGroupForIndex(int index) {
        return this.getUI().getGroupForIndex(index);
    }

    public SidePaneItem getItemForIndex(int index) {
        return this.getUI().getItemForIndex(index);
    }

    @Override
    public void addGroup(SidePaneGroup group) {
        super.addGroup(group);
        int dockSide = DockingUtils.convertToDockSide(this.getAttachedSide());
        for (SidePaneItem item : group) {
            if (item.getComponent() instanceof DockableFrame) {
                DockableFrame frame = (DockableFrame)item.getComponent();
                frame.getContext().setCurrentDockSide(dockSide);
                frame.addDockableFrameListener(this);
            }
            item.getComponent().removePropertyChangeListener(this);
            item.getComponent().addPropertyChangeListener(this);
        }
        this.invalidateScrollPane();
    }

    public void addGroup(FrameContainer container) {
        if (this._dockingManager.isGroupAllowedOnSidePane()) {
            DockableFrame frame;
            int i;
            SidePaneGroup group = new SidePaneGroup();
            for (i = 0; i < container.getTabCount(); ++i) {
                frame = (DockableFrame)container.getComponentAt(i);
                int dockSide = DockingUtils.convertToDockSide(this.getAttachedSide());
                group.add(new SidePaneItem(frame.getSideTitle(), frame.getFrameIcon(), frame, this._mouseInputCreator.createAutoHideMouseInputListener(frame, dockSide)));
                frame.getContext().setCurrentDockSide(dockSide);
                frame.removeDockableFrameListener(this);
                frame.addDockableFrameListener(this);
                frame.removePropertyChangeListener(this);
                frame.addPropertyChangeListener(this);
            }
            if (group.size() > 0) {
                int index = container.getSelectedIndex();
                if (index >= 0) {
                    group.setSelectedIndex(index);
                }
                this.getGroups().add(group);
            }
            for (i = 0; i < container.getTabCount(); ++i) {
                try {
                    frame = (DockableFrame)container.getComponentAt(i);
                    frame.setAutohide(true);
                    continue;
                }
                catch (PropertyVetoException frame2) {
                    // empty catch block
                }
            }
        } else {
            for (int i = 0; i < container.getTabCount(); ++i) {
                SidePaneGroup group = new SidePaneGroup();
                DockableFrame frame = (DockableFrame)container.getComponentAt(i);
                int dockSide = DockingUtils.convertToDockSide(this.getAttachedSide());
                group.add(new SidePaneItem(frame.getSideTitle(), frame.getFrameIcon(), frame, this._mouseInputCreator.createAutoHideMouseInputListener(frame, dockSide)));
                frame.removeDockableFrameListener(this);
                frame.addDockableFrameListener(this);
                frame.removePropertyChangeListener(this);
                frame.addPropertyChangeListener(this);
                this.getGroups().add(group);
                try {
                    frame.getContext().setCurrentDockSide(dockSide);
                    frame.setAutohide(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                if (group.size() <= 0) continue;
                group.setSelectedIndex(0);
            }
        }
        container.removeAll();
        this.invalidateScrollPane();
    }

    public void addFrame(DockableFrame frame, int groupIndex) {
        if (groupIndex >= this.getGroups().size()) {
            super.addGroup(new SidePaneGroup());
            groupIndex = this.getGroups().size() - 1;
        }
        SidePaneGroup group = this.getGroups().get(groupIndex);
        this.addFrameToGroup(group, frame);
        group.setSelectedIndex(group.size() - 1);
        this.invalidateScrollPane();
    }

    public void addFrame(DockableFrame frame) {
        this.addFrame(frame, 0);
    }

    private void addFrameToGroup(SidePaneGroup group, DockableFrame frame) {
        int dockSide = DockingUtils.convertToDockSide(this.getAttachedSide());
        group.add(new SidePaneItem(frame.getSideTitle(), frame.getFrameIcon(), frame, this._mouseInputCreator.createAutoHideMouseInputListener(frame, dockSide)));
        try {
            frame.getContext().setCurrentDockSide(dockSide);
            frame.setAutohide(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        frame.addDockableFrameListener(this);
        frame.removePropertyChangeListener(this);
        frame.addPropertyChangeListener(this);
    }

    public void removeFrame(DockableFrame frame) {
        for (int i = 0; i < this.getGroups().size(); ++i) {
            SidePaneGroup group = this.getGroups().get(i);
            frame.removePropertyChangeListener(this);
            frame.removeDockableFrameListener(this);
            if (!group.removeComponent(frame)) continue;
            if (group.size() != 0) break;
            this.removeGroup(i);
            break;
        }
        if (this.getGroups().size() == 0) {
            this.removeAll();
        }
        this.invalidateScrollPane();
    }

    @Override
    public void removeGroup(SidePaneGroup group) {
        super.removeGroup(group);
        for (SidePaneItem item : group) {
            item.getComponent().removePropertyChangeListener(this);
            if (!(item.getComponent() instanceof DockableFrame)) continue;
            ((DockableFrame)item.getComponent()).removeDockableFrameListener(this);
        }
        this.invalidateScrollPane();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        SidePaneItem item;
        if ("sideTitle".equals(evt.getPropertyName())) {
            SidePaneItem item2 = this.getSidePaneItem((DockableFrame)evt.getSource());
            if (item2 != null) {
                item2.setTitle((String)evt.getNewValue());
                this.repaint();
            }
        } else if ("frameIcon".equals(evt.getPropertyName()) && (item = this.getSidePaneItem((DockableFrame)evt.getSource())) != null) {
            item.setIcon((Icon)evt.getNewValue());
            this.repaint();
        }
    }

    public List<String> getAllFrameKeys() {
        ArrayList<String> list = new ArrayList<String>();
        List<SidePaneGroup> groups = this.getGroups();
        for (SidePaneGroup group : groups) {
            for (Object g : group) {
                SidePaneItem item = (SidePaneItem)g;
                if (!(item.getComponent() instanceof DockableFrame)) continue;
                list.add(((DockableFrame)item.getComponent()).getKey());
            }
        }
        return list;
    }

    private void invalidateScrollPane() {
        Container ancestorOfClass = SwingUtilities.getAncestorOfClass(SimpleScrollPane.class, this);
        if (ancestorOfClass != null) {
            this.invalidate();
            this.getParent().doLayout();
        }
    }

    @Override
    public void dockableFrameAdded(DockableFrameEvent e) {
    }

    @Override
    public void dockableFrameRemoved(DockableFrameEvent e) {
    }

    @Override
    public void dockableFrameShown(DockableFrameEvent e) {
    }

    @Override
    public void dockableFrameHidden(DockableFrameEvent e) {
    }

    @Override
    public void dockableFrameDocked(DockableFrameEvent e) {
    }

    @Override
    public void dockableFrameFloating(DockableFrameEvent e) {
    }

    @Override
    public void dockableFrameAutohidden(DockableFrameEvent e) {
        if (e.getDockableFrame().isAutohide() || e.getDockableFrame().isAutohideShowing()) {
            this.repaint();
        }
    }

    @Override
    public void dockableFrameAutohideShowing(DockableFrameEvent e) {
        if (e.getDockableFrame().isAutohide() || e.getDockableFrame().isAutohideShowing()) {
            this.repaint();
        }
    }

    @Override
    public void dockableFrameActivated(DockableFrameEvent e) {
        if (e.getDockableFrame().isAutohide() || e.getDockableFrame().isAutohideShowing()) {
            this.repaint();
        } else if (e.getOppositeDockableFrame() != null && (e.getOppositeDockableFrame().isAutohide() || e.getOppositeDockableFrame().isAutohideShowing())) {
            this.repaint();
        }
    }

    @Override
    public void dockableFrameDeactivated(DockableFrameEvent e) {
        if (e.getDockableFrame().isAutohide() || e.getDockableFrame().isAutohideShowing()) {
            this.repaint();
        } else if (e.getOppositeDockableFrame() != null && (e.getOppositeDockableFrame().isAutohide() || e.getOppositeDockableFrame().isAutohideShowing())) {
            this.repaint();
        }
    }

    @Override
    public void dockableFrameTabShown(DockableFrameEvent e) {
    }

    @Override
    public void dockableFrameTabHidden(DockableFrameEvent e) {
    }

    @Override
    public void dockableFrameMaximized(DockableFrameEvent e) {
    }

    @Override
    public void dockableFrameRestored(DockableFrameEvent e) {
    }

    @Override
    public void dockableFrameTransferred(DockableFrameEvent e) {
    }

    @Override
    public void dockableFrameMoved(DockableFrameEvent e) {
    }

    public static interface MouseInputCreator {
        public MouseInputListener createAutoHideMouseInputListener(DockableFrame var1, int var2);
    }
}

