/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.action;

import com.jidesoft.action.CommandBar;
import com.jidesoft.action.DefaultDockableBarManager;
import com.jidesoft.action.DockableBar;
import com.jidesoft.action.DockableBarContainer;
import com.jidesoft.action.DockableBarContext;
import com.jidesoft.action.DockableBarFactory;
import com.jidesoft.action.DockableBarItem;
import com.jidesoft.action.DockableBarList;
import com.jidesoft.action.DockableBarListList;
import com.jidesoft.action.DockableBarManager;
import com.jidesoft.action.FloatingDockableBarContainer;
import com.jidesoft.action.FloatingDockableBars;
import com.jidesoft.action.HiddenDockableBars;
import com.jidesoft.action.PreviousState;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.PersistenceUtils;
import com.jidesoft.utils.PersistenceUtilsCallback;
import com.jidesoft.utils.PortingUtils;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DockableBarPersistenceUtils {
    private static final String NODE_CONTEXT = "DockableBarContext";
    private static final String NODE_PREVIOUS_STATE = "DockableBarPreviousState";
    private static final String NODE_CHILD = "DockableBarChild";
    private static final String NODE_PARENT_STATE = "DockableBarParentState";
    private static final String NODE_DOCKABLE_BAR_CONTAINER = "DockableBarContainer";
    private static final String NODE_FLOATING_BAR_CONTAINER = "FloatingBarContainer";
    private static final String NODE_DOCKABLE_BAR_LIST = "DockableBarList";
    private static final String NODE_DOCKABLE_BAR_ITEM = "DockableBarItem";
    private static final String NODE_DOCKABLE_BAR = "DockableBar";
    private static final String NODE_UNDOCKED_BOUNDS = "UndockedBounds";
    private static final String NODE_BOUNDS = "Bounds";
    private static final String ATTRIBUTE_FRAME_STATE = "frameState";
    private static final String ATTRIBUTE_KEY = "key";
    private static final String ATTRIBUTE_DOCK_ID = "dockId";
    private static final String ATTRIBUTE_INIT_SIDE = "initSide";
    private static final String ATTRIBUTE_INIT_INDEX = "initIndex";
    private static final String ATTRIBUTE_INIT_POSITION = "initPosition";
    private static final String ATTRIBUTE_INIT_MODE = "initMode";
    private static final String ATTRIBUTE_CURRENT_MODE = "currentMode";
    private static final String ATTRIBUTE_CURRENT_DOCK_SIDE = "currentDockSide";
    private static final String ATTRIBUTE_DOCKED_WIDTH = "dockedWidth";
    private static final String ATTRIBUTE_DOCKED_HEIGHT = "dockedHeight";
    private static final String ATTRIBUTE_TYPE = "type";
    private static final String ATTRIBUTE_MODE = "mode";
    private static final String ATTRIBUTE_SIDE = "side";
    private static final String ATTRIBUTE_FC_ID = "fcId";
    private static final String ATTRIBUTE_START = "start";
    private static final String ATTRIBUTE_ROW = "row";
    private static final String ATTRIBUTE_NEW_ROW = "newRow";
    private static final String ATTRIBUTE_CC_ID = "ccId";
    private static final String ATTRIBUTE_ORIENTATION = "orientation";
    private static final String ATTRIBUTE_PREFERRED_ROW_COUNT = "preferredRowCount";
    private static final String ATTRIBUTE_X = "x";
    private static final String ATTRIBUTE_Y = "y";
    private static final String ATTRIBUTE_WIDTH = "width";
    private static final String ATTRIBUTE_HEIGHT = "height";
    private static final String PREVIOUS_STATE_HIDDEN = "hidden";
    private static final String PREVIOUS_STATE_DOCK = "dock";
    private static final String PREVIOUS_STATE_CLOSE = "close";
    private static final String PREVIOUS_STATE_FLOAT = "float";
    private static final int HIDE_OFFSCREEN_OFFSET = 10000;

    public static void save(DefaultDockableBarManager manager, String fileName) throws ParserConfigurationException, IOException {
        DockableBarPersistenceUtils.save(manager, fileName, PersistenceUtils.getDefaultXmlEncoding());
    }

    public static void save(DefaultDockableBarManager manager, String fileName, String encoding) throws ParserConfigurationException, IOException {
        DockableBarPersistenceUtils.save(manager, fileName, encoding, null);
    }

    public static void save(final DefaultDockableBarManager manager, final String fileName, final String encoding, final PersistenceUtilsCallback.Save callback) throws ParserConfigurationException, IOException {
        if (SwingUtilities.isEventDispatchThread()) {
            Document document = DockableBarPersistenceUtils.save(manager, callback);
            PersistenceUtils.saveXMLDocumentToFile(document, fileName, encoding);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Document document = DockableBarPersistenceUtils.save(manager, callback);
                            PersistenceUtils.saveXMLDocumentToFile(document, fileName, encoding);
                        }
                        catch (ParserConfigurationException parserConfigurationException) {
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    public static void save(DefaultDockableBarManager manager, OutputStream out) throws ParserConfigurationException, IOException {
        DockableBarPersistenceUtils.save(manager, out, PersistenceUtils.getDefaultXmlEncoding());
    }

    public static void save(DefaultDockableBarManager manager, OutputStream out, String encoding) throws ParserConfigurationException, IOException {
        DockableBarPersistenceUtils.save(manager, out, encoding, null);
    }

    public static void save(final DefaultDockableBarManager manager, final OutputStream out, final String encoding, final PersistenceUtilsCallback.Save callback) throws ParserConfigurationException, IOException {
        if (SwingUtilities.isEventDispatchThread()) {
            Document document = DockableBarPersistenceUtils.save(manager, callback);
            PersistenceUtils.saveXMLDocumentToStream(document, out, encoding);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        Document document = DockableBarPersistenceUtils.save(manager, callback);
                        PersistenceUtils.saveXMLDocumentToStream(document, out, encoding);
                    }
                    catch (ParserConfigurationException document) {
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    public static Document save(DefaultDockableBarManager manager, PersistenceUtilsCallback.Save callback) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        DockableBarPersistenceUtils.saveToDocument(manager, document, callback);
        return document;
    }

    static void saveToDocument(DefaultDockableBarManager manager, Document document, PersistenceUtilsCallback.Save callback) {
        FloatingDockableBars<FloatingDockableBarContainer> floatingDockableBars;
        Element componentElement;
        Rectangle bounds;
        if (manager == null || manager.isLoadingLayoutData()) {
            return;
        }
        manager.removeExtraFloatingDockableBars();
        manager.saveCurrentContext();
        Node component = document.getElementsByTagName("LayoutPersistence").item(0);
        if (component == null) {
            component = document.createElement("LayoutPersistence");
            document.appendChild(component);
        }
        Element rootElement = document.createElement("DockableBarManager");
        component.appendChild(rootElement);
        rootElement.setAttribute("version", "" + manager.getVersion());
        if (manager.getLayoutPersistenceName() != null) {
            rootElement.setAttribute("persistenceName", manager.getLayoutPersistenceName());
        }
        if ((bounds = manager.getUnmaximizedBounds()) != null) {
            Element boundsElement = document.createElement(NODE_UNDOCKED_BOUNDS);
            rootElement.appendChild(boundsElement);
            boundsElement.setAttribute(ATTRIBUTE_X, "" + bounds.x);
            boundsElement.setAttribute(ATTRIBUTE_Y, "" + bounds.y);
            boundsElement.setAttribute(ATTRIBUTE_WIDTH, "" + bounds.width);
            boundsElement.setAttribute(ATTRIBUTE_HEIGHT, "" + bounds.height);
        }
        if (manager.getRootPaneContainer() instanceof Frame) {
            rootElement.setAttribute(ATTRIBUTE_FRAME_STATE, "" + PortingUtils.getFrameState((Frame)((Object)manager.getRootPaneContainer())));
        }
        DockableBarPersistenceUtils.writeAllContexts(document, rootElement, manager, callback);
        DockableBarContainer dockableBarContainer = manager.getDockableBarContainer(3);
        if (dockableBarContainer != null && dockableBarContainer.getDockableBarList() != null && dockableBarContainer.getDockableBarList().size() > 0) {
            componentElement = document.createElement(NODE_DOCKABLE_BAR_CONTAINER);
            rootElement.appendChild(componentElement);
            componentElement.setAttribute(ATTRIBUTE_SIDE, "3");
            DockableBarPersistenceUtils.writeDockableBarContainer(document, componentElement, dockableBarContainer, callback);
        }
        if ((dockableBarContainer = manager.getDockableBarContainer(5)) != null && dockableBarContainer.getDockableBarList() != null && dockableBarContainer.getDockableBarList().size() > 0) {
            componentElement = document.createElement(NODE_DOCKABLE_BAR_CONTAINER);
            rootElement.appendChild(componentElement);
            componentElement.setAttribute(ATTRIBUTE_SIDE, "5");
            DockableBarPersistenceUtils.writeDockableBarContainer(document, componentElement, dockableBarContainer, callback);
        }
        if ((dockableBarContainer = manager.getDockableBarContainer(7)) != null && dockableBarContainer.getDockableBarList() != null && dockableBarContainer.getDockableBarList().size() > 0) {
            componentElement = document.createElement(NODE_DOCKABLE_BAR_CONTAINER);
            rootElement.appendChild(componentElement);
            componentElement.setAttribute(ATTRIBUTE_SIDE, "7");
            DockableBarPersistenceUtils.writeDockableBarContainer(document, componentElement, dockableBarContainer, callback);
        }
        if ((dockableBarContainer = manager.getDockableBarContainer(1)) != null && dockableBarContainer.getDockableBarList() != null && dockableBarContainer.getDockableBarList().size() > 0) {
            componentElement = document.createElement(NODE_DOCKABLE_BAR_CONTAINER);
            rootElement.appendChild(componentElement);
            componentElement.setAttribute(ATTRIBUTE_SIDE, "1");
            DockableBarPersistenceUtils.writeDockableBarContainer(document, componentElement, dockableBarContainer, callback);
        }
        if ((floatingDockableBars = manager._floatingDockableBars) != null && floatingDockableBars.size() > 0) {
            for (FloatingDockableBarContainer floatingContainer : floatingDockableBars) {
                Element componentElement2 = document.createElement(NODE_FLOATING_BAR_CONTAINER);
                rootElement.appendChild(componentElement2);
                DockableBarPersistenceUtils.writeFloatingContainer(document, componentElement2, floatingContainer, callback);
            }
        }
        if (callback != null) {
            callback.save(document, rootElement, manager);
        }
    }

    private static void writeFloatingContainer(Document document, Element element, FloatingDockableBarContainer floatingContainer, PersistenceUtilsCallback.Save callback) {
        boolean visible;
        Rectangle bounds = floatingContainer.getBounds();
        int contY = bounds.y;
        boolean bl = visible = contY >= -5000;
        if (!visible) {
            bounds.y += 10000;
        }
        Element boundsElement = document.createElement(NODE_BOUNDS);
        element.appendChild(boundsElement);
        boundsElement.setAttribute(ATTRIBUTE_X, "" + bounds.x);
        boundsElement.setAttribute(ATTRIBUTE_Y, "" + bounds.y);
        boundsElement.setAttribute(ATTRIBUTE_WIDTH, "" + bounds.width);
        boundsElement.setAttribute(ATTRIBUTE_HEIGHT, "" + bounds.height);
        for (int i = 0; i < floatingContainer.getContentPane().getComponentCount(); ++i) {
            Component component = floatingContainer.getContentPane().getComponent(i);
            if (!(component instanceof DockableBar)) continue;
            Element componentElement = document.createElement(NODE_DOCKABLE_BAR);
            element.appendChild(componentElement);
            DockableBarPersistenceUtils.writeDockableBar(document, componentElement, (DockableBar)component, callback);
        }
    }

    private static void writeDockableBarContainer(Document document, Element element, DockableBarContainer dockableBarContainer, PersistenceUtilsCallback.Save callback) {
        element.setAttribute(ATTRIBUTE_SIDE, "" + dockableBarContainer.getSide());
        DockableBarListList listList = dockableBarContainer.getDockableBarList();
        for (Object aListList : listList) {
            if (!(aListList instanceof DockableBarList) || ((DockableBarList)aListList).size() <= 0) continue;
            Element listElement = document.createElement(NODE_DOCKABLE_BAR_LIST);
            element.appendChild(listElement);
            for (Object item : (DockableBarList)aListList) {
                if (!(item instanceof DockableBarItem)) continue;
                Element itemElement = document.createElement(NODE_DOCKABLE_BAR_ITEM);
                listElement.appendChild(itemElement);
                itemElement.setAttribute(ATTRIBUTE_START, "" + ((DockableBarItem)item).getStart());
                Component dockableBar = ((DockableBarItem)item).getComponent();
                if (!(dockableBar instanceof DockableBar)) continue;
                Element barElement = document.createElement(NODE_DOCKABLE_BAR);
                itemElement.appendChild(barElement);
                DockableBarPersistenceUtils.writeDockableBar(document, barElement, (DockableBar)dockableBar, callback);
            }
        }
        if (callback != null) {
            callback.save(document, element, dockableBarContainer);
        }
    }

    private static void writeDockableBar(Document document, Element barElement, DockableBar dockableBar, PersistenceUtilsCallback.Save callback) {
        barElement.setAttribute(ATTRIBUTE_KEY, dockableBar.getKey());
        if (dockableBar instanceof CommandBar) {
            barElement.setAttribute(ATTRIBUTE_PREFERRED_ROW_COUNT, "" + ((CommandBar)dockableBar).getPreferredRowCount());
        }
        if (callback != null) {
            callback.save(document, barElement, dockableBar);
        }
    }

    private static void writeAllContexts(Document document, Element element, DefaultDockableBarManager manager, PersistenceUtilsCallback.Save callback) {
        Map<String, DockableBarContext> contexts = manager.getAllContexts();
        Set<String> set = contexts.keySet();
        for (String key : set) {
            Element previousStateElement;
            DockableBarContext context = contexts.get(key);
            Element contextElement = document.createElement(NODE_CONTEXT);
            element.appendChild(contextElement);
            contextElement.setAttribute(ATTRIBUTE_KEY, key);
            contextElement.setAttribute(ATTRIBUTE_DOCK_ID, "" + context.getDockID());
            contextElement.setAttribute(ATTRIBUTE_INIT_SIDE, "" + context.getInitSide());
            contextElement.setAttribute(ATTRIBUTE_INIT_INDEX, "" + context.getInitIndex());
            contextElement.setAttribute(ATTRIBUTE_INIT_POSITION, context.isInitPosition() ? "1" : "0");
            contextElement.setAttribute(ATTRIBUTE_INIT_MODE, "" + context.getInitMode());
            contextElement.setAttribute(ATTRIBUTE_CURRENT_MODE, "" + context.getCurrentMode());
            contextElement.setAttribute(ATTRIBUTE_CURRENT_DOCK_SIDE, "" + context.getCurrentDockSide());
            contextElement.setAttribute(ATTRIBUTE_DOCKED_WIDTH, "" + context.getDockedWidth());
            contextElement.setAttribute(ATTRIBUTE_DOCKED_HEIGHT, "" + context.getDockedHeight());
            Rectangle bounds = context.getUndockedBounds();
            if (bounds != null) {
                Element boundsElement = document.createElement(NODE_UNDOCKED_BOUNDS);
                contextElement.appendChild(boundsElement);
                boundsElement.setAttribute(ATTRIBUTE_X, "" + bounds.x);
                boundsElement.setAttribute(ATTRIBUTE_Y, "" + bounds.y);
                boundsElement.setAttribute(ATTRIBUTE_WIDTH, "" + bounds.width);
                boundsElement.setAttribute(ATTRIBUTE_HEIGHT, "" + bounds.height);
            }
            if (context.getHiddenPreviousState() != null) {
                previousStateElement = document.createElement(NODE_PREVIOUS_STATE);
                contextElement.appendChild(previousStateElement);
                previousStateElement.setAttribute(ATTRIBUTE_TYPE, PREVIOUS_STATE_HIDDEN);
                DockableBarPersistenceUtils.writePreviousState(document, previousStateElement, context.getHiddenPreviousState(), callback);
            }
            if (context.getClosePreviousState() != null) {
                previousStateElement = document.createElement(NODE_PREVIOUS_STATE);
                contextElement.appendChild(previousStateElement);
                previousStateElement.setAttribute(ATTRIBUTE_TYPE, PREVIOUS_STATE_CLOSE);
                DockableBarPersistenceUtils.writePreviousState(document, previousStateElement, context.getClosePreviousState(), callback);
            }
            if (context.getDockPreviousState() != null) {
                previousStateElement = document.createElement(NODE_PREVIOUS_STATE);
                contextElement.appendChild(previousStateElement);
                previousStateElement.setAttribute(ATTRIBUTE_TYPE, PREVIOUS_STATE_DOCK);
                DockableBarPersistenceUtils.writePreviousState(document, previousStateElement, context.getDockPreviousState(), callback);
            }
            if (context.getFloatPreviousState() != null) {
                previousStateElement = document.createElement(NODE_PREVIOUS_STATE);
                contextElement.appendChild(previousStateElement);
                previousStateElement.setAttribute(ATTRIBUTE_TYPE, PREVIOUS_STATE_FLOAT);
                DockableBarPersistenceUtils.writePreviousState(document, previousStateElement, context.getFloatPreviousState(), callback);
            }
            if (callback == null) continue;
            callback.save(document, contextElement, context);
        }
    }

    private static void writePreviousState(Document document, Element element, PreviousState state, PersistenceUtilsCallback.Save callback) {
        element.setAttribute(ATTRIBUTE_MODE, "" + state.mode);
        element.setAttribute(ATTRIBUTE_DOCK_ID, "" + state.dockID);
        element.setAttribute(ATTRIBUTE_SIDE, "" + state.side);
        element.setAttribute(ATTRIBUTE_FC_ID, "" + state.fcID);
        element.setAttribute(ATTRIBUTE_START, "" + state.start);
        element.setAttribute(ATTRIBUTE_ROW, "" + state.row);
        element.setAttribute(ATTRIBUTE_NEW_ROW, state.newRow ? "1" : "0");
        Rectangle bounds = state.rcBounds;
        if (bounds != null) {
            Element boundsElement = document.createElement(NODE_BOUNDS);
            element.appendChild(boundsElement);
            boundsElement.setAttribute(ATTRIBUTE_X, "" + bounds.x);
            boundsElement.setAttribute(ATTRIBUTE_Y, "" + bounds.y);
            boundsElement.setAttribute(ATTRIBUTE_WIDTH, "" + bounds.width);
            boundsElement.setAttribute(ATTRIBUTE_HEIGHT, "" + bounds.height);
        }
        if (state.fcChildren != null) {
            for (Object childDockID : state.fcChildren) {
                Element childElement = document.createElement(NODE_CHILD);
                element.appendChild(childElement);
                childElement.setAttribute(ATTRIBUTE_DOCK_ID, "" + childDockID);
            }
        }
        if (state.parentStates != null) {
            for (Object pState : state.parentStates) {
                if (!(pState instanceof PreviousState.ParentState)) continue;
                Element parentStateElement = document.createElement(NODE_PARENT_STATE);
                element.appendChild(parentStateElement);
                parentStateElement.setAttribute(ATTRIBUTE_CC_ID, "" + ((PreviousState.ParentState)pState).ccID);
                parentStateElement.setAttribute(ATTRIBUTE_DOCK_ID, "" + ((PreviousState.ParentState)pState).myID);
                parentStateElement.setAttribute(ATTRIBUTE_ORIENTATION, "" + ((PreviousState.ParentState)pState).orientation);
                if (((PreviousState.ParentState)pState).ccChildren == null) continue;
                for (Object childDockID : ((PreviousState.ParentState)pState).ccChildren) {
                    Element childElement = document.createElement(NODE_CHILD);
                    parentStateElement.appendChild(childElement);
                    childElement.setAttribute(ATTRIBUTE_DOCK_ID, "" + childDockID);
                }
            }
        }
        if (callback != null) {
            callback.save(document, element, state);
        }
    }

    public static void load(DefaultDockableBarManager manager, InputStream in) throws ParserConfigurationException, SAXException, IOException {
        DockableBarPersistenceUtils.load(manager, in, null);
    }

    public static void load(DefaultDockableBarManager manager, InputStream in, PersistenceUtilsCallback.Load callback) throws ParserConfigurationException, SAXException, IOException {
        DockableBarPersistenceUtils.load(manager, PersistenceUtils.getDocument(in), callback);
    }

    public static void load(DefaultDockableBarManager manager, String fileName) throws ParserConfigurationException, SAXException, IOException {
        DockableBarPersistenceUtils.load(manager, fileName, null);
    }

    public static void load(DefaultDockableBarManager manager, String fileName, PersistenceUtilsCallback.Load callback) throws ParserConfigurationException, SAXException, IOException {
        DockableBarPersistenceUtils.load(manager, PersistenceUtils.getDocument(fileName), callback);
    }

    public static void load(final DefaultDockableBarManager manager, final Document document, final PersistenceUtilsCallback.Load callback) {
        if (SwingUtilities.isEventDispatchThread()) {
            DockableBarPersistenceUtils.internalLoad(manager, document, callback);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DockableBarPersistenceUtils.internalLoad(manager, document, callback);
                }
            });
        }
    }

    static boolean internalLoad(DefaultDockableBarManager manager, Document document, PersistenceUtilsCallback.Load callback) {
        try {
            manager.clearLayout();
            Node component = document.getElementsByTagName("LayoutPersistence").item(0);
            Node dockableBars = null;
            if (component != null) {
                NodeList list = component.getChildNodes();
                for (int index = 0; index < list.getLength(); ++index) {
                    Node node = list.item(index);
                    if (!"DockableBarManager".equals(node.getNodeName())) continue;
                    String persistenceName = null;
                    NamedNodeMap attributes = node.getAttributes();
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        Node attribute = attributes.item(i);
                        if (!"persistenceName".equals(attribute.getNodeName())) continue;
                        persistenceName = attribute.getNodeValue();
                        break;
                    }
                    if (!JideSwingUtilities.equals(persistenceName, manager.getLayoutPersistenceName())) continue;
                    dockableBars = node;
                    break;
                }
            }
            if (dockableBars == null) {
                manager.resetToDefault();
                return false;
            }
            String version = null;
            String frameState = null;
            HiddenDockableBars<String> previousExistingDockableBars = new HiddenDockableBars<String>();
            NamedNodeMap componentAttributes = dockableBars.getAttributes();
            for (int i = 0; i < componentAttributes.getLength(); ++i) {
                Node attribute = componentAttributes.item(i);
                if ("version".equals(attribute.getNodeName())) {
                    version = attribute.getNodeValue();
                }
                if (!ATTRIBUTE_FRAME_STATE.equals(attribute.getNodeName())) continue;
                frameState = attribute.getNodeValue();
            }
            if (version != null) {
                manager.setVersion(Short.valueOf(version));
            }
            if (frameState != null) {
                manager._state = Integer.valueOf(frameState);
            }
            if (manager._floatingDockableBars == null) {
                manager._floatingDockableBars = new FloatingDockableBars();
            }
            NodeList list = dockableBars.getChildNodes();
            for (int index = 0; index < list.getLength(); ++index) {
                Object comp;
                Node node = list.item(index);
                if (NODE_CONTEXT.equals(node.getNodeName())) {
                    DockableBarPersistenceUtils.readContext(document, node, manager.getAllContexts(), callback);
                    continue;
                }
                if (NODE_BOUNDS.equals(node.getNodeName()) && manager.isUseFrameBounds()) {
                    manager._unmaximizedBounds = DockableBarPersistenceUtils.readBounds(node);
                    continue;
                }
                if (NODE_DOCKABLE_BAR_CONTAINER.equals(node.getNodeName())) {
                    DockableBarContainer dockableBarContainer = DockableBarPersistenceUtils.readDockableBarContainer(document, manager, previousExistingDockableBars, node, callback);
                    switch (dockableBarContainer.getSide()) {
                        case 3: {
                            manager._eastDockableBarContainer = dockableBarContainer;
                            break;
                        }
                        case 7: {
                            manager._westDockableBarContainer = dockableBarContainer;
                            break;
                        }
                        case 5: {
                            manager._southDockableBarContainer = dockableBarContainer;
                            break;
                        }
                        case 1: {
                            manager._northDockableBarContainer = dockableBarContainer;
                        }
                    }
                    continue;
                }
                if (!NODE_FLOATING_BAR_CONTAINER.equals(node.getNodeName()) || !((comp = DockableBarPersistenceUtils.readFloatingContainer(document, manager, previousExistingDockableBars, node, callback)) instanceof FloatingDockableBarContainer)) continue;
                ((Window)comp).setVisible(true);
                manager._floatingDockableBars.add(comp);
            }
            if (callback != null && dockableBars instanceof Element) {
                callback.load(document, (Element)dockableBars, manager);
            }
            if (manager.getAllContexts() != null) {
                Set<String> stringSet = manager.getAllContexts().keySet();
                String[] col = stringSet.toArray(new String[stringSet.size()]);
                for (String key : col) {
                    DockableBarFactory factory;
                    DockableBar dockableBar = manager.getDockableBar(key);
                    if (dockableBar == null && (factory = manager.getDockableBarFactory()) != null) {
                        dockableBar = factory.create(key);
                        manager.addDockableBar(dockableBar);
                    }
                    if (dockableBar != null) {
                        dockableBar.setContext(manager.getAllContexts().get(key));
                    }
                    manager._hiddenDockableBars.add(key);
                }
            }
            manager._hiddenDockableBars.removeAll(previousExistingDockableBars);
            if (manager._eastDockableBarContainer == null) {
                manager._eastDockableBarContainer = manager.createDockableBarContainer();
                manager._eastDockableBarContainer.setSide(3);
                manager._eastDockableBarContainer.invalidate();
            }
            if (manager._southDockableBarContainer == null) {
                manager._southDockableBarContainer = manager.createDockableBarContainer();
                manager._southDockableBarContainer.setSide(5);
                manager._southDockableBarContainer.invalidate();
            }
            if (manager._westDockableBarContainer == null) {
                manager._westDockableBarContainer = manager.createDockableBarContainer();
                manager._westDockableBarContainer.setSide(7);
                manager._westDockableBarContainer.invalidate();
            }
            if (manager._northDockableBarContainer == null) {
                manager._northDockableBarContainer = manager.createDockableBarContainer();
                manager._northDockableBarContainer.setSide(1);
                manager._northDockableBarContainer.invalidate();
            }
            manager.getContentContainer().add((Component)manager._eastDockableBarContainer, "East");
            manager.getContentContainer().add((Component)manager._southDockableBarContainer, "South");
            manager.getContentContainer().add((Component)manager._westDockableBarContainer, "West");
            manager.getContentContainer().add((Component)manager._northDockableBarContainer, "North");
            for (int i = manager._hiddenDockableBars.size() - 1; i >= 0; --i) {
                String name = (String)manager._hiddenDockableBars.get(i);
                DockableBar bar = manager.getDockableBar(name);
                if (bar == null || bar.isHidden()) continue;
                manager.showDockableBar(bar);
            }
            manager.setBoundsState();
            manager.setRealized(true);
            return true;
        }
        catch (Exception e) {
            manager.resetToDefault();
            return false;
        }
    }

    private static FloatingDockableBarContainer readFloatingContainer(Document document, DockableBarManager dockableBarManager, HiddenDockableBars<String> previousExistingDockableBars, Node node, PersistenceUtilsCallback.Load callback) {
        FloatingDockableBarContainer floatingContainer = dockableBarManager.getRootPaneContainer() instanceof Dialog ? dockableBarManager.createFloatingDockableBarContainer((Dialog)((Object)dockableBarManager.getRootPaneContainer())) : (dockableBarManager.getRootPaneContainer() instanceof Applet ? dockableBarManager.createFloatingDockableBarContainer(JideSwingUtilities.getFrame((Applet)((Object)dockableBarManager.getRootPaneContainer()))) : dockableBarManager.createFloatingDockableBarContainer((Frame)((Object)dockableBarManager.getRootPaneContainer())));
        NodeList list = node.getChildNodes();
        for (int index = 0; index < list.getLength(); ++index) {
            Node childNode = list.item(index);
            if (NODE_DOCKABLE_BAR.equals(childNode.getNodeName())) {
                DockableBar dockableBar = DockableBarPersistenceUtils.readDockableBar(document, dockableBarManager, previousExistingDockableBars, childNode, callback);
                floatingContainer.getContentPane().add(dockableBar);
                dockableBar.setOrientation(0);
                if (dockableBar.isHidden()) continue;
                try {
                    dockableBar.setFloating();
                }
                catch (PropertyVetoException propertyVetoException) {}
                continue;
            }
            if (!NODE_BOUNDS.equals(childNode.getNodeName())) continue;
            floatingContainer.setBounds(PortingUtils.overlapWithScreenBounds(floatingContainer, DockableBarPersistenceUtils.readBounds(childNode)));
        }
        if (floatingContainer.getContentPane().getComponentCount() == 0) {
            floatingContainer.dispose();
            return null;
        }
        if (callback != null && node instanceof Element) {
            callback.load(document, (Element)node, floatingContainer);
        }
        return floatingContainer;
    }

    private static DockableBarContainer readDockableBarContainer(Document document, DefaultDockableBarManager dockableBarManager, HiddenDockableBars<String> previousExistingDockableBars, Node node, PersistenceUtilsCallback.Load callback) {
        DockableBarContainer dockableBarContainer = dockableBarManager.createDockableBarContainer();
        String side = null;
        NamedNodeMap attributes = node.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (!ATTRIBUTE_SIDE.equals(attribute.getNodeName())) continue;
            side = attribute.getNodeValue();
        }
        if (side != null) {
            dockableBarContainer.setSide(Integer.valueOf(side));
        }
        NodeList nodes = node.getChildNodes();
        DockableBarListList listList = new DockableBarListList(dockableBarContainer);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node listNode = nodes.item(i);
            if (!NODE_DOCKABLE_BAR_LIST.equals(listNode.getNodeName())) continue;
            DockableBarList list = new DockableBarList(listList);
            listList.add(list);
            NodeList listNodes = listNode.getChildNodes();
            for (int j = 0; j < listNodes.getLength(); ++j) {
                Node itemNode = listNodes.item(j);
                if (!NODE_DOCKABLE_BAR_ITEM.equals(itemNode.getNodeName())) continue;
                String start = null;
                DockableBar bar = null;
                NamedNodeMap itemAttributes = itemNode.getAttributes();
                for (int k = 0; k < itemAttributes.getLength(); ++k) {
                    Node attribute = itemAttributes.item(k);
                    if (!ATTRIBUTE_START.equals(attribute.getNodeName())) continue;
                    start = attribute.getNodeValue();
                }
                NodeList barNodes = itemNode.getChildNodes();
                for (int k = 0; k < barNodes.getLength(); ++k) {
                    Node barNode = barNodes.item(k);
                    if (!NODE_DOCKABLE_BAR.equals(barNode.getNodeName())) continue;
                    bar = DockableBarPersistenceUtils.readDockableBar(document, dockableBarManager, previousExistingDockableBars, barNode, callback);
                }
                if (start == null || bar == null) continue;
                try {
                    if (dockableBarContainer.getOrientation() == 0) {
                        bar.setHoriDocked();
                    } else {
                        bar.setVertDocked();
                    }
                }
                catch (PropertyVetoException k) {
                    // empty catch block
                }
                DockableBarItem item = new DockableBarItem(bar, Integer.valueOf(start));
                list.add(item);
            }
        }
        dockableBarContainer.setDockableBarList(listList);
        if (callback != null && node instanceof Element) {
            callback.load(document, (Element)node, dockableBarContainer);
        }
        return dockableBarContainer;
    }

    private static DockableBar readDockableBar(Document document, DockableBarManager dockableBarManager, HiddenDockableBars<String> previousExistingDockableBars, Node node, PersistenceUtilsCallback.Load callback) {
        String key = null;
        String preferredRowCount = null;
        NamedNodeMap attributes = node.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (ATTRIBUTE_KEY.equals(attribute.getNodeName())) {
                key = attribute.getNodeValue();
                continue;
            }
            if (!ATTRIBUTE_PREFERRED_ROW_COUNT.equals(attribute.getNodeName())) continue;
            preferredRowCount = attribute.getNodeValue();
        }
        if (key == null) {
            return null;
        }
        DockableBar bar = dockableBarManager.getDockableBar(key);
        if (bar != null) {
            DockableBarContext dockContext = dockableBarManager.getDockableBarContextOf(key);
            if (dockContext != null) {
                bar.setContext(dockContext);
                if (dockContext.isVertDocked()) {
                    bar.setOrientation(1);
                } else {
                    bar.setOrientation(0);
                }
            } else {
                System.err.println("DockableBarContext shouldn't be null");
            }
            if (!bar.isHidden()) {
                previousExistingDockableBars.add(key);
            }
            bar.setVisible(!bar.isHidden());
            if (bar instanceof CommandBar && preferredRowCount != null) {
                ((CommandBar)bar).setPreferredRowCount(Integer.valueOf(preferredRowCount));
            }
            if (callback != null && node instanceof Element) {
                callback.load(document, (Element)node, bar);
            }
        }
        return bar;
    }

    private static Rectangle readBounds(Node node) {
        String x = null;
        String y = null;
        String width = null;
        String height = null;
        NamedNodeMap attributes = node.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (ATTRIBUTE_X.equals(attribute.getNodeName())) {
                x = attribute.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_Y.equals(attribute.getNodeName())) {
                y = attribute.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_WIDTH.equals(attribute.getNodeName())) {
                width = attribute.getNodeValue();
                continue;
            }
            if (!ATTRIBUTE_HEIGHT.equals(attribute.getNodeName())) continue;
            height = attribute.getNodeValue();
        }
        Rectangle bounds = new Rectangle();
        if (x != null) {
            bounds.x = Integer.valueOf(x);
        }
        if (y != null) {
            bounds.y = Integer.valueOf(y);
        }
        if (width != null) {
            bounds.width = Integer.valueOf(width);
        }
        if (height != null) {
            bounds.height = Integer.valueOf(height);
        }
        return bounds;
    }

    private static String readContext(Document document, Node node, Map<String, DockableBarContext> contexts, PersistenceUtilsCallback.Load callback) {
        DockableBarContext previousContext;
        DockableBarContext context = new DockableBarContext();
        String key = null;
        String dockID = null;
        String initSide = null;
        String initIndex = null;
        String initPosition = null;
        String initMode = null;
        String currentMode = null;
        String currentDockSide = null;
        String dockedWidth = null;
        String dockedHeight = null;
        NamedNodeMap attributes = node.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (ATTRIBUTE_KEY.equals(attribute.getNodeName())) {
                key = attribute.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_DOCK_ID.equals(attribute.getNodeName())) {
                dockID = attribute.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_INIT_SIDE.equals(attribute.getNodeName())) {
                initSide = attribute.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_INIT_INDEX.equals(attribute.getNodeName())) {
                initIndex = attribute.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_INIT_POSITION.equals(attribute.getNodeName())) {
                initPosition = attribute.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_INIT_MODE.equals(attribute.getNodeName())) {
                initMode = attribute.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_CURRENT_MODE.equals(attribute.getNodeName())) {
                currentMode = attribute.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_CURRENT_DOCK_SIDE.equals(attribute.getNodeName())) {
                currentDockSide = attribute.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_DOCKED_WIDTH.equals(attribute.getNodeName())) {
                dockedWidth = attribute.getNodeValue();
                continue;
            }
            if (!ATTRIBUTE_DOCKED_HEIGHT.equals(attribute.getNodeName())) continue;
            dockedHeight = attribute.getNodeValue();
        }
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node childNode = nodes.item(i);
            if (NODE_UNDOCKED_BOUNDS.equals(childNode.getNodeName())) {
                context.setUndockedBounds(DockableBarPersistenceUtils.readBounds(childNode));
                continue;
            }
            if (!NODE_PREVIOUS_STATE.equals(childNode.getNodeName())) continue;
            NamedNodeMap childNodeAttributes = childNode.getAttributes();
            for (int j = 0; j < childNodeAttributes.getLength(); ++j) {
                Node attribute = childNodeAttributes.item(j);
                if (!ATTRIBUTE_TYPE.equals(attribute.getNodeName())) continue;
                String type = attribute.getNodeValue();
                if (PREVIOUS_STATE_HIDDEN.equals(type)) {
                    context.setHiddenPreviousState(DockableBarPersistenceUtils.readPreviousState(document, childNode, callback));
                    continue;
                }
                if (PREVIOUS_STATE_DOCK.equals(type)) {
                    context.setDockPreviousState(DockableBarPersistenceUtils.readPreviousState(document, childNode, callback));
                    continue;
                }
                if (PREVIOUS_STATE_CLOSE.equals(type)) {
                    context.setClosePreviousState(DockableBarPersistenceUtils.readPreviousState(document, childNode, callback));
                    continue;
                }
                if (!PREVIOUS_STATE_FLOAT.equals(type)) continue;
                context.setFloatPreviousState(DockableBarPersistenceUtils.readPreviousState(document, childNode, callback));
            }
        }
        if (dockID != null) {
            context.setDockID(Integer.valueOf(dockID));
        }
        if (initSide != null) {
            context.setInitSide(Integer.valueOf(initSide));
        }
        if (initIndex != null) {
            context.setInitIndex(Integer.valueOf(initIndex));
        }
        context.setInitPosition("1".equals(initPosition));
        if (initMode != null) {
            context.setInitMode(Integer.valueOf(initMode));
        }
        if (currentMode != null) {
            context.setCurrentMode(Integer.valueOf(currentMode));
        }
        if (currentDockSide != null) {
            context.setCurrentDockSide(Integer.valueOf(currentDockSide));
        }
        if (dockedWidth != null) {
            context.setDockedWidth(Integer.valueOf(dockedWidth));
        }
        if (dockedHeight != null) {
            context.setDockedHeight(Integer.valueOf(dockedHeight));
        }
        if ((previousContext = contexts.remove(key)) instanceof DockableBarContext) {
            context.setInitIndex(previousContext.getInitIndex());
            context.setInitMode(previousContext.getInitMode());
            context.setInitSide(previousContext.getInitSide());
            context.setInitSubindex(previousContext.getInitSubindex());
        }
        contexts.put(key, context);
        if (callback != null && node instanceof Element) {
            callback.load(document, (Element)node, context);
        }
        return key;
    }

    private static PreviousState readPreviousState(Document document, Node node, PersistenceUtilsCallback.Load callback) {
        PreviousState state = new PreviousState();
        NamedNodeMap attributes = node.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (ATTRIBUTE_MODE.equals(attribute.getNodeName())) {
                state.mode = Integer.valueOf(attribute.getNodeValue());
                continue;
            }
            if (ATTRIBUTE_DOCK_ID.equals(attribute.getNodeName())) {
                state.dockID = Integer.valueOf(attribute.getNodeValue());
                continue;
            }
            if (ATTRIBUTE_START.equals(attribute.getNodeName())) {
                state.start = Integer.valueOf(attribute.getNodeValue());
                continue;
            }
            if (ATTRIBUTE_SIDE.equals(attribute.getNodeName())) {
                state.side = Integer.valueOf(attribute.getNodeValue());
                continue;
            }
            if (ATTRIBUTE_ROW.equals(attribute.getNodeName())) {
                state.row = Integer.valueOf(attribute.getNodeValue());
                continue;
            }
            if (ATTRIBUTE_NEW_ROW.equals(attribute.getNodeName())) {
                state.newRow = "1".equals(attribute.getNodeValue());
                continue;
            }
            if (!ATTRIBUTE_FC_ID.equals(attribute.getNodeName())) continue;
            state.fcID = Integer.valueOf(attribute.getNodeValue());
        }
        state.fcChildren = new ArrayList();
        state.parentStates = new ArrayList();
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node childNode = nodes.item(i);
            if (NODE_BOUNDS.equals(childNode.getNodeName())) {
                state.rcBounds = DockableBarPersistenceUtils.readBounds(childNode);
                continue;
            }
            if (NODE_CHILD.equals(childNode.getNodeName())) {
                NamedNodeMap childAttributes = childNode.getAttributes();
                for (int j = 0; j < childAttributes.getLength(); ++j) {
                    Node attribute = childAttributes.item(j);
                    if (!ATTRIBUTE_DOCK_ID.equals(attribute.getNodeName())) continue;
                    state.fcChildren.add(Integer.valueOf(attribute.getNodeValue()));
                }
                continue;
            }
            if (!NODE_PARENT_STATE.equals(childNode.getNodeName())) continue;
            state.parentStates.add(DockableBarPersistenceUtils.readParentState(childNode));
        }
        if (callback != null && node instanceof Element) {
            callback.load(document, (Element)node, state);
        }
        return state;
    }

    private static PreviousState.ParentState readParentState(Node node) {
        PreviousState.ParentState pState = new PreviousState.ParentState();
        NamedNodeMap attributes = node.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (ATTRIBUTE_CC_ID.equals(attribute.getNodeName())) {
                pState.ccID = Integer.valueOf(attribute.getNodeValue());
                continue;
            }
            if (ATTRIBUTE_DOCK_ID.equals(attribute.getNodeName())) {
                pState.myID = Integer.valueOf(attribute.getNodeValue());
                continue;
            }
            if (!ATTRIBUTE_ORIENTATION.equals(attribute.getNodeName())) continue;
            pState.orientation = Integer.valueOf(attribute.getNodeValue());
        }
        pState.ccChildren = new ArrayList();
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node childNode = nodes.item(i);
            if (!NODE_CHILD.equals(childNode.getNodeName())) continue;
            NamedNodeMap childAttributes = childNode.getAttributes();
            for (int j = 0; j < childAttributes.getLength(); ++j) {
                Node attribute = childAttributes.item(j);
                if (!ATTRIBUTE_DOCK_ID.equals(attribute.getNodeName())) continue;
                pState.ccChildren.add(Integer.valueOf(attribute.getNodeValue()));
            }
        }
        return pState;
    }
}

