/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.rof;

import de.schlichtherle.io.rof.AbstractReadOnlyFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class MemoryMappedReadOnlyFile
extends AbstractReadOnlyFile {
    private static final int WINDOW_LEN = Integer.MAX_VALUE;
    private FileChannel channel;
    private long windowOff = -1L;
    private ByteBuffer window;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MemoryMappedReadOnlyFile(File file) throws FileNotFoundException {
        this.channel = new FileInputStream(file).getChannel();
        try {
            this.window(0L);
        }
        catch (IOException iOException) {
            FileNotFoundException fileNotFoundException = new FileNotFoundException(iOException.toString());
            fileNotFoundException.initCause(iOException);
            throw fileNotFoundException;
        }
        if (!$assertionsDisabled && this.window == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.windowOff != 0L) {
            throw new AssertionError();
        }
    }

    private final int available() throws IOException {
        this.ensureOpen();
        if (this.window.remaining() <= 0) {
            this.window(this.windowOff + Integer.MAX_VALUE);
        }
        return this.window.remaining();
    }

    private void window(long l) throws IOException {
        if (this.windowOff == l) {
            return;
        }
        long l2 = this.channel.size();
        if (l > l2) {
            l = l2;
        }
        this.window = this.channel.map(FileChannel.MapMode.READ_ONLY, l, Math.min(l2 - l, Integer.MAX_VALUE));
        if (!$assertionsDisabled && this.window == null) {
            throw new AssertionError();
        }
        this.windowOff = l;
    }

    public long length() throws IOException {
        this.ensureOpen();
        return this.channel.size();
    }

    public long getFilePointer() throws IOException {
        this.ensureOpen();
        return this.windowOff + (long)this.window.position();
    }

    public void seek(long l) throws IOException {
        this.ensureOpen();
        if (l < 0L) {
            throw new IOException("file pointer must not be negative");
        }
        long l2 = this.length();
        if (l > l2) {
            throw new IOException("file pointer (" + l + ") is larger than file length (" + l2 + ")");
        }
        this.window(l / Integer.MAX_VALUE * Integer.MAX_VALUE);
        this.window.position((int)(l % Integer.MAX_VALUE));
    }

    public int read() throws IOException {
        return this.available() > 0 ? this.window.get() & 0xFF : -1;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return 0;
        }
        int n3 = this.available();
        if (n3 <= 0) {
            return -1;
        }
        if (byArray == null) {
            throw new NullPointerException("buf");
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 > n3) {
            n2 = n3;
        }
        this.window.get(byArray, n, n2);
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.channel == null) {
            return;
        }
        this.window = null;
        try {
            this.channel.close();
        }
        finally {
            this.channel = null;
            System.gc();
            System.runFinalization();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private final void ensureOpen() throws IOException {
        if (this.channel == null) {
            throw new IOException("file is closed");
        }
    }

    static {
        $assertionsDisabled = !MemoryMappedReadOnlyFile.class.desiredAssertionStatus();
    }
}

