/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.archive.spi;

import de.schlichtherle.io.ArchiveEntryMetaData;
import de.schlichtherle.io.archive.spi.ArchiveEntry;
import java.io.File;
import javax.swing.Icon;

public class RfsEntry
implements ArchiveEntry {
    private final String entryName;
    private final File file;

    public RfsEntry(File file) {
        this(file, RfsEntry.getName(file));
    }

    public RfsEntry(File file, String string) {
        if (string == null || file == null) {
            throw new NullPointerException();
        }
        this.entryName = string;
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    private static String getName(File file) {
        String string = file.getPath().replace(File.separatorChar, '/');
        if (file.isDirectory()) {
            return string + '/';
        }
        return string;
    }

    public String getName() {
        return this.entryName;
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public long getSize() {
        return this.file.length();
    }

    public long getTime() {
        return this.file.lastModified();
    }

    public void setTime(long l) {
        this.file.setLastModified(l);
    }

    public Icon getOpenIcon() {
        return null;
    }

    public Icon getClosedIcon() {
        return null;
    }

    public ArchiveEntryMetaData getMetaData() {
        return null;
    }

    public void setMetaData(ArchiveEntryMetaData archiveEntryMetaData) {
    }
}

