/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io;

import de.schlichtherle.io.ArchiveEntryStreamClosedException;
import de.schlichtherle.io.ArchiveException;
import de.schlichtherle.io.ArchiveWarningException;
import de.schlichtherle.io.File;
import de.schlichtherle.io.archive.Archive;
import de.schlichtherle.io.archive.spi.ArchiveEntry;
import de.schlichtherle.io.archive.spi.OutputArchive;
import de.schlichtherle.io.util.SynchronizedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class OutputArchiveMetaData {
    private static final String CLASS_NAME;
    private static final Logger logger;
    private final Archive archive;
    private final OutputArchive outArchive;
    private final Map streams;
    private volatile boolean stopped;
    static final /* synthetic */ boolean $assertionsDisabled;

    OutputArchiveMetaData(Archive archive, OutputArchive outputArchive) {
        AbstractMap abstractMap = this.streams = File.isLenient() ? new WeakHashMap() : new HashMap();
        if (!$assertionsDisabled && outputArchive == null) {
            throw new AssertionError();
        }
        this.archive = archive;
        this.outArchive = outputArchive;
    }

    synchronized OutputStream createOutputStream(ArchiveEntry archiveEntry, ArchiveEntry archiveEntry2) throws IOException {
        if (!$assertionsDisabled && this.stopped) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && archiveEntry == null) {
            throw new AssertionError();
        }
        OutputStream outputStream = this.outArchive.getOutputStream(archiveEntry, archiveEntry2);
        return outputStream != null ? new EntryOutputStream(outputStream) : null;
    }

    synchronized int waitAllOutputStreamsByOtherThreads(long l) {
        if (!$assertionsDisabled && this.stopped) {
            throw new AssertionError();
        }
        long l2 = System.currentTimeMillis();
        int n = this.threadStreams();
        try {
            while (this.streams.size() > n) {
                long l3;
                if (l > 0L) {
                    l3 = l - (System.currentTimeMillis() - l2);
                    if (l3 <= 0L) {
                        break;
                    }
                } else {
                    l3 = 0L;
                }
                if (File.isLenient()) {
                    System.gc();
                    System.runFinalization();
                }
                this.wait(l3);
            }
        }
        catch (InterruptedException interruptedException) {
            logger.warning("interrupted");
        }
        return this.streams.size();
    }

    private int threadStreams() {
        Thread thread = Thread.currentThread();
        int n = 0;
        Iterator iterator = this.streams.values().iterator();
        while (iterator.hasNext()) {
            Thread thread2 = (Thread)iterator.next();
            if (thread != thread2) continue;
            ++n;
        }
        return n;
    }

    synchronized ArchiveException closeAllOutputStreams(ArchiveException archiveException) {
        if (!$assertionsDisabled && this.stopped) {
            throw new AssertionError();
        }
        this.stopped = true;
        Iterator iterator = this.streams.keySet().iterator();
        while (iterator.hasNext()) {
            EntryOutputStream entryOutputStream = (EntryOutputStream)iterator.next();
            try {
                entryOutputStream.doClose();
            }
            catch (IOException iOException) {
                archiveException = new ArchiveWarningException(archiveException, iOException);
            }
        }
        this.streams.clear();
        return archiveException;
    }

    static {
        $assertionsDisabled = !OutputArchiveMetaData.class.desiredAssertionStatus();
        CLASS_NAME = "de/schlichtherle/io/OutputArchiveMetaData".replace('/', '.');
        logger = Logger.getLogger(CLASS_NAME, CLASS_NAME);
    }

    private final class EntryOutputStream
    extends SynchronizedOutputStream {
        private boolean closed;
        static final /* synthetic */ boolean $assertionsDisabled;

        private EntryOutputStream(OutputStream outputStream) {
            super(outputStream, OutputArchiveMetaData.this);
            if (!$assertionsDisabled && outputStream == null) {
                throw new AssertionError();
            }
            OutputArchiveMetaData.this.streams.put(this, Thread.currentThread());
            OutputArchiveMetaData.this.notify();
        }

        private final void ensureNotStopped() throws IOException {
            if (OutputArchiveMetaData.this.stopped) {
                throw new ArchiveEntryStreamClosedException();
            }
        }

        public void write(int n) throws IOException {
            this.ensureNotStopped();
            super.write(n);
        }

        public void write(byte[] byArray) throws IOException {
            this.ensureNotStopped();
            super.write(byArray);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.ensureNotStopped();
            super.write(byArray, n, n2);
        }

        public void flush() throws IOException {
            this.ensureNotStopped();
            super.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void close() throws IOException {
            if (!$assertionsDisabled && OutputArchiveMetaData.this != this.lock) {
                throw new AssertionError();
            }
            OutputArchiveMetaData outputArchiveMetaData = OutputArchiveMetaData.this;
            synchronized (outputArchiveMetaData) {
                if (this.closed) {
                    return;
                }
                try {
                    this.doClose();
                }
                finally {
                    OutputArchiveMetaData.this.streams.remove(this);
                    OutputArchiveMetaData.this.notify();
                }
            }
        }

        protected void doClose() throws IOException {
            if (!$assertionsDisabled && this.closed) {
                throw new AssertionError();
            }
            this.closed = true;
            super.doClose();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                if (this.closed) {
                    return;
                }
                logger.finer("finalize.open");
                try {
                    this.doClose();
                }
                catch (IOException iOException) {
                    logger.log(Level.FINE, "finalize.exception", iOException);
                }
            }
            finally {
                super.finalize();
            }
        }

        static {
            $assertionsDisabled = !(class$de$schlichtherle$io$OutputArchiveMetaData == null ? (class$de$schlichtherle$io$OutputArchiveMetaData = OutputArchiveMetaData.class$("de.schlichtherle.io.OutputArchiveMetaData")) : class$de$schlichtherle$io$OutputArchiveMetaData).desiredAssertionStatus();
        }
    }
}

