/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io;

import de.schlichtherle.io.ArchiveController;
import de.schlichtherle.io.ArchiveException;
import de.schlichtherle.io.ArchiveStatistics;
import de.schlichtherle.io.ChainableIOException;
import de.schlichtherle.io.CountingOutputStream;
import de.schlichtherle.io.CountingReadOnlyFile;
import de.schlichtherle.io.File;
import de.schlichtherle.io.Files;
import de.schlichtherle.io.UpdatingArchiveController;
import de.schlichtherle.io.archive.spi.ArchiveDriver;
import de.schlichtherle.key.PromptingKeyManager;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

final class ArchiveControllers {
    private static final String CLASS_NAME;
    private static final Logger logger;
    private static final Map controllers;
    private static final Comparator REVERSE_CONTROLLERS;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$de$schlichtherle$key$PromptingKeyManager;

    private ArchiveControllers() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static ArchiveController get(File file) {
        boolean bl;
        ArchiveController archiveController;
        ArchiveDriver archiveDriver;
        java.io.File file2;
        block28: {
            Object v;
            block27: {
                if (!$assertionsDisabled && file == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && !file.isArchive()) {
                    throw new AssertionError();
                }
                file2 = file.getDelegate();
                try {
                    file2 = file2.getCanonicalFile();
                }
                catch (IOException iOException) {
                    file2 = Files.normalize(file2.getAbsoluteFile());
                }
                archiveDriver = file.getArchiveDetector().getArchiveDriver(file2.getPath());
                archiveController = null;
                bl = false;
                Map map = controllers;
                // MONITORENTER : map
                v = controllers.get(file2);
                if (!(v instanceof Reference)) break block27;
                archiveController = (ArchiveController)((Reference)v).get();
                if (archiveController == null) break block28;
                bl = archiveController.getDriver() != archiveDriver;
                ArchiveController archiveController2 = archiveController;
                // MONITOREXIT : map
                if (!bl) return archiveController2;
                archiveController.writeLock().lock();
                try {
                    archiveController.setDriver(archiveDriver);
                    return archiveController2;
                }
                finally {
                    archiveController.writeLock().unlock();
                }
            }
            if (v != null) {
                ArchiveController archiveController3 = (ArchiveController)v;
                // MONITOREXIT : map
                if (!bl) return archiveController3;
                archiveController.writeLock().lock();
                try {
                    archiveController.setDriver(archiveDriver);
                    return archiveController3;
                }
                finally {
                    archiveController.writeLock().unlock();
                }
            }
        }
        try {
            String string;
            ArchiveController archiveController4;
            File file3 = file.getEnclArchive();
            if (file3 != null) {
                archiveController4 = file3.getArchiveController();
                string = file.getEnclEntryName();
            } else {
                archiveController4 = null;
                string = null;
            }
            archiveController = new UpdatingArchiveController(file2, archiveController4, string, archiveDriver);
            // MONITOREXIT : map
            return archiveController;
        }
        finally {
            if (bl) {
                archiveController.writeLock().lock();
                try {
                    archiveController.setDriver(archiveDriver);
                }
                finally {
                    archiveController.writeLock().unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void set(java.io.File file, Object object) {
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && file instanceof File) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || object instanceof ArchiveController || ((WeakReference)object).get() instanceof ArchiveController)) {
            throw new AssertionError();
        }
        Map map = controllers;
        synchronized (map) {
            controllers.put(file, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void umount(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws ArchiveException {
        if (string == null) {
            throw new NullPointerException();
        }
        if (!bl2 && bl4) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        int n2 = 0;
        logger.log(Level.FINE, "update.entering", new Object[]{string, bl, bl2, bl3, bl4, bl5});
        try {
            CountingReadOnlyFile.init();
            CountingOutputStream.init();
            try {
                ChainableIOException chainableIOException = null;
                ControllerEnumeration controllerEnumeration = new ControllerEnumeration(string, REVERSE_CONTROLLERS);
                while (controllerEnumeration.hasMoreElements()) {
                    ArchiveController archiveController = (ArchiveController)controllerEnumeration.nextElement();
                    archiveController.writeLock().lock();
                    try {
                        if (archiveController.isTouched()) {
                            ++n2;
                        }
                        try {
                            archiveController.umount((ArchiveException)chainableIOException, bl, bl2, bl3, bl4, bl5, true);
                        }
                        catch (ArchiveException archiveException) {
                            chainableIOException = archiveException;
                        }
                    }
                    finally {
                        archiveController.writeLock().unlock();
                    }
                    ++n;
                }
                if (chainableIOException != null) {
                    throw (ArchiveException)chainableIOException.sortPriority();
                }
            }
            finally {
                CountingReadOnlyFile.resetOnInit();
                CountingOutputStream.resetOnInit();
            }
        }
        catch (ArchiveException archiveException) {
            logger.log(Level.FINE, "update.throwing", archiveException);
            throw archiveException;
        }
        logger.log(Level.FINE, "update.exiting", new Object[]{new Integer(n), new Integer(n2)});
    }

    static final ArchiveStatistics getLiveArchiveStatistics() {
        return LiveArchiveStatistics.SINGLETON;
    }

    static {
        $assertionsDisabled = !ArchiveControllers.class.desiredAssertionStatus();
        CLASS_NAME = "de/schlichtherle/io/ArchiveControllers".replace('/', '.');
        logger = Logger.getLogger(CLASS_NAME, CLASS_NAME);
        controllers = new WeakHashMap();
        REVERSE_CONTROLLERS = new Comparator(){

            public int compare(Object object, Object object2) {
                return ((ArchiveController)object2).getTarget().compareTo(((ArchiveController)object).getTarget());
            }
        };
        Runtime.getRuntime().addShutdownHook(ShutdownHook.SINGLETON);
    }

    private static final class ControllerEnumeration
    implements Enumeration {
        private final Iterator it;
        static final /* synthetic */ boolean $assertionsDisabled;

        ControllerEnumeration() {
            this("", null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ControllerEnumeration(String string, Comparator comparator) {
            AbstractSet abstractSet;
            if (!$assertionsDisabled && string == null) {
                throw new AssertionError();
            }
            Map map = controllers;
            synchronized (map) {
                abstractSet = comparator != null ? new TreeSet(comparator) : new HashSet((int)((float)controllers.size() / 0.75f));
                Iterator iterator = controllers.values().iterator();
                while (iterator.hasNext()) {
                    Object object = iterator.next();
                    if (object instanceof Reference && (object = ((Reference)object).get()) == null) continue;
                    if (!$assertionsDisabled && object == null) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && !(object instanceof ArchiveController)) {
                        throw new AssertionError();
                    }
                    if (!((ArchiveController)object).getPath().startsWith(string)) continue;
                    abstractSet.add(object);
                }
            }
            this.it = abstractSet.iterator();
        }

        public boolean hasMoreElements() {
            return this.it.hasNext();
        }

        public Object nextElement() {
            return this.it.next();
        }

        static {
            $assertionsDisabled = !(class$de$schlichtherle$io$ArchiveControllers == null ? (class$de$schlichtherle$io$ArchiveControllers = ArchiveControllers.class$("de.schlichtherle.io.ArchiveControllers")) : class$de$schlichtherle$io$ArchiveControllers).desiredAssertionStatus();
        }
    }

    private static final class LiveArchiveStatistics
    implements ArchiveStatistics {
        private static final LiveArchiveStatistics SINGLETON = new LiveArchiveStatistics();

        private LiveArchiveStatistics() {
        }

        public long getUpdateTotalByteCountRead() {
            return CountingReadOnlyFile.getTotal();
        }

        public long getUpdateTotalByteCountWritten() {
            return CountingOutputStream.getTotal();
        }

        public int getArchivesTotal() {
            return controllers.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getArchivesTouched() {
            int n = 0;
            ControllerEnumeration controllerEnumeration = new ControllerEnumeration();
            while (controllerEnumeration.hasMoreElements()) {
                ArchiveController archiveController = (ArchiveController)controllerEnumeration.nextElement();
                archiveController.readLock().lock();
                try {
                    if (!archiveController.isTouched()) continue;
                    ++n;
                }
                finally {
                    archiveController.readLock().unlock();
                }
            }
            return n;
        }

        public int getTopLevelArchivesTotal() {
            int n = 0;
            ControllerEnumeration controllerEnumeration = new ControllerEnumeration();
            while (controllerEnumeration.hasMoreElements()) {
                ArchiveController archiveController = (ArchiveController)controllerEnumeration.nextElement();
                if (archiveController.getEnclController() != null) continue;
                ++n;
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getTopLevelArchivesTouched() {
            int n = 0;
            ControllerEnumeration controllerEnumeration = new ControllerEnumeration();
            while (controllerEnumeration.hasMoreElements()) {
                ArchiveController archiveController = (ArchiveController)controllerEnumeration.nextElement();
                archiveController.readLock().lock();
                try {
                    if (archiveController.getEnclController() != null || !archiveController.isTouched()) continue;
                    ++n;
                }
                finally {
                    archiveController.readLock().unlock();
                }
            }
            return n;
        }
    }

    static final class ShutdownHook
    extends Thread {
        private static final ShutdownHook SINGLETON = new ShutdownHook();
        static final Set deleteOnExit = Collections.synchronizedSet(new LinkedHashSet());

        private ShutdownHook() {
            super("TrueZIP ArchiveController Shutdown Hook");
            this.setPriority(10);
            PromptingKeyManager.getInstance();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Class clazz = class$de$schlichtherle$key$PromptingKeyManager == null ? (class$de$schlichtherle$key$PromptingKeyManager = ArchiveControllers.class$("de.schlichtherle.key.PromptingKeyManager")) : class$de$schlichtherle$key$PromptingKeyManager;
            synchronized (clazz) {
                try {
                    PromptingKeyManager.setPrompting(false);
                    logger.setLevel(Level.OFF);
                    Iterator iterator = deleteOnExit.iterator();
                    while (iterator.hasNext()) {
                        File file = (File)iterator.next();
                        if (!file.exists() || file.delete()) continue;
                        System.err.println(file.getPath() + ": failed to deleteOnExit()!");
                    }
                }
                finally {
                    try {
                        ArchiveControllers.umount("", false, true, false, true, true);
                    }
                    catch (ArchiveException archiveException) {
                        archiveException.printStackTrace();
                    }
                }
            }
        }
    }
}

