/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.util;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.w3c.css.parser.CssSelectors;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.Messages;

public class Warning
implements Comparable<Warning> {
    String sourceFile;
    int hashSource = 0;
    int level = 0;
    int line = 0;
    CssSelectors selector;
    String warningMessage;
    String warningType = null;
    private static HashMap<String, String[]> warningMessages = new HashMap();
    private static HashMap<String, int[]> warningOrder = new HashMap();

    public Warning(String sourceFile, int line, String warningMessage, int level, String[] messages, ApplContext ac) {
        this.sourceFile = sourceFile;
        this.hashSource = sourceFile.hashCode() % 100;
        this.line = line;
        this.warningType = warningMessage;
        this.warningMessage = this.warn(warningMessage, messages, ac);
        this.level = this.getLevel(warningMessage, level, ac);
    }

    public Warning(String sourceFile, int line, String warningMessage, int level, ApplContext ac) {
        this(sourceFile, line, warningMessage, level, null, ac);
    }

    public Warning(CssProperty property, String warningMessage, int level, String[] messages, ApplContext ac) {
        this.sourceFile = property.getSourceFile();
        if (this.sourceFile != null) {
            this.hashSource = this.sourceFile.hashCode() % 100;
        }
        this.warningType = warningMessage;
        this.warningMessage = this.warn(warningMessage, messages, ac);
        this.level = this.getLevel(warningMessage, level, ac);
        this.line = property.getLine();
    }

    public Warning(CssProperty property, String warningMessage, int level, ApplContext ac) {
        this(property, warningMessage, level, new String[]{property.getPropertyName()}, ac);
        this.selector = property.getSelectors();
    }

    public Warning(CssProperty property, String warningMessage, int level, CssProperty property2, ApplContext ac) {
        this(property, warningMessage, level, new String[]{property.getPropertyName(), property2.getPropertyName()}, ac);
        this.selector = property.getSelectors();
    }

    @Override
    public int compareTo(Warning w) {
        int o;
        int wo = w.getInternalOrder();
        if (wo == (o = this.getInternalOrder())) {
            return 0;
        }
        if (o < wo) {
            return -1;
        }
        return 1;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public String getSourceFileEscaped() {
        return Messages.escapeString(this.sourceFile);
    }

    public int getLine() {
        return this.line;
    }

    public String getWarningMessage() {
        return this.warningMessage;
    }

    public String getType() {
        return this.warningType;
    }

    public String getWarningMessageEscaped() {
        return Messages.escapeString(this.warningMessage);
    }

    public int getLevel() {
        return this.level;
    }

    public CssSelectors getContext() {
        return this.selector;
    }

    public int getInternalOrder() {
        return 100000 * this.hashSource + 10 * this.line + this.level;
    }

    public void dump() {
        System.err.println(this.getSourceFile());
        System.err.println(this.getLine());
        System.err.println(this.getWarningMessage());
        System.err.println(this.getLevel());
    }

    private String warn(String warning, String[] args, ApplContext ac) {
        String str = ac.getMsg().getWarningString(warning);
        if (str == null) {
            return "warning." + warning;
        }
        if (args != null) {
            StringBuilder sb = new StringBuilder();
            int[] order = null;
            String[] msg_parts = null;
            boolean paramgenericorder = true;
            msg_parts = warningMessages.get(str);
            if (msg_parts != null) {
                order = warningOrder.get(str);
                if (order != null) {
                    paramgenericorder = false;
                }
            } else {
                try {
                    Pattern p = Pattern.compile("%s\\d?");
                    msg_parts = p.split(str, -1);
                    Matcher m = p.matcher(str);
                    int nbparam = 0;
                    order = new int[10];
                    paramgenericorder = true;
                    while (m.find()) {
                        String group = m.group();
                        if (group.length() > 2) {
                            if (nbparam == 0 || !paramgenericorder) {
                                int o;
                                paramgenericorder = false;
                                order[nbparam] = o = Integer.parseInt(group.substring(2));
                            }
                        } else if (!paramgenericorder) {
                            paramgenericorder = true;
                        }
                        ++nbparam;
                    }
                    if (!paramgenericorder) {
                        for (int i = 0; i < nbparam; ++i) {
                            if (order[i] > nbparam || order[i] == 0) {
                                paramgenericorder = true;
                                break;
                            }
                            for (int j = i + 1; j < nbparam; ++j) {
                                if (order[i] != order[j]) continue;
                                paramgenericorder = true;
                                break;
                            }
                            if (paramgenericorder) break;
                        }
                        warningOrder.put(str, order);
                    }
                    warningMessages.put(str, msg_parts);
                }
                catch (PatternSyntaxException p) {
                    // empty catch block
                }
            }
            int j = 0;
            sb.append(msg_parts[0]);
            for (int i = 1; i < msg_parts.length; ++i) {
                if (j < args.length) {
                    if (paramgenericorder) {
                        sb.append(args[j++]);
                    } else {
                        sb.append(args[order[j++] - 1]);
                    }
                } else {
                    System.err.println("*** WARNING ISSUE: " + warning);
                    System.err.println("*** WARNING ISSUE: " + ac.getMsg().getWarningString(warning));
                    System.err.println("*** WARNING ISSUE: got " + args.length + " args entries");
                }
                sb.append(msg_parts[i]);
            }
            return sb.toString();
        }
        return str;
    }

    private int getLevel(String warning, int defaultLevel, ApplContext ac) {
        String str = ac.getMsg().getWarningLevelString(warning);
        if (str == null) {
            return defaultLevel;
        }
        try {
            int level = Integer.parseInt(str);
            if (level > 9 || level < 0) {
                return defaultLevel;
            }
            return level;
        }
        catch (Exception e) {
            return defaultLevel;
        }
    }
}

