/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.parser;

import java.util.ArrayList;
import org.w3c.css.atrules.css.AtRuleFontFace;
import org.w3c.css.atrules.css.AtRulePage;
import org.w3c.css.parser.AtRule;
import org.w3c.css.parser.CssSelectorsConstant;
import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.selectors.AttributeSelector;
import org.w3c.css.selectors.PseudoClassSelector;
import org.w3c.css.selectors.PseudoElementSelector;
import org.w3c.css.selectors.PseudoFactory;
import org.w3c.css.selectors.Selector;
import org.w3c.css.selectors.SelectorsList;
import org.w3c.css.selectors.TypeSelector;
import org.w3c.css.selectors.attributes.AttributeExact;
import org.w3c.css.selectors.pseudofunctions.PseudoFunctionNot;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.CssProfile;
import org.w3c.css.util.CssVersion;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.util.Messages;
import org.w3c.css.util.Util;
import org.w3c.css.util.Warnings;
import org.w3c.css.values.CssExpression;
import ro.sync.cssvalidator.properties.generic.CssCustomValidatorFactory;

public final class CssSelectors
extends SelectorsList
implements CssSelectorsConstant,
Comparable<CssSelectors> {
    ApplContext ac;
    AtRule atRule;
    String element;
    String connector = " ";
    protected CssSelectors next = null;
    private boolean isBlock;
    CssStyle properties;
    private int hashElement;
    private static Class<?> style;
    private boolean Init;
    private String cachedRepresentation = null;
    private boolean isFinal = false;

    public CssSelectors(ApplContext ac) {
        super(ac);
        style = ac.getCssSelectorsStyle();
        try {
            this.properties = (CssStyle)style.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.ac = ac;
    }

    private CssSelectors(Class<?> style) {
        CssSelectors.style = style;
        try {
            this.properties = (CssStyle)style.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.ac = null;
    }

    public CssSelectors(CssSelectors next) {
        this(style);
        this.next = next;
    }

    public CssSelectors(ApplContext ac, CssSelectors next) {
        this(ac);
        this.next = next;
    }

    public void setStyle(Class<?> style0) {
        Util.verbose("Style is : " + style0);
        style = style0;
    }

    public void setAtRule(AtRule atRule) {
        this.atRule = atRule;
    }

    public final AtRule getAtRule() {
        return this.atRule;
    }

    public final String getElement() {
        return this.element;
    }

    public final boolean isBlockLevelElement() {
        return this.isBlock;
    }

    public void addPseudoClass(String pseudo) throws InvalidParamException {
        CssVersion version;
        if (pseudo == null) {
            return;
        }
        String spec = this.ac.getPropertyKey();
        CssCustomValidatorFactory customValidatorFactory = this.ac.getCustomValidatorFactory();
        if (customValidatorFactory != null && customValidatorFactory.containsPseudoClass(spec, pseudo)) {
            this.addPseudoClass(new PseudoClassSelector(pseudo));
            return;
        }
        if (spec.contains("oxygen") && (pseudo.startsWith("before(") || pseudo.startsWith("after("))) {
            return;
        }
        if (this.ac.getTreatVendorExtensionsAsWarnings() && this.ac.getCssVersion() != CssVersion.CSS1 && pseudo.startsWith("-")) {
            this.addPseudoClass(new PseudoClassSelector(pseudo));
            this.ac.getFrame().addWarning("vendor-ext-pseudo-class", ":" + pseudo);
            return;
        }
        String[] ps = PseudoFactory.getPseudoClass(spec);
        if (ps != null) {
            for (String p : ps) {
                if (!pseudo.equals(p) && !pseudo.startsWith("-oxy-")) continue;
                this.addPseudoClass(new PseudoClassSelector(pseudo));
                return;
            }
        }
        if ((ps = PseudoFactory.getPseudoElementExceptions(version = this.ac.getCssVersion())) != null) {
            for (String p : ps) {
                if (!pseudo.equals(p)) continue;
                this.addPseudoClass(new PseudoClassSelector(pseudo));
                return;
            }
        }
        throw new InvalidParamException("pseudo", ":" + pseudo, this.ac);
    }

    public void addPseudoElement(String pseudo) throws InvalidParamException {
        if (pseudo == null) {
            return;
        }
        CssVersion version = this.ac.getCssVersion();
        CssCustomValidatorFactory customValidatorFactory = this.ac.getCustomValidatorFactory();
        if (customValidatorFactory != null && customValidatorFactory.containsPseudoElement(this.ac.getPropertyKey(), pseudo)) {
            this.addPseudoElement(new PseudoElementSelector(pseudo));
            return;
        }
        String spec = this.ac.getPropertyKey();
        if (spec.contains("oxygen") && (pseudo.startsWith("before(") || pseudo.startsWith("after("))) {
            return;
        }
        if (this.ac.getTreatVendorExtensionsAsWarnings() && version != CssVersion.CSS1 && pseudo.startsWith("-")) {
            this.addPseudoElement(new PseudoElementSelector(pseudo));
            this.ac.getFrame().addWarning("vendor-ext-pseudo-element", "::" + pseudo);
            return;
        }
        String[] ps = PseudoFactory.getPseudoElement(version);
        if (ps != null) {
            for (String s : ps) {
                if (!pseudo.equals(s)) continue;
                this.addPseudoElement(new PseudoElementSelector(pseudo));
                return;
            }
        }
        throw new InvalidParamException("pseudo", "::" + pseudo, this.ac);
    }

    public void setPseudoFun(ApplContext ac, String pseudo, String param) throws InvalidParamException {
        CssVersion version = ac.getCssVersion();
        String[] ps = PseudoFactory.getPseudoFunction(version);
        if (ps != null) {
            for (String s : ps) {
                if (!pseudo.equals(s)) continue;
                this.addPseudoFunction(PseudoFactory.newPseudoFunction(pseudo, param, ac));
                return;
            }
            CssCustomValidatorFactory customValidatorFactory = ac.getCustomValidatorFactory();
            if (customValidatorFactory != null && customValidatorFactory.containsPseudoFunction(ac.getProfileString(), pseudo, param)) {
                this.addPseudoFunction(new PseudoFunctionNot(pseudo, param));
                return;
            }
            throw new InvalidParamException("pseudo", ":" + pseudo, ac);
        }
    }

    public void setPseudoFun(ApplContext ac, String pseudo, ArrayList<CssSelectors> selector_list) throws InvalidParamException {
        CssVersion version = ac.getCssVersion();
        String[] ps = PseudoFactory.getPseudoFunction(version);
        if (ps != null) {
            for (String s : ps) {
                if (!pseudo.equals(s)) continue;
                this.addPseudoFunction(PseudoFactory.newPseudoFunction(pseudo, selector_list, ac));
                return;
            }
            throw new InvalidParamException("pseudo", ":" + pseudo, ac);
        }
    }

    public void setPseudoFun(ApplContext ac, String pseudo, CssExpression expression) throws InvalidParamException {
        CssVersion version = ac.getCssVersion();
        String[] ps = PseudoFactory.getPseudoFunction(version);
        if (ps != null) {
            for (String s : ps) {
                if (!pseudo.equals(s)) continue;
                this.addPseudoFunction(PseudoFactory.newPseudoFunction(pseudo, expression, ac));
                return;
            }
            throw new InvalidParamException("pseudo", ":" + pseudo, ac);
        }
    }

    public void setPseudoFun(ApplContext ac, String pseudo, CssExpression expression, ArrayList<CssSelectors> selector_list) throws InvalidParamException {
        CssVersion version = ac.getCssVersion();
        String[] ps = PseudoFactory.getPseudoFunction(version);
        if (ps != null) {
            for (String s : ps) {
                if (!pseudo.equals(s)) continue;
                this.addPseudoFunction(PseudoFactory.newPseudoFunction(pseudo, expression, selector_list, ac));
                return;
            }
            throw new InvalidParamException("pseudo", ":" + pseudo, ac);
        }
    }

    @Override
    public void addType(TypeSelector type) throws InvalidParamException {
        super.addType(type);
        this.element = type.getName();
        this.hashElement = this.element.hashCode();
    }

    @Override
    public void addDescendantCombinator() throws InvalidParamException {
        super.addDescendantCombinator();
        this.connector = " ";
    }

    @Override
    public void addChildCombinator() throws InvalidParamException {
        super.addChildCombinator();
        this.connector = ">";
    }

    @Override
    public void addNextSiblingCombinator() throws InvalidParamException {
        super.addNextSiblingCombinator();
        this.connector = "+";
    }

    @Override
    public void addSubsequentSiblingCombinator() throws InvalidParamException {
        super.addSubsequentSiblingCombinator();
        this.connector = "~";
    }

    @Override
    public void addColumnCombinator() throws InvalidParamException {
        super.addColumnCombinator();
        this.connector = "||";
    }

    @Override
    public void addAttribute(AttributeSelector attribute) throws InvalidParamException {
        int _s = this.size();
        for (int i = 0; i < _s; ++i) {
            Selector s = this.getSelector(i);
            if (!(s instanceof AttributeSelector)) continue;
            ((AttributeSelector)s).applyAttribute(this.ac, attribute);
        }
        super.addAttribute(attribute);
    }

    public void addProperty(CssProperty property, Warnings warnings) {
        this.Init = true;
        if (this.properties != null) {
            this.properties.setProperty(this.ac, property, warnings);
        } else {
            System.err.println("[ERROR] Invalid state in org.w3c.css.parser.CssSelectors#addProperty");
            System.err.println("[ERROR] Please report BUG");
        }
    }

    public CssStyle getStyle() {
        return this.properties;
    }

    @Override
    public String toString() {
        if (this.isToStringCached()) {
            return this.cachedRepresentation;
        }
        StringBuilder sbrep = new StringBuilder();
        if (this.next != null) {
            sbrep.append(this.next.toString());
        }
        sbrep.append(super.toString());
        this.cachedRepresentation = sbrep.toString();
        return this.cachedRepresentation;
    }

    public String getEscaped() {
        return Messages.escapeString(this.toString());
    }

    @Override
    public boolean isToStringCached() {
        if (this.cachedRepresentation == null) {
            return false;
        }
        if (this.isFinal) {
            return true;
        }
        if (this.next != null) {
            return super.isToStringCached() && this.next.isToStringCached();
        }
        return super.isToStringCached();
    }

    @Override
    public int compareTo(CssSelectors selectors) {
        return this.toString().compareTo(selectors.toString());
    }

    public void markAsFinal() {
        if (!this.isFinal) {
            if (!this.isToStringCached()) {
                this.cachedRepresentation = null;
                if (this.next != null) {
                    this.next.markAsFinal();
                }
            }
            this.isFinal = true;
        }
    }

    public boolean equals(Object selector) {
        if (selector == null || !(selector instanceof CssSelectors)) {
            return false;
        }
        CssSelectors s = (CssSelectors)selector;
        if (this.atRule instanceof AtRulePage || this.atRule instanceof AtRuleFontFace) {
            return this.atRule.equals(s.atRule);
        }
        if (this.hashCode() == s.hashCode()) {
            if (this.atRule == null) {
                return s.getAtRule() == null;
            }
            return this.atRule.canApply(s.getAtRule());
        }
        return false;
    }

    public void setNext(CssSelectors next) {
        this.next = next;
        this.Invalidate();
    }

    public CssSelectors getNext() {
        return this.next;
    }

    public boolean isEmpty() {
        return !this.Init;
    }

    public void addAttribute(String attName, String value) throws InvalidParamException {
        CssProfile profile = this.ac.getCssProfile();
        if (profile == CssProfile.MOBILE) {
            throw new InvalidParamException("notformobile", "attributes", this.ac);
        }
        this.addAttribute(new AttributeExact(attName, value));
        this.Invalidate();
    }

    void Invalidate() {
        this.setSpecificity(0);
        if (this.Init) {
            try {
                this.properties = (CssStyle)style.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    final boolean canApply(ArrayList<Selector> attrs, ArrayList<Selector> attrs2) {
        if (attrs.size() > 0) {
            for (Selector selector : attrs) {
                int other_idx = attrs2.indexOf(selector);
                if (other_idx == -1) {
                    return false;
                }
                Selector other = attrs2.get(other_idx);
                if (selector.canApply(other)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean canApply(CssSelectors selector) {
        if (this.atRule instanceof AtRulePage || this.atRule instanceof AtRuleFontFace) {
            return this.atRule.canApply(selector.atRule);
        }
        Util.verbose(this.getSpecificity() + " canApply this " + this + " selector: " + selector);
        Util.verbose("connector " + this.connector);
        Util.verbose(this.getSelectors().toString());
        Util.verbose(selector.getSelectors().toString());
        if (this.hashElement != selector.hashElement && this.hashElement != 0) {
            Util.verbose("canApply RETURNS FALSE");
            return false;
        }
        if (this.next == null || selector.next == null) {
            boolean result = this.canApply(this.getSelectors(), selector.getSelectors());
            Util.verbose("canApply RETURNS " + result);
            return result;
        }
        return this.next.canMatch(selector.next);
    }

    private boolean canMatch(CssSelectors selector) {
        boolean result = this.canApply(this.getSelectors(), selector.getSelectors());
        Util.verbose("canMatch this " + this + " selector: " + selector);
        Util.verbose("connector " + this.connector);
        Util.verbose(this.getSelectors().toString());
        Util.verbose(selector.getSelectors().toString());
        Util.verbose("canMatch for attributes :" + result);
        if (this.hashElement != selector.hashElement && this.hashElement != 0) {
            if (this.connector.equals(" ") && selector.next != null) {
                return this.canMatch(selector.next);
            }
            Util.verbose("canMatch RETURN FALSE");
            return false;
        }
        if (this.next == null || selector.next == null) {
            Util.verbose("canMatch RETURN " + result);
            return this.canApply(this.getSelectors(), selector.getSelectors());
        }
        return this.next.canMatch(selector.next);
    }

    public void findConflicts(ApplContext ac, Warnings warnings, CssSelectors[] allSelectors) {
        CssStyle style = this.getStyle();
        style.findConflicts(ac, warnings, this, allSelectors);
    }

    public static String toArrayString(ArrayList<CssSelectors> selectors) {
        if (selectors == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (CssSelectors s : selectors) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(s);
        }
        return sb.toString();
    }
}

