/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.resolver.tools;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import org.apache.xerces.dom.DOMInputImpl;
import org.apache.xerces.util.URI;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolverXerces;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class CatalogResolver
extends CatalogResolverXerces
implements LSResourceResolver {
    public CatalogResolver() {
    }

    public CatalogResolver(boolean privateCatalog) {
        super(privateCatalog);
    }

    public CatalogResolver(CatalogManager manager) {
        super(manager);
    }

    @Override
    protected void setEntityResolver(SAXSource source) throws TransformerException {
        XMLReader reader = source.getXMLReader();
        if (reader == null) {
            reader = this.createNewReader();
        }
        reader.setEntityResolver(this);
        source.setXMLReader(reader);
    }

    protected XMLReader createNewReader() throws TransformerException {
        SAXParserFactory spFactory = SAXParserFactory.newInstance();
        spFactory.setNamespaceAware(true);
        try {
            return spFactory.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException ex) {
            throw new TransformerException(ex);
        }
        catch (SAXException ex) {
            throw new TransformerException(ex);
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        String resolved = this.getResolvedEntity(publicId, systemId);
        if (resolved != null) {
            try {
                InputSource iSource = new InputSource(resolved);
                iSource.setPublicId(publicId);
                URL url = new URL(resolved);
                LazyInputStream iStream = new LazyInputStream(url);
                iSource.setByteStream(iStream);
                return iSource;
            }
            catch (Exception e) {
                this.catalogManager.debug.message(1, "Failed to create InputSource (" + e.toString() + ")", resolved);
                return null;
            }
        }
        return null;
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        String resolvedId = null;
        try {
            if (baseURI != null) {
                try {
                    URI uri = new URI(new URI(baseURI), systemId);
                    systemId = uri.toString();
                }
                catch (URI.MalformedURIException malformedURIException) {
                    // empty catch block
                }
            }
            if ("http://www.w3.org/2001/XMLSchema".equals(type)) {
                resolvedId = this.getCatalog().resolveURI(systemId);
            }
            if (resolvedId == null && namespaceURI != null) {
                resolvedId = this.getCatalog().resolveURI(namespaceURI);
            }
            if (resolvedId == null) {
                resolvedId = this.getResolvedEntity(publicId, systemId);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (resolvedId != null) {
            return new DOMInputImpl(publicId, resolvedId, baseURI);
        }
        return null;
    }

    private static class LazyInputStream
    extends InputStream {
        private final URL wrapped;
        private InputStream wrappedIS;
        private IOException wrappedIO;

        public LazyInputStream(URL wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public int read() throws IOException {
            this.assureOpened();
            return this.wrappedIS.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            this.assureOpened();
            return this.wrappedIS.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.assureOpened();
            return this.wrappedIS.read(b, off, len);
        }

        @Override
        public void close() throws IOException {
            if (this.wrappedIS != null) {
                this.wrappedIS.close();
            }
            super.close();
        }

        @Override
        public long skip(long n) throws IOException {
            this.assureOpened();
            return this.wrappedIS.skip(n);
        }

        @Override
        public int available() throws IOException {
            this.assureOpened();
            return this.wrappedIS.available();
        }

        @Override
        public boolean markSupported() {
            try {
                this.assureOpened();
            }
            catch (IOException e) {
                this.wrappedIO = e;
            }
            if (this.wrappedIS != null) {
                return this.wrappedIS.markSupported();
            }
            return super.markSupported();
        }

        @Override
        public synchronized void reset() throws IOException {
            this.assureOpened();
            this.wrappedIS.reset();
        }

        @Override
        public synchronized void mark(int readlimit) {
            try {
                this.assureOpened();
            }
            catch (IOException e) {
                this.wrappedIO = e;
            }
            if (this.wrappedIS != null) {
                this.wrappedIS.mark(readlimit);
            } else {
                super.mark(readlimit);
            }
        }

        private void assureOpened() throws IOException {
            if (this.wrappedIO != null) {
                throw this.wrappedIO;
            }
            if (this.wrappedIS == null) {
                this.wrappedIS = this.wrapped.openStream();
            }
        }
    }
}

