/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.datatype.tools;

import java.io.IOException;
import java.util.HashSet;
import nu.validator.htmlparser.common.XmlViolationPolicy;
import nu.validator.htmlparser.sax.HtmlParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public final class RegisteredRelValuesBuilder
implements ContentHandler {
    private static final String NS = "http://www.w3.org/1999/xhtml";
    private State state = State.AWAITING_SECTION;
    private StringBuilder keyword = new StringBuilder();
    private StringBuilder linkEffect = new StringBuilder();
    private StringBuilder aEffect = new StringBuilder();
    private static HashSet<String> registeredLinkRelValues = new HashSet();
    private static HashSet<String> registeredARelValues = new HashSet();

    public static void parseRegistry() throws IOException, SAXException {
        HtmlParser parser = new HtmlParser(XmlViolationPolicy.ALTER_INFOSET);
        RegisteredRelValuesBuilder handler = new RegisteredRelValuesBuilder();
        parser.setContentHandler((ContentHandler)handler);
        InputSource in = new InputSource(RegisteredRelValuesBuilder.class.getClassLoader().getResourceAsStream("nu/validator/localentities/files/existing-rel-values"));
        parser.parse(in);
    }

    public static HashSet<String> getLinkRelValues() throws SAXException {
        return registeredLinkRelValues;
    }

    public static HashSet<String> getARelValues() throws SAXException {
        return registeredARelValues;
    }

    private RegisteredRelValuesBuilder() {
    }

    @Override
    public void startDocument() throws SAXException {
        this.state = State.AWAITING_SECTION;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        switch (this.state) {
            case AWAITING_SECTION: {
                if ("formats".equals(atts.getValue("", "name"))) {
                    this.state = State.AWAITING_TR;
                }
                if ("proposals".equals(atts.getValue("", "name"))) {
                    this.state = State.AWAITING_TR;
                }
                if ("HTML5_link_type_extensions".equals(atts.getValue("", "name"))) {
                    this.state = State.AWAITING_TR;
                }
                return;
            }
            case AWAITING_TR: {
                if ("tr" == localName && NS == uri) {
                    this.state = State.IN_TR;
                }
                return;
            }
            case IN_TR: {
                if ("td" == localName && NS == uri) {
                    this.state = State.AWAITING_KEYWORD;
                }
                return;
            }
            case AWAITING_KEYWORD: {
                this.keyword.setLength(0);
                return;
            }
            case AWAITING_LINK_EFFECT: {
                this.linkEffect.setLength(0);
                return;
            }
            case AWAITING_A_EFFECT: {
                this.aEffect.setLength(0);
                return;
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        switch (this.state) {
            case AWAITING_KEYWORD: {
                if ("td" == localName && NS == uri) {
                    this.state = State.AWAITING_LINK_EFFECT;
                }
                return;
            }
            case AWAITING_LINK_EFFECT: {
                if ("td" == localName && NS == uri) {
                    this.state = State.AWAITING_A_EFFECT;
                }
                return;
            }
            case AWAITING_A_EFFECT: {
                if ("td" == localName && NS == uri) {
                    if (!"not allowed".equals(this.linkEffect.toString().trim().toLowerCase())) {
                        registeredLinkRelValues.add(this.keyword.toString().trim().toLowerCase());
                    }
                    if (!"not allowed".equals(this.aEffect.toString().trim().toLowerCase())) {
                        registeredARelValues.add(this.keyword.toString().trim().toLowerCase());
                    }
                    this.state = State.AWAITING_TR;
                }
                return;
            }
            case AWAITING_TR: {
                if ("table" == localName && NS == uri) {
                    this.state = State.AWAITING_SECTION;
                }
                return;
            }
            case AWAITING_SECTION: 
            case IN_TR: {
                return;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        switch (this.state) {
            case AWAITING_KEYWORD: {
                this.keyword.append(ch, start, length);
                return;
            }
            case AWAITING_LINK_EFFECT: {
                this.linkEffect.append(ch, start, length);
                return;
            }
            case AWAITING_A_EFFECT: {
                this.aEffect.append(ch, start, length);
                return;
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    private static enum State {
        AWAITING_SECTION,
        AWAITING_TR,
        IN_TR,
        AWAITING_KEYWORD,
        AWAITING_LINK_EFFECT,
        AWAITING_A_EFFECT;

    }
}

