/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.xhtml;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.exml.workspace.api.node.customizer.BasicRenderingInformation;
import ro.sync.exml.workspace.api.node.customizer.NodeRendererCustomizerContext;
import ro.sync.exml.workspace.api.node.customizer.XMLNodeRendererCustomizer;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class XHTMLNodeRendererCustomizer
extends XMLNodeRendererCustomizer {
    private static final Logger logger = LoggerFactory.getLogger((String)XHTMLNodeRendererCustomizer.class.getName());
    private static final Map<String, String> nameToIconPath = new HashMap<String, String>();

    private static String getImageURL(String path) {
        URL imageURL = XHTMLNodeRendererCustomizer.class.getResource(path);
        if (imageURL != null) {
            return imageURL.toExternalForm();
        }
        logger.error(XHTMLNodeRendererCustomizer.class.getName() + " - Image not found: " + path);
        return null;
    }

    public BasicRenderingInformation getRenderingInformation(NodeRendererCustomizerContext context) {
        BasicRenderingInformation renderingInfo = new BasicRenderingInformation();
        String nodeName = context.getNodeName();
        if (nodeName != null) {
            String iconPath = nameToIconPath.get(nodeName);
            renderingInfo.setIconPath(iconPath);
        }
        return renderingInfo;
    }

    public String getDescription() {
        return "XHTML Node Renderer Customizer";
    }

    static {
        nameToIconPath.put("a", XHTMLNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementA16.png"));
        nameToIconPath.put("link", XHTMLNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementLink16.png"));
        nameToIconPath.put("body", XHTMLNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementBody16.png"));
        String boldIcon = XHTMLNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementBold16.png");
        nameToIconPath.put("b", boldIcon);
        nameToIconPath.put("strong", boldIcon);
        nameToIconPath.put("div", XHTMLNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementDiv16.png"));
        nameToIconPath.put("h1", XHTMLNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementH116.png"));
        nameToIconPath.put("h2", XHTMLNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementH216.png"));
        nameToIconPath.put("h3", XHTMLNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementH316.png"));
        nameToIconPath.put("h4", XHTMLNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementH416.png"));
        nameToIconPath.put("h5", XHTMLNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementH516.png"));
        nameToIconPath.put("h6", XHTMLNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementH616.png"));
        nameToIconPath.put("head", XHTMLNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementHead16.png"));
        nameToIconPath.put("html", XHTMLNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementHtml16.png"));
        String italicIcon = XHTMLNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementItalic16.png");
        nameToIconPath.put("i", italicIcon);
        nameToIconPath.put("em", italicIcon);
        nameToIconPath.put("img", XHTMLNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementImage16.png"));
        nameToIconPath.put("li", XHTMLNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementLi16.png"));
        nameToIconPath.put("ol", XHTMLNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementOl16.png"));
        nameToIconPath.put("p", XHTMLNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementPara16.png"));
        nameToIconPath.put("span", XHTMLNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementSpan16.png"));
        nameToIconPath.put("table", XHTMLNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementTable16.png"));
        nameToIconPath.put("tbody", XHTMLNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementTBody16.png"));
        nameToIconPath.put("td", XHTMLNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementTd16.png"));
        nameToIconPath.put("tfoot", XHTMLNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementTFoot16.png"));
        nameToIconPath.put("thead", XHTMLNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementTHead16.png"));
        nameToIconPath.put("title", XHTMLNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementTitle16.png"));
        nameToIconPath.put("tr", XHTMLNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementTr16.png"));
        nameToIconPath.put("th", XHTMLNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementTh16.png"));
        nameToIconPath.put("ul", XHTMLNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementUl16.png"));
        nameToIconPath.put("u", XHTMLNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementUnderline16.png"));
        nameToIconPath.put("hr", XHTMLNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementHr16.png"));
        nameToIconPath.put("meta", XHTMLNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementMeta16.png"));
        nameToIconPath.put("script", XHTMLNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementScript16.png"));
        nameToIconPath.put("style", XHTMLNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementStyle16.png"));
        nameToIconPath.put("object", XHTMLNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementMedia16.png"));
        nameToIconPath.put("audio", XHTMLNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementAudio16.png"));
        nameToIconPath.put("video", XHTMLNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementVideo16.png"));
    }
}

