/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.xhtml;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;
import ro.sync.ecss.extensions.commons.ImageFileChooser;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=false)
@WebappRestSafe
public class InsertImgOperation
implements AuthorOperation {
    public static final String ARGUMENT_IMAGE_URL = "imageUrl";
    private static final ArgumentDescriptor[] arguments = new ArgumentDescriptor[]{new ArgumentDescriptor("imageUrl", 0, "The URL of the image. If not defined, an image chooser will be shown.")};

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        Object imageUrl = args.getArgumentValue(ARGUMENT_IMAGE_URL);
        String ref = null;
        ref = imageUrl instanceof String ? ImageFileChooser.makeUrlRelative(authorAccess, (String)imageUrl) : ImageFileChooser.chooseImageFile(authorAccess);
        if (ref != null) {
            authorAccess.getDocumentController().insertXMLFragmentSchemaAware("<img xmlns=\"http://www.w3.org/1999/xhtml\" src=\"" + ref + "\" alt=\"" + authorAccess.getUtilAccess().getFileName(ref) + "\"/>", authorAccess.getEditorAccess().getCaretOffset());
        }
    }

    public ArgumentDescriptor[] getArguments() {
        return arguments;
    }

    public String getDescription() {
        return "Insert a XHTML image";
    }
}

