/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.sort;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.common.CommonAccess;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.ExtensionsBundle;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.sort.CriterionInformation;
import ro.sync.ecss.extensions.commons.sort.SortCriteriaInformation;
import ro.sync.ecss.extensions.commons.sort.TableSortOperation;
import ro.sync.ecss.extensions.commons.sort.TableSortUtil;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class SimpleTableSortOperation
extends TableSortOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)SimpleTableSortOperation.class.getName());

    @Override
    public AuthorElement getSortParent(int offset, AuthorAccess authorAccess) throws AuthorOperationException {
        AuthorNode selectedNode;
        AuthorElement sortParent = null;
        if (authorAccess.getEditorAccess().hasSelection() && (selectedNode = authorAccess.getEditorAccess().getFullySelectedNode()) != null && selectedNode.getType() == 0 && this.isTableElement((AuthorElement)selectedNode)) {
            sortParent = (AuthorElement)selectedNode;
        }
        if (sortParent == null) {
            try {
                AuthorNode nodeAtOffset;
                AuthorNode parentElement = nodeAtOffset = authorAccess.getDocumentController().getNodeAtOffset(offset);
                while (parentElement.getType() != 2) {
                    if (parentElement.getType() == 0 && this.isTableElement((AuthorElement)parentElement)) {
                        sortParent = (AuthorElement)parentElement;
                        break;
                    }
                    parentElement = parentElement.getParent();
                }
            }
            catch (BadLocationException e) {
                throw new AuthorOperationException(e.getMessage(), (Throwable)e);
            }
        }
        return sortParent;
    }

    @Override
    public boolean isIgnored(AuthorNode node) {
        boolean isStHeadElem = false;
        if (node.getType() == 0) {
            isStHeadElem = this.isHeadElement((AuthorElement)node);
        }
        return node.getType() == 3 || node.getType() == 5 || isStHeadElem;
    }

    @Override
    public String[] getSortKeysValues(AuthorNode node, SortCriteriaInformation sortInfo) throws AuthorOperationException {
        CriterionInformation[] criterionInfo = sortInfo.criteriaInfo;
        String[] values = null;
        if (node instanceof AuthorElement && criterionInfo.length > 0) {
            values = new String[criterionInfo.length];
            AuthorElement authorParentNode = (AuthorElement)node;
            ExtensionsBundle extensionsBundle = this.authorAccess.getEditorAccess().getExtensionsBundle();
            if (extensionsBundle != null) {
                authorParentNode = (AuthorElement)CommonAccess.getContentReferencedNode((ExtensionsBundle)extensionsBundle, (AuthorNode)authorParentNode);
            }
            if (this.isRowElement(authorParentNode)) {
                List<AuthorNode> contentNodes = this.getNonIgnoredChildren(authorParentNode);
                int size = contentNodes.size();
                for (int i = 0; i < criterionInfo.length; ++i) {
                    CriterionInformation criterionInformation = criterionInfo[i];
                    int keyIndex = criterionInformation.getKeyIndex();
                    AuthorNode cellNode = null;
                    for (int j = 0; j < size; ++j) {
                        int[] tableColSpanIndices;
                        AuthorNode authorNode = contentNodes.get(j);
                        if (!(authorNode instanceof AuthorElement) || (tableColSpanIndices = this.authorAccess.getTableAccess().getTableColSpanIndices((AuthorElement)authorNode)) == null || tableColSpanIndices[0] > keyIndex || tableColSpanIndices[1] < keyIndex) continue;
                        cellNode = authorNode;
                        break;
                    }
                    if (cellNode == null) continue;
                    values[i] = this.getTextContentToSort(cellNode);
                }
            }
        }
        return values;
    }

    @Override
    public List<CriterionInformation> getSortCriteria(AuthorElement parent) throws AuthorOperationException {
        ArrayList<CriterionInformation> criteria;
        block8: {
            AuthorElement maxRowElem;
            block9: {
                criteria = new ArrayList<CriterionInformation>();
                List<AuthorNode> children = this.getNonIgnoredChildren(parent);
                int maxNrOfChildren = 0;
                maxRowElem = null;
                for (int i = 0; i < children.size(); ++i) {
                    int size;
                    AuthorNode child = children.get(i);
                    if (child.getType() != 0 || !this.isRowElement((AuthorElement)child) || (size = this.getNonIgnoredChildren((AuthorElement)child).size()) <= maxNrOfChildren) continue;
                    maxRowElem = (AuthorElement)child;
                    maxNrOfChildren = size;
                }
                AuthorElement tGroupElementElement = null;
                if (this.isTableElement(parent)) {
                    tGroupElementElement = parent;
                }
                if (tGroupElementElement == null) break block8;
                List contentNodes = tGroupElementElement.getContentNodes();
                AuthorElement theadElement = null;
                for (int i = 0; i < contentNodes.size(); ++i) {
                    AuthorElement authorElement;
                    AuthorNode child = (AuthorNode)contentNodes.get(i);
                    if (child.getType() != 0 || !this.isHeadElement(authorElement = (AuthorElement)child)) continue;
                    theadElement = authorElement;
                    break;
                }
                AuthorElement theadRow = null;
                if (theadElement != null && this.isTableElement(parent) && theadElement.getContentNodes().size() == maxNrOfChildren) {
                    theadRow = theadElement;
                }
                if (theadRow == null || maxRowElem == null) break block9;
                List<AuthorNode> theadRowChildren = this.getNonIgnoredChildren(theadRow);
                for (int i = 0; i < maxNrOfChildren; ++i) {
                    AuthorNode authorNode = theadRowChildren.get(i);
                    if (authorNode.getType() != 0) continue;
                    try {
                        AuthorElement theadEntry = (AuthorElement)authorNode;
                        String textContent = theadEntry.getTextContent();
                        criteria.add(new CriterionInformation(i, CriterionInformation.TYPE.TEXT.getName(), CriterionInformation.ORDER.ASCENDING.getName(), (String)(textContent.length() > 0 ? textContent : "Column " + (i + 1)), TableSortUtil.isEntirelySelected(this.authorAccess, theadEntry) || this.isCaretInColumn(this.authorAccess, i)));
                        continue;
                    }
                    catch (BadLocationException e) {
                        throw new AuthorOperationException(e.getMessage(), (Throwable)e);
                    }
                }
                break block8;
            }
            if (maxRowElem == null) break block8;
            List<AuthorNode> maxRowChildren = this.getNonIgnoredChildren(maxRowElem);
            for (int i = 0; i < maxRowChildren.size(); ++i) {
                if (maxRowChildren.get(i).getType() != 0) continue;
                criteria.add(new CriterionInformation(i, CriterionInformation.TYPE.TEXT.getName(), CriterionInformation.ORDER.ASCENDING.getName(), "Column " + (i + 1), TableSortUtil.isEntirelySelected(this.authorAccess, (AuthorElement)maxRowChildren.get(i)) || this.isCaretInColumn(this.authorAccess, i)));
            }
        }
        return criteria;
    }

    @Override
    protected boolean forceSortAll() {
        return TableSortUtil.isColumnOrTableSelection(this.authorAccess);
    }

    public boolean isCaretInColumn(AuthorAccess authorAccess, int columnNumber) {
        if (columnNumber < 0) {
            return false;
        }
        boolean isCaretInColumn = false;
        int caretOffset = authorAccess.getEditorAccess().getCaretOffset();
        try {
            AuthorNode nodeAtOffset = authorAccess.getDocumentController().getNodeAtOffset(caretOffset);
            if (nodeAtOffset != null && nodeAtOffset.getType() == 0 && nodeAtOffset.getParent().getType() == 0 && this.isRowElement((AuthorElement)nodeAtOffset.getParent())) {
                List<AuthorNode> nonIgnoredChildren = this.getNonIgnoredChildren((AuthorElement)nodeAtOffset.getParent());
                int[] tableColSpanIndices = authorAccess.getTableAccess().getTableColSpanIndices((AuthorElement)nodeAtOffset);
                if (tableColSpanIndices != null) {
                    if (tableColSpanIndices[0] <= columnNumber && tableColSpanIndices[1] >= columnNumber) {
                        isCaretInColumn = true;
                    }
                } else if (columnNumber < nonIgnoredChildren.size()) {
                    isCaretInColumn = nonIgnoredChildren.get(columnNumber) == nodeAtOffset;
                }
            }
        }
        catch (BadLocationException e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
        return isCaretInColumn;
    }

    @Override
    protected int getRowIndexForTableBody(AuthorNode table) {
        return 0;
    }

    public abstract boolean isTableElement(AuthorElement var1);

    public abstract boolean isHeadElement(AuthorElement var1);

    public abstract boolean isRowElement(AuthorElement var1);
}

