/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.sort;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.ecss.extensions.api.AuthorResourceBundle;
import ro.sync.ecss.extensions.commons.sort.CriterionInformation;
import ro.sync.ecss.extensions.commons.sort.CriterionPanel;
import ro.sync.ecss.extensions.commons.sort.KeysController;
import ro.sync.ecss.extensions.commons.sort.SortCriteriaInformation;
import ro.sync.ecss.extensions.commons.sort.SortCustomizer;
import ro.sync.ecss.extensions.commons.ui.OKCancelDialog;

@API(type=APIType.NOT_EXTENDABLE, src=SourceType.PRIVATE)
@SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.NOT_SPECIFIED, methods=SkipLevel.PUBLIC)
public class SASortCustomizerDialog
extends OKCancelDialog
implements SortCustomizer,
KeysController {
    private CriterionPanel firstCriterion;
    private CriterionPanel secondCriterion;
    private CriterionPanel thirdCriterion;
    private int numberOfCriteria;
    private final AuthorResourceBundle authorResourceBundle;
    private List<CriterionInformation> criteriaInformation;
    private final String selElems;
    private final String allElems;

    public SASortCustomizerDialog(Frame parentFrame, AuthorResourceBundle authorResourceBundle, String selElems, String allElems) {
        super(parentFrame, authorResourceBundle.getMessage("Sort"), true);
        this.authorResourceBundle = authorResourceBundle;
        this.selElems = selElems;
        this.allElems = allElems;
    }

    private void addSection(GridBagConstraints constr, String title) {
        JPanel sepPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 18;
        c.insets = new Insets(0, 0, 0, 5);
        JLabel titleLabel = new JLabel(title);
        sepPanel.add((Component)titleLabel, c);
        JSeparator sep = new JSeparator();
        ++c.gridx;
        c.fill = 2;
        c.anchor = 17;
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        sepPanel.add((Component)sep, c);
        this.getContentPane().add((Component)sepPanel, constr);
    }

    @Override
    public SortCriteriaInformation getSortInformation(List<CriterionInformation> criteriaInformation, boolean sortSelectedElements, boolean cannotSortAllElements) {
        this.criteriaInformation = criteriaInformation;
        this.numberOfCriteria = criteriaInformation.size();
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints constr = new GridBagConstraints();
        constr.gridx = 0;
        constr.gridy = 0;
        constr.gridwidth = this.numberOfCriteria > 1 ? 4 : 3;
        constr.fill = 2;
        constr.anchor = 18;
        constr.insets = new Insets(0, 0, 0, 0);
        this.addSection(constr, this.authorResourceBundle.getMessage("Range"));
        JPanel radioButtonsPanel = new JPanel(new FlowLayout(0));
        ButtonGroup radioGroup = new ButtonGroup();
        JRadioButton sortSelectedElementsRadio = new JRadioButton(this.selElems);
        radioGroup.add(sortSelectedElementsRadio);
        radioButtonsPanel.add(sortSelectedElementsRadio);
        sortSelectedElementsRadio.setSelected(true);
        JRadioButton sortAllElementsRadio = new JRadioButton(this.allElems);
        radioGroup.add(sortAllElementsRadio);
        radioButtonsPanel.add(sortAllElementsRadio);
        ++constr.gridy;
        this.getContentPane().add((Component)radioButtonsPanel, constr);
        ++constr.gridy;
        if (sortSelectedElements) {
            sortSelectedElementsRadio.setEnabled(true);
            sortSelectedElementsRadio.setSelected(true);
        } else {
            sortAllElementsRadio.setSelected(true);
            sortAllElementsRadio.setEnabled(true);
            sortSelectedElementsRadio.setEnabled(false);
        }
        if (cannotSortAllElements) {
            sortAllElementsRadio.setEnabled(false);
            sortAllElementsRadio.setSelected(false);
        }
        this.addSection(constr, this.authorResourceBundle.getMessage("Criteria"));
        constr.gridx = 0;
        ++constr.gridy;
        constr.fill = 0;
        constr.weightx = 0.0;
        constr.gridwidth = 1;
        constr.insets = new Insets(7, 0, 5, 7);
        if (this.numberOfCriteria > 1) {
            this.getContentPane().add((Component)new JLabel(""), constr);
            ++constr.gridx;
        }
        constr.fill = 2;
        constr.weightx = 1.0;
        constr.gridwidth = 3;
        this.getContentPane().add((Component)new JLabel(this.authorResourceBundle.getMessage("Sort_by") + ":"), constr);
        CriterionInformation firstSel = criteriaInformation.isEmpty() ? null : criteriaInformation.get(0);
        for (int i = 0; i < criteriaInformation.size(); ++i) {
            CriterionInformation criterionInformation = criteriaInformation.get(i);
            if (!criterionInformation.isInitiallySelected()) continue;
            firstSel = criterionInformation;
            break;
        }
        this.firstCriterion = new CriterionPanel(this.getContentPane(), constr, criteriaInformation, firstSel, this.authorResourceBundle, this, criteriaInformation);
        if (this.numberOfCriteria > 1) {
            this.firstCriterion.enableSortcriterion();
        }
        CriterionInformation secondSel = null;
        if (this.numberOfCriteria >= 2) {
            constr.gridx = 0;
            ++constr.gridy;
            constr.fill = 0;
            constr.weightx = 0.0;
            constr.insets.bottom = 5;
            this.getContentPane().add((Component)new JLabel(""), constr);
            ++constr.gridx;
            constr.fill = 2;
            constr.weightx = 1.0;
            constr.gridwidth = 3;
            this.getContentPane().add((Component)new JLabel(this.authorResourceBundle.getMessage("And_then_by") + ":"), constr);
            ArrayList<CriterionInformation> secondCriteria = new ArrayList<CriterionInformation>();
            boolean computeSel = true;
            for (int i = 0; i < criteriaInformation.size(); ++i) {
                CriterionInformation criterionInformation = criteriaInformation.get(i);
                if (criterionInformation == firstSel) continue;
                secondCriteria.add(criterionInformation);
                if (!criterionInformation.isInitiallySelected() || !computeSel) continue;
                secondSel = criterionInformation;
                computeSel = false;
            }
            if (secondSel == null && !secondCriteria.isEmpty()) {
                secondSel = (CriterionInformation)secondCriteria.get(0);
            }
            this.secondCriterion = new CriterionPanel(this.getContentPane(), constr, secondCriteria, secondSel, this.authorResourceBundle, this, criteriaInformation);
        }
        if (this.numberOfCriteria >= 3) {
            constr.gridx = 0;
            ++constr.gridy;
            constr.fill = 0;
            constr.weightx = 0.0;
            this.getContentPane().add((Component)new JLabel(""), constr);
            ++constr.gridx;
            constr.fill = 2;
            constr.weightx = 1.0;
            constr.gridwidth = 3;
            constr.insets.bottom = 5;
            this.getContentPane().add((Component)new JLabel(this.authorResourceBundle.getMessage("And_then_by") + ":"), constr);
            ArrayList<CriterionInformation> thirdCriteria = new ArrayList<CriterionInformation>();
            CriterionInformation thirdSel = null;
            boolean computeSel = true;
            for (int i = 0; i < criteriaInformation.size(); ++i) {
                CriterionInformation criterionInformation = criteriaInformation.get(i);
                if (criterionInformation == firstSel || criterionInformation == secondSel) continue;
                thirdCriteria.add(criterionInformation);
                if (!criterionInformation.isInitiallySelected() || !computeSel) continue;
                thirdSel = criterionInformation;
                computeSel = false;
            }
            if (thirdSel == null && !thirdCriteria.isEmpty()) {
                thirdSel = (CriterionInformation)thirdCriteria.get(0);
            }
            this.thirdCriterion = new CriterionPanel(this.getContentPane(), constr, thirdCriteria, thirdSel, this.authorResourceBundle, this, criteriaInformation);
        }
        constr.gridx = 0;
        ++constr.gridy;
        constr.fill = 1;
        constr.weightx = 1.0;
        constr.weighty = 1.0;
        constr.gridwidth = this.numberOfCriteria > 1 ? 4 : 3;
        this.getContentPane().add((Component)new JPanel(), constr);
        this.setResizable(true);
        this.pack();
        this.setMinimumSize(new Dimension(350, this.getSize().height));
        this.setSize(450, this.getSize().height);
        SortCriteriaInformation sortInformation = null;
        this.setVisible(true);
        if (this.getResult() == 1) {
            ArrayList<CriterionInformation> info = new ArrayList<CriterionInformation>();
            if (this.firstCriterion != null && this.firstCriterion.getInformation() != null) {
                info.add(this.firstCriterion.getInformation());
            } else if (criteriaInformation.size() == 1) {
                info.add(new CriterionInformation(0, "Column 1"));
            }
            if (this.secondCriterion != null && this.secondCriterion.getInformation() != null) {
                info.add(this.secondCriterion.getInformation());
            }
            if (this.thirdCriterion != null && this.thirdCriterion.getInformation() != null) {
                info.add(this.thirdCriterion.getInformation());
            }
            sortInformation = new SortCriteriaInformation(info.toArray(new CriterionInformation[0]), sortSelectedElementsRadio.isSelected());
        }
        return sortInformation;
    }

    @Override
    public void selectionChanged(String newSelection, String oldSelection) {
        if (this.numberOfCriteria > 1 && newSelection != null) {
            if (this.firstCriterion != null && this.firstCriterion.getKeyCombo() != null && this.firstCriterion.getKeyCombo().getSelectedItem().equals(newSelection) && this.secondCriterion != null) {
                String secondSel = (String)this.secondCriterion.getKeyCombo().getSelectedItem();
                this.secondCriterion.getKeyCombo().removeAllItems();
                for (int i = 0; i < this.criteriaInformation.size(); ++i) {
                    String displayName = this.criteriaInformation.get(i).getDisplayName();
                    if (newSelection.equals(displayName)) continue;
                    this.secondCriterion.getKeyCombo().addItem(displayName);
                }
                this.secondCriterion.getKeyCombo().setSelectedItem(secondSel);
                if (this.thirdCriterion != null) {
                    String thirdSel = (String)this.thirdCriterion.getKeyCombo().getSelectedItem();
                    this.thirdCriterion.getKeyCombo().removeAllItems();
                    String selectedItem = (String)this.secondCriterion.getKeyCombo().getSelectedItem();
                    for (int i = 0; i < this.criteriaInformation.size(); ++i) {
                        String displayName = this.criteriaInformation.get(i).getDisplayName();
                        if (newSelection.equals(displayName) || displayName.equals(selectedItem)) continue;
                        this.thirdCriterion.getKeyCombo().addItem(this.criteriaInformation.get(i).getDisplayName());
                    }
                    this.thirdCriterion.getKeyCombo().setSelectedItem(thirdSel);
                }
            } else if (this.secondCriterion != null && this.secondCriterion.getKeyCombo().getSelectedItem().equals(newSelection) && this.thirdCriterion != null) {
                String thirdSel = (String)this.thirdCriterion.getKeyCombo().getSelectedItem();
                this.thirdCriterion.getKeyCombo().removeAllItems();
                String selectedItem = this.firstCriterion.getKeyCombo() != null ? (String)this.firstCriterion.getKeyCombo().getSelectedItem() : "";
                for (int i = 0; i < this.criteriaInformation.size(); ++i) {
                    String displayName = this.criteriaInformation.get(i).getDisplayName();
                    if (newSelection.equals(displayName) || displayName.equals(selectedItem)) continue;
                    this.thirdCriterion.getKeyCombo().addItem(displayName);
                }
                this.thirdCriterion.getKeyCombo().setSelectedItem(thirdSel);
            }
        }
    }
}

