/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.operations.CommonsOperationsUtil;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
public class UnwrapTagsOperation
implements AuthorOperation {
    private static final String ARGUMENT_XPATH_UNWRAP_ELEMENT = "unwrapElementLocation";
    private static final ArgumentDescriptor[] ARGUMENTS = new ArgumentDescriptor[]{new ArgumentDescriptor("unwrapElementLocation", 2, "An XPath expression indicating the element to unwrap.\nNote: If it is not defined then the element at the caret is unwrapped.")};

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        AuthorNode nodeToUnwrap = null;
        Object xpathLocation = args.getArgumentValue(ARGUMENT_XPATH_UNWRAP_ELEMENT);
        if (xpathLocation instanceof String && ((String)xpathLocation).length() > 0) {
            AuthorNode[] results = authorAccess.getDocumentController().findNodesByXPath((String)xpathLocation, true, true, true);
            if (results.length <= 0 || !(results[0] instanceof AuthorElement)) throw new AuthorOperationException("The XPath expression does not identify an element: " + xpathLocation);
            nodeToUnwrap = results[0];
        } else {
            AuthorNode node = authorAccess.getEditorAccess().getFullySelectedNode();
            if (node == null) {
                try {
                    int caretOffset = authorAccess.getEditorAccess().getCaretOffset();
                    node = authorAccess.getDocumentController().getNodeAtOffset(caretOffset);
                }
                catch (BadLocationException e) {
                    throw new AuthorOperationException("Cannot identify the current element", (Throwable)e);
                }
            }
            while (node != null && !(node instanceof AuthorElement)) {
                node = node.getParent();
            }
            if (!(node instanceof AuthorElement)) throw new AuthorOperationException("You need to have the carret inside an element.");
            nodeToUnwrap = node;
        }
        authorAccess.getDocumentController().beginCompoundEdit();
        try {
            CommonsOperationsUtil.unwrapTags(authorAccess, nodeToUnwrap);
        }
        catch (BadLocationException e) {
            authorAccess.getDocumentController().cancelCompoundEdit();
            throw new AuthorOperationException("The unwrap cannot be performed.", (Throwable)e);
        }
        authorAccess.getDocumentController().endCompoundEdit();
    }

    public ArgumentDescriptor[] getArguments() {
        return ARGUMENTS;
    }

    public String getDescription() {
        return "Unwrap element tags.";
    }
}

