/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
public class SurroundWithTextOperation
implements AuthorOperation {
    private static final String ARGUMENT_HEADER = "header";
    private static final String ARGUMENT_FOOTER = "footer";
    private static final ArgumentDescriptor[] ARGUMENTS = new ArgumentDescriptor[]{new ArgumentDescriptor("header", 0, "The text to append before"), new ArgumentDescriptor("footer", 0, "The text to append after")};

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        Object headerArgVal = args.getArgumentValue(ARGUMENT_HEADER);
        Object footerArgVal = args.getArgumentValue(ARGUMENT_FOOTER);
        if (headerArgVal instanceof String && footerArgVal instanceof String) {
            if (!authorAccess.getEditorAccess().hasSelection()) {
                authorAccess.getEditorAccess().selectWord();
            }
        } else {
            throw new IllegalArgumentException("One or both of the argument values are not declared, they are: header - " + headerArgVal + ", footer - " + footerArgVal);
        }
        int selStart = authorAccess.getEditorAccess().getSelectionStart();
        int selEnd = authorAccess.getEditorAccess().getSelectionEnd();
        authorAccess.getDocumentController().surroundInText((String)headerArgVal, (String)footerArgVal, selStart, selEnd);
    }

    public ArgumentDescriptor[] getArguments() {
        return ARGUMENTS;
    }

    public String getDescription() {
        return "Surround a selection with text. Places a header at the start of the selection and a footer at the end.If no selection exists, the word at caret will be surrounded.";
    }
}

