/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.tokenmarker.xproc;

import com.oxygenxml.tokenmarker.activation.AbstractXMLActivationRule;
import com.oxygenxml.tokenmarker.activation.ActivationRange;
import java.util.Arrays;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XPathXProcActivationRule
extends AbstractXMLActivationRule {
    protected static final byte S_XE_RECOGNIZED_OPEN_TAG = 1;
    protected static final byte S_XE_RECOGNIZED_ATTRIBUTE_NAME = 2;
    protected static final byte S_XE_RECOGNIZED_EQUALS_OPERATOR = 3;
    protected static final byte S_XE_ACTIVE_SQ = 10;
    protected static final byte S_XE_ACTIVE_DQ = 11;
    private static final Logger logger = LoggerFactory.getLogger((String)XPathXProcActivationRule.class.getName());
    private String lastUpdatedOriginalTokenText;
    private byte lastUpdatedTokenId;

    @Override
    public void update(byte tokenId, String originalTokenText, String trimmedTokenText) {
        this.lastUpdatedTokenId = tokenId;
        this.lastUpdatedOriginalTokenText = originalTokenText;
        String tokenText = trimmedTokenText;
        boolean isEmpty = tokenText.isEmpty();
        boolean pushback = false;
        do {
            logger.debug("Updating {} - '{}'\t in state {}{}", new Object[]{tokenId, trimmedTokenText, this.state, pushback ? " (pushed back)" : ""});
            pushback = false;
            switch (this.state) {
                case 0: {
                    if (!this.isStartTag(tokenId) || tokenText.startsWith("</")) break;
                    this.state = 1;
                    break;
                }
                case 1: {
                    if (tokenId == 7 && ("test".equals(tokenText) || "select".equals(tokenText) || "match".equals(tokenText))) {
                        this.state = (byte)2;
                        break;
                    }
                    if (XPathXProcActivationRule.isAttributeRelatedToken(tokenId)) break;
                    if (tokenId == 6) {
                        this.state = 0;
                        pushback = true;
                        break;
                    }
                    this.state = 0;
                    break;
                }
                case 2: {
                    if (tokenId == 9 && "=".equals(tokenText)) {
                        this.state = (byte)3;
                        break;
                    }
                    if (tokenId == 7 && trimmedTokenText.isEmpty()) break;
                    if (tokenId == 6) {
                        this.state = 0;
                        pushback = true;
                        break;
                    }
                    this.state = 0;
                    break;
                }
                case 3: {
                    if (tokenId == 4) {
                        this.state = (byte)10;
                        break;
                    }
                    if (tokenId == 3) {
                        this.state = (byte)11;
                        break;
                    }
                    if (tokenId == 7 && trimmedTokenText.isEmpty()) break;
                    pushback = true;
                    this.state = 0;
                    break;
                }
                case 10: {
                    if (tokenId == 4) {
                        if (isEmpty || tokenText.charAt(0) == '\'') break;
                        break;
                    }
                    pushback = true;
                    this.state = 1;
                    break;
                }
                case 11: {
                    if (tokenId == 3) {
                        if (isEmpty || tokenText.charAt(0) == '\"') break;
                        break;
                    }
                    pushback = true;
                    this.state = 1;
                    break;
                }
                default: {
                    logger.error("Illegal state.");
                }
            }
            logger.debug("\t\t\t\t\t==> {}", (Object)this.state);
        } while (pushback);
    }

    @Override
    public int getActivationState() {
        boolean isActive = this.state == 10 || this.state == 11;
        return isActive ? -1 : -2;
    }

    @Override
    public ActivationRange[] getRanges() {
        ActivationRange[] ranges = null;
        if (XPathXProcActivationRule.isAttributeValueQuote(this.lastUpdatedTokenId)) {
            int len = this.lastUpdatedOriginalTokenText.length();
            if (this.state == 10 || this.state == 11) {
                int endIndex;
                char ch = this.state == 10 ? (char)'\'' : '\"';
                int beginIndex = ch == this.lastUpdatedOriginalTokenText.charAt(0) ? 1 : 0;
                int n = endIndex = ch == this.lastUpdatedOriginalTokenText.charAt(len - 1) ? len - 1 : len;
                if (endIndex >= beginIndex) {
                    ranges = new ActivationRange[]{new ActivationRange(beginIndex, endIndex)};
                }
            }
        }
        if (ranges != null && ranges.length == 0) {
            ranges = null;
        }
        ActivationRange[] rangesLog = ranges;
        logger.debug("Created ranges {}", new Supplier[]{() -> Arrays.toString(rangesLog)});
        return ranges;
    }
}

