/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.tokenmarker.xhtml;

import com.oxygenxml.tokenmarker.AbstractLexer;
import com.oxygenxml.tokenmarker.LexerException;
import com.oxygenxml.tokenmarker.LexicalState;
import com.oxygenxml.tokenmarker.Symbol;
import com.oxygenxml.tokenmarker.xhtml.EscapeableAttributesRecognizer;
import com.oxygenxml.tokenmarker.xhtml.JSAttributesRecognizer;
import com.oxygenxml.tokenmarker.xhtml.LexicalStateOverLong4HTML;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;

public class XHTMLLexer
extends AbstractLexer {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int YYINITIAL = 0;
    public static final int COMMENT = 2;
    public static final int CDATA = 4;
    public static final int INSTR = 6;
    public static final int JSP = 8;
    public static final int XML_INSTR = 10;
    public static final int PHP_INSTR = 12;
    public static final int PHP_MULTILINE_COMMENT = 14;
    public static final int TAG = 16;
    public static final int AFTER_ATTRIBUTE = 18;
    public static final int AFTER_EQUAL = 20;
    public static final int ATTRIBUTE_DQ_STRING = 22;
    public static final int ATTRIBUTE_SQ_STRING = 24;
    public static final int END_TAG = 26;
    public static final int END_TAG_AFTER_NEW_LINE = 28;
    public static final int IN_SCRIPT = 30;
    public static final int IN_STYLE = 32;
    public static final int IN_TEXTAREA = 34;
    public static final int IN_TITLE = 36;
    public static final int DOCTYPE = 38;
    public static final int DOCTYPE_DQ_STRING = 40;
    public static final int DOCTYPE_SQ_STRING = 42;
    public static final int DOCTYPE_INTERNAL_SUBSET = 44;
    public static final int DOCTYPE_INTERNAL_SUBSET_COMMENT = 46;
    public static final int DOCTYPE_INTERNAL_SUBSET_SQ_STRING = 48;
    public static final int DOCTYPE_INTERNAL_SUBSET_DQ_STRING = 50;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 16, 16, 17, 17, 18, 18, 19, 19, 20, 20, 21, 21, 22, 22, 23, 23, 24, 24, 25, 25};
    private static final String ZZ_CMAP_PACKED = "\t\u0000\u0001\u0002\u0001\u0003\u00015\u00015\u0001\u0003\u0012\u0000\u0001\u0001\u0001\f\u00010\u0001\n\u0001\r\u0001\u000e\u0001.\u00012\u0002\u0004\u00019\u0002\u0004\u0001\b\u0001\u0005\u0001\u000b\u0001\u0005\t\u0005\u0001\t\u0001/\u0001\u000f\u00017\u0001\u001a\u00013\u0001\r\u0001\"\u0001$\u0001\u0012\u0001\u0006\u0001\u0019\u0001\u0005\u0001)\u0001'\u0001\u001d\u0001\u0005\u0001,\u0001\u001e\u0001%\u0001*\u0001\u0011\u0001\u0017\u0001\u0005\u0001\u001c\u0001\u001b\u0001\u0014\u0001+\u0001\u0005\u0001-\u0001 \u0001\u0016\u0001\u0005\u00014\u00011\u00018\u0001\u0004\u0001\u0005\u0001\u0004\u0001#\u0001$\u0001\u0013\u0001\u0010\u0001\u0019\u0001\u0005\u0001)\u0001(\u0001\u001d\u0001\u0005\u0001,\u0001\u001f\u0001&\u0001*\u0001\u0011\u0001\u0018\u0001\u0005\u0001\u001c\u0001\u001b\u0001\u0015\u0001+\u0001\u0005\u0001-\u0001!\u0001\u0016\u0001\u0005\n\u0004\u000161\u0004\u0001\u0005\b\u0004\u0017\u0005\u0001\u0004\n\u0005\u0001\u0005\u0014\u0005\u0001\u0004\u0208\u0005p\u0005\u000e\u0005\u0001\u0004\u0c81\u0005\u0001\u0005\u00fe\u0005\u0001\u0005\u0f00\u0005\u0001\u0004\u000b\u0004\u0002\u0005\u000e\u0004\u0001\u0004\u000b\u0004\u00016\u00016\u0015\u0004\u0002\u0005/\u0004<\u0005\u0001\u0005\u00e3\u0005\u0a70\u0004\u03f0\u0005\u000f\u0004\u0001\u0004\u0001\u0002\u0ffe\u0005\u0001\u0005\u0001\u0005\u0ffe\u0005\u0001\u0005\u0001\u0005\u0ffe\u0005\u0001\u0005\u0001\u0005\u0ffe\u0005\u0001\u0005\u0001\u0005\u0ffe\u0005\u0001\u0005\u0001\u0005\u0ffe\u0005\u0001\u0005\u0001\u0005\u0ffe\u0005\u0001\u0005\u0001\u0005\u0ffe\u0005\u0001\u0005\u0001\u0005\u0ffe\u0005\u0001\u0005\u0001\u0005\u0ffe\u0005\u0001\u0005\u0001\u0005\u07ff\u0005\u0400\u0007\u03ff\u0007\u0001\u0005\u0001\u0004\u0ffe\u0004\u0001\u0004\u0001\u0004\u08ff\u0004\u04d0\u0005 \u0004\u020e\u0005\u0001\u0000\u0001\u0004";
    private static final char[] ZZ_CMAP = XHTMLLexer.zzUnpackCMap("\t\u0000\u0001\u0002\u0001\u0003\u00015\u00015\u0001\u0003\u0012\u0000\u0001\u0001\u0001\f\u00010\u0001\n\u0001\r\u0001\u000e\u0001.\u00012\u0002\u0004\u00019\u0002\u0004\u0001\b\u0001\u0005\u0001\u000b\u0001\u0005\t\u0005\u0001\t\u0001/\u0001\u000f\u00017\u0001\u001a\u00013\u0001\r\u0001\"\u0001$\u0001\u0012\u0001\u0006\u0001\u0019\u0001\u0005\u0001)\u0001'\u0001\u001d\u0001\u0005\u0001,\u0001\u001e\u0001%\u0001*\u0001\u0011\u0001\u0017\u0001\u0005\u0001\u001c\u0001\u001b\u0001\u0014\u0001+\u0001\u0005\u0001-\u0001 \u0001\u0016\u0001\u0005\u00014\u00011\u00018\u0001\u0004\u0001\u0005\u0001\u0004\u0001#\u0001$\u0001\u0013\u0001\u0010\u0001\u0019\u0001\u0005\u0001)\u0001(\u0001\u001d\u0001\u0005\u0001,\u0001\u001f\u0001&\u0001*\u0001\u0011\u0001\u0018\u0001\u0005\u0001\u001c\u0001\u001b\u0001\u0015\u0001+\u0001\u0005\u0001-\u0001!\u0001\u0016\u0001\u0005\n\u0004\u000161\u0004\u0001\u0005\b\u0004\u0017\u0005\u0001\u0004\n\u0005\u0001\u0005\u0014\u0005\u0001\u0004\u0208\u0005p\u0005\u000e\u0005\u0001\u0004\u0c81\u0005\u0001\u0005\u00fe\u0005\u0001\u0005\u0f00\u0005\u0001\u0004\u000b\u0004\u0002\u0005\u000e\u0004\u0001\u0004\u000b\u0004\u00016\u00016\u0015\u0004\u0002\u0005/\u0004<\u0005\u0001\u0005\u00e3\u0005\u0a70\u0004\u03f0\u0005\u000f\u0004\u0001\u0004\u0001\u0002\u0ffe\u0005\u0001\u0005\u0001\u0005\u0ffe\u0005\u0001\u0005\u0001\u0005\u0ffe\u0005\u0001\u0005\u0001\u0005\u0ffe\u0005\u0001\u0005\u0001\u0005\u0ffe\u0005\u0001\u0005\u0001\u0005\u0ffe\u0005\u0001\u0005\u0001\u0005\u0ffe\u0005\u0001\u0005\u0001\u0005\u0ffe\u0005\u0001\u0005\u0001\u0005\u0ffe\u0005\u0001\u0005\u0001\u0005\u0ffe\u0005\u0001\u0005\u0001\u0005\u07ff\u0005\u0400\u0007\u03ff\u0007\u0001\u0005\u0001\u0004\u0ffe\u0004\u0001\u0004\u0001\u0004\u08ff\u0004\u04d0\u0005 \u0004\u020e\u0005\u0001\u0000\u0001\u0004");
    private static final int[] ZZ_ACTION = XHTMLLexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u001a\u0000\u0001\u0001\u0001\u0002\u0001\u0003\u0001\u0004\u0001\u0005\u0001\u0004\u0001\u0005\u0001\u0004\u0001\u0005\u0001\u0004\u0001\u0005\u0001\u0004\u0001\u0005\u0004\u0004\u0001\u0005\u0001\u0004\u0001\u0005\u0001\u0006\u0001\u0007\u0001\u0000\u0001\b\u0001\t\u0001\n\u0001\u0000\u0001\u000b\u0001\f\u0001\r\u0001\u0000\u0001\u000e\u0001\u0000\u0001\b\u0001\u000f\u0001\u0010\u0001\u0011\u0001\u0006\u0001\u0012\u0001\b\u0001\u0013\u0001\u0014\u0001\u0015\u0001\u0005\u0001\u0016\u0001\u0017\u0001\u0018\u0001\u0019\u0001\u001a\u0001\u001b\u0001\u001c\u0001\u001d\u0005\u001e\u0001\u001f\u0001 \u0001!\u0001\"\u0001#\u0001$\u0001%\u0001\u0005\u0001&\u0001'\u0001\u0005\u0001\u0000\u0001\u0005\u0001(\u0001\u0000\u0001\u0005\u0002)\u0001*\u0001+\u0001,\u0004)\u0001-\b)\u0001.\u0001\u0000\u0001/\b\u0000\u00010\u0002\u0000\u00011\u0002\u0000\u00012\u00013\u0003\u0004\u00014\u0002\u0000\u00015\u0001\u0007\u00016\u00017\u00018\u00019\u0001\u000e\u0001:\u0001;\u0001<\u0001\u0012\r\u0000\u0001=\u0001\u0000\u0002>\u0001?\u0003\u0000\t)\u0001@\u0002)\u0003\u0000\u0001A\u0001B\u0001C\u0001D\u0001\u0007\u0001\u000e\f\u0000\u0001E\u0001F\u0001\u0000\u0001G\u0001\u0000\u0007)\u0001\u0000\u0001H\u0001)\u0002\u0000\u0001I\u0003\u0000\u0001J\u0007\u0000\u0001K\u0002\u0000\u0004)\u0001L\u0001M\u0001\u0000\u0001N\u0001O\u0001\u0000\u0001P\u0001\u0000\u0001Q\u0001\u0000\u0001R\u0001\u0000\u0001S\u0002\u0000\u0001T\u0007\u0000\u0001U\u0001\u0000\u0001V\u0002\u0000\u0001W\u0001X\u0001\u0000\u0001Y\u0001Z\u0001[\u0001\\\u0001\u0000\u0001]\u0001^";
    private static final int[] ZZ_ROWMAP = XHTMLLexer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000:\u0000t\u0000\u00ae\u0000\u00e8\u0000\u0122\u0000\u015c\u0000\u0196\u0000\u01d0\u0000\u020a\u0000\u0244\u0000\u027e\u0000\u02b8\u0000\u02f2\u0000\u032c\u0000\u0366\u0000\u03a0\u0000\u03da\u0000\u0414\u0000\u044e\u0000\u0488\u0000\u04c2\u0000\u04fc\u0000\u0536\u0000\u0570\u0000\u05aa\u0000\u05e4\u0000\u061e\u0000\u0658\u0000\u0692\u0000\u06cc\u0000\u0706\u0000\u0740\u0000\u077a\u0000\u07b4\u0000\u07ee\u0000\u0828\u0000\u0862\u0000\u089c\u0000\u08d6\u0000\u0910\u0000\u094a\u0000\u0984\u0000\u09be\u0000\u09f8\u0000\u0a32\u0000\u0a6c\u0000\u0aa6\u0000\u0ae0\u0000\u0b1a\u0000\u0b54\u0000\u0b54\u0000\u0658\u0000\u0b54\u0000\u0b54\u0000\u0b54\u0000\u0b8e\u0000\u0bc8\u0000\u0c02\u0000\u0c3c\u0000\u0b54\u0000\u0b54\u0000\u0c76\u0000\u0cb0\u0000\u0cea\u0000\u0d24\u0000\u0b54\u0000\u0b54\u0000\u0b54\u0000\u0b54\u0000\u0d5e\u0000\u0b54\u0000\u0d98\u0000\u0b54\u0000\u0dd2\u0000\u0b54\u0000\u0b54\u0000\u0b54\u0000\u0b54\u0000\u0e0c\u0000\u0e46\u0000\u0e80\u0000\u0eba\u0000\u0b54\u0000\u0b54\u0000\u0b54\u0000\u0b54\u0000\u0b54\u0000\u0b54\u0000\u0b54\u0000\u0ef4\u0000\u0b54\u0000\u0b54\u0000\u0f2e\u0000\u0f68\u0000\u0f68\u0000\u0b54\u0000\u0fa2\u0000\u0fa2\u0000\u0fdc\u0000\u1016\u0000\u1050\u0000\u108a\u0000\u0b54\u0000\u10c4\u0000\u10fe\u0000\u1138\u0000\u1172\u0000\u0b54\u0000\u11ac\u0000\u11e6\u0000\u1220\u0000\u125a\u0000\u1294\u0000\u12ce\u0000\u1308\u0000\u1342\u0000\u137c\u0000\u13b6\u0000\u0b54\u0000\u13f0\u0000\u142a\u0000\u1464\u0000\u0740\u0000\u149e\u0000\u14d8\u0000\u1512\u0000\u154c\u0000\u0b54\u0000\u0828\u0000\u1586\u0000\u0b54\u0000\u089c\u0000\u15c0\u0000\u0b54\u0000\u08d6\u0000\u0b54\u0000\u15fa\u0000\u1634\u0000\u0b54\u0000\u166e\u0000\u16a8\u0000\u0b54\u0000\u16e2\u0000\u171c\u0000\u0ae0\u0000\u0b54\u0000\u0b54\u0000\u1756\u0000\u1790\u0000\u0c02\u0000\u0b54\u0000\u17ca\u0000\u1804\u0000\u183e\u0000\u1878\u0000\u18b2\u0000\u18ec\u0000\u1926\u0000\u1960\u0000\u199a\u0000\u19d4\u0000\u1a0e\u0000\u1a48\u0000\u1a82\u0000\u1abc\u0000\u0b54\u0000\u1af6\u0000\u1050\u0000\u1b30\u0000\u0b54\u0000\u1b6a\u0000\u1ba4\u0000\u1bde\u0000\u1c18\u0000\u1c52\u0000\u1c8c\u0000\u1cc6\u0000\u1d00\u0000\u1d3a\u0000\u1d74\u0000\u1dae\u0000\u1de8\u0000\u1e22\u0000\u1e5c\u0000\u1e96\u0000\u1ed0\u0000\u1f0a\u0000\u1f44\u0000\u0b54\u0000\u0b54\u0000\u0b54\u0000\u0b54\u0000\u1f7e\u0000\u1fb8\u0000\u1ff2\u0000\u202c\u0000\u2066\u0000\u20a0\u0000\u20da\u0000\u2114\u0000\u214e\u0000\u2188\u0000\u21c2\u0000\u21fc\u0000\u2236\u0000\u2270\u0000\u0b54\u0000\u0b54\u0000\u22aa\u0000\u0b54\u0000\u22e4\u0000\u231e\u0000\u2358\u0000\u2392\u0000\u23cc\u0000\u2406\u0000\u2440\u0000\u247a\u0000\u24b4\u0000\u0b54\u0000\u24ee\u0000\u2528\u0000\u2562\u0000\u0b54\u0000\u259c\u0000\u25d6\u0000\u2610\u0000\u0b54\u0000\u264a\u0000\u2684\u0000\u26be\u0000\u26f8\u0000\u2732\u0000\u276c\u0000\u27a6\u0000\u0b54\u0000\u27e0\u0000\u281a\u0000\u2854\u0000\u288e\u0000\u28c8\u0000\u2902\u0000\u0b54\u0000\u0b54\u0000\u293c\u0000\u0b54\u0000\u0b54\u0000\u2976\u0000\u0b54\u0000\u29b0\u0000\u0b54\u0000\u29ea\u0000\u0b54\u0000\u2a24\u0000\u0b54\u0000\u2a5e\u0000\u2a98\u0000\u0b54\u0000\u2ad2\u0000\u2b0c\u0000\u2b46\u0000\u2b80\u0000\u2bba\u0000\u2bf4\u0000\u2c2e\u0000\u2c68\u0000\u2ca2\u0000\u2cdc\u0000\u2d16\u0000\u2d50\u0000\u2d8a\u0000\u0b54\u0000\u2dc4\u0000\u0b54\u0000\u0b54\u0000\u0b54\u0000\u0b54\u0000\u2dfe\u0000\u2e38\u0000\u0b54";
    private static final int[] ZZ_TRANS = XHTMLLexer.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u000f\u001b\u0001\u001c\u001e\u001b\u0001\u001d\u000b\u001b\b\u001e\u0001\u001f1\u001e8 \u0001!\u0001 3\"\u0001#\u0006\"\u000e$\u0001%+$3&\u0001'\u0006&\u000b(\u0001)$(\u0001*\u0001(\u0001+\u0001,\u0006(9-\u0001.\u0001\u0000\u0003/\u0001\u0000\u00040\u00011\u0001\u0000\u00012\u0003\u0000\u00013\n0\u00014\u00130\u00015\u0001\u0000\u00016\u0001\u0000\u00017\u0004\u0000\u00018\u0003\u0000\u00039\u0001\u0000\u0004:\u0001;\u0001\u0000\u0001<\u0003\u0000\u0001=\n:\u0001>\u0013:\u00015\b\u0000\u0001?\u0003\u0000\u0003@\u0001\u0000\u0006A\u0001B\u0003A\u0001C\nA\u0001>\u0013A\u00015\u0001\u0000\u0001D\u0001\u0000\u0001E\u0007\u0000\u000fF\u0001G F\u0001H\u0018F\u0001I\"F\u0001J\u0007F\u0001\u0000\u0003K\u000b\u0000\u0001L\n\u0000\u0001M \u0000\u0003K\u000b\u0000\u0001N\n\u0000\u0001M\u001f\u0000\u0003O\u0001\u0000\u000bO\u0001P%O\u0002\u0000\u0006O\u0001\u0000\u000bO\u0001Q%O\u0002\u0000\u0006O\u0001\u0000\u000bO\u0001R%O\u0002\u0000\u0006O\u0001\u0000\u000bO\u0001S%O\u0002\u0000\u0003O\u0001\u0000\u0006F\u0001\u0000\u0007F\u0001T\nF\u0001U\u0015F\u0001V\u0001F\u0001W\u0001F\u0001X\u0001\u0000\u0004F\u0001\u0000\u0006F\u0001\u0000(F\u0001Y\u0004F\u0001\u0000\u0004F\u0001\u0000\u0006F\u0001\u0000*F\u0001Z\u0002F\u0001\u0000\u0004F\u0001\u0000\u0006F\u0001\u0000\u0007F\u0001[ F\u0001\\\u0001F\u0001\\\u0002F\u0001\u0000\u0002F\u0001]\u0001F\u0001\u0000\u0006F\u0001\u0000\u0001^,F\u0001\u0000\u0004F\u0001_\u0006`\u0001_*`\u0001a\u0002`\u0001_\u0004`\u0001b\u0006c\u0001b(c\u0001a\u0004c\u0001b\u0004c\u000f\u001b\u0001\u0000\u001e\u001b\u0001\u0000\u000b\u001b\u0005\u0000\u0004d\u0001e\u0001\u0000\u0001f\u0001g\u0001\u0000\u0001h\u0001\u0000\u0002d\u0002i\u0002j\u0001d\u0002k\u0001l\u0001m\u0001n\u0001d\u0001o\u0002p\u0002d\u0002q\u0001r\u0002s\u0002t\u0004d\u0001u\u0005\u0000\u0001v\u000b\u0000\u0004w\u0001\u0000\u0001w\u0005\u0000\nw\u0001\u0000\u0013w\u0001\u0000\u0001x\n\u0000\b\u001e\u0001y1\u001e\bz\u0001{1z8 \u0001|\u0001 8}\u0001~\u0001}3\"\u0001\u007f\u0006\"\u001a\u0080\u0001\u0081\u0018\u0080\u0001\u007f\u0006\u0080\u000e$\u0001\u0082+$\u000e\u0083\u0001\u0082\u000b\u0083\u0001\u0084\u001f\u00833&\u0001\u0085\u0006&\u001a\u0086\u0001\u0087\u0018\u0086\u0001\u0085\u0006\u00860(\u0001\u0000\u0001(\u0002\u00006(\u0001\u0000\u0001(\u0002\u0000\u0005(\u0001\u00880*\u0001\u0089\u0001\u008a\b*1+\u0001\u008b\u0001\u0089\u0007+\u001a\u0000\u0001\u008c\u001f\u00009-\u0001\u008d\u000b\u008e\u0001\u008f-\u008e\u0001\u008d\u0001\u0000\u0003/\u0001\u0000\u00040\u00011\u0006\u0000\n0\u0001\u0000\u00130\r\u0000\u0003\u0090\u0001\u0000\u00040\u0001\u0091\u0006\u0000\n0\u0001\u0000\u00130\u0011\u0000\u0004\u0092\u0007\u0000\n\u0092\u0001\u0000\u0013\u0092&\u0000\u0001\u0093Z\u0000\u00039\u0001\u0000\u0004:\u0001;\u0006\u0000\n:\u0001\u0000\u0013:\t\u0000\u0001\u0094\u0003\u0000\u0003\u0095\u0001\u0000\u0004:\u0001\u0096\u0006\u0000\n:\u0001\u0000\u0013:\u0011\u0000\u0004\u0097\u0007\u0000\n\u0097\u0001\u0000\u0013\u0097&\u0000\u0001\u0098 \u0000\u0003?7\u0000\u0003@7\u0000\u0003\u0099\u0001\u0000\nA\u0001\u0000\nA\u0001\u0000\u0013A\r\u0000\u0003\u0099\u0001\u0000\nA\u0001\u0000\nA\u0001\u0098\u0013A?\u0000\u0001\u009a9\u0000\u0001\u009b\u0007\u0000\u0003KA\u0000\u0001\u009c\u0001\u009d&\u0000\u0001\u009e\u0011\u0000\u0001\u009f'\u0000\u0001\u00a0\u0011\u0000\u0001\u00a1'\u0000\u0001\u00a2\u0011\u0000\u0001\u00a3'\u0000\u0001\u00a4\u0012\u0000\u0001\u00a55\u0000\u0001\u00a61\u00002_\u0001\u00a7\u0007_0b\u0001\u00a7\tb\u0005\u0000\u0004d\u0001e\u0001\u0000\u0001\u00a8\u0004\u0000\nd\u0001m\u0013d\u0011\u0000\u0004e\u0002\u0000\u0001\u00a8\u0004\u0000\ne\u0001m\u0013e\u0011\u0000\u0004\u00a9\u0001\u00aa\u0006\u0000\n\u00a9\u0001\u00ab\u0013\u00a9\u0012\u0000\u0001\u00ac\u0001\u0000\u0001\u00ad\u0007\u0000\u0001\u00ac#\u0000\u0001\u00ae\n\u0000\u0004d\u0001e\u0001\u0000\u0001\u00a8\u0004\u0000\u0001d\u0001\u00af\bd\u0001m\u0013d\u0011\u0000\u0004d\u0001e\u0001\u0000\u0001\u00a8\u0004\u0000\nd\u0001m\u0001d\u0001\u00b0\u0011d\u0011\u0000\u0004d\u0001e\u0001\u0000\u0001\u00a8\u0004\u0000\nd\u0001m\u0007d\u0002\u00b1\nd\u0011\u0000\u0004d\u0001e\u0001\u0000\u0001\u00a8\u0004\u0000\nd\u0001m\nd\u0002\u00b2\u0007d\u0011\u0000\u0004d\u0001e\u0001\u0000\u0001\u00a8\u0004\u0000\u0001d\u0001\u00b3\bd\u0001m\u0013d\u0011\u0000\u0004d\u0001e\u0001\u0000\u0001\u00a8\u0004\u0000\nd\u0001m\nd\u0002\u00b4\u0003d\u0001\u00b5\u0003d\u0011\u0000\u0004d\u0001e\u0001\u0000\u0001\u00a8\u0004\u0000\nd\u0001m\u0002d\u0001\u00b6\u0010d\u0011\u0000\u0004d\u0001e\u0001\u0000\u0001\u00a8\u0004\u0000\nd\u0001m\u0001d\u0001\u00b7\u0011d\u0011\u0000\u0004d\u0001e\u0001\u0000\u0001\u00a8\u0004\u0000\nd\u0001m\u0001d\u0001\u00b8\u0005d\u0002\u00b9\nd\u0011\u0000\u0004d\u0001e\u0001\u0000\u0001\u00a8\u0004\u0000\td\u0001\u00ba\u0001m\u0013d\u0011\u0000\u0004d\u0001e\u0001\u0000\u0001\u00a8\u0004\u0000\nd\u0001m\u0001d\u0001\u00b8\u0011d\u0011\u0000\u0004d\u0001e\u0001\u0000\u0001\u00a8\u0004\u0000\nd\u0001m\td\u0001t\td$\u0000\u0001\u00bb\b\u0000\u0001\u00bc\u001d\u0000\u0004w\u0007\u0000\nw\u0001\u0000\u0013w\u0001\u0000\u0001x\n\u0000\bz\u0001\u00bd9z\u0001y9z\u0001\u00bd\u0011z\u0001\u00be\u001fz8}\u0001|\u001b}\u0001\u00bf\u001d}\u0001~\u0001}\u001a\u0080\u0001\u00c0\u0018\u0080\u0001\u007f9\u0080\u0001\u007f\u0006\u0080\u000e\u0083\u0001\u0082+\u00833\u0086\u0001\u0085\u0006\u00861*\u0001\u008a\b*1+\u0001\u008b\b+\u000b\u008e\u0001\u00c1-\u008e\u0001\u008d9\u008e\u0001\u008d\u0001\u0000\u0003\u0090;\u0000\u0004\u00c2\u0007\u0000\n\u00c2\u0001\u0000\u0013\u00c2\r\u0000\u0003\u0095;\u0000\u0004\u00c3\u0007\u0000\n\u00c3\u0001\u0000\u0013\u00c3\r\u0000\u0003\u0099N\u0000\u0001\u00c49\u0000\u0001\u00c5<\u0000\u0001\u00c6&\u0000\u0001\u00c7I\u0000\u0001\u00c8<\u0000\u0001\u00c96\u0000\u0001\u00ca5\u0000\u0002\u00cb<\u0000\u0001\u00cc5\u0000\u0002\u00cd<\u0000\u0001\u00ce)\u0000\u0001\u00cfK\u0000\u0001\u00d09\u0000\u0001\u00d1$\u0000\u0004\u00aa\u0007\u0000\n\u00aa\u0001\u00ab\u0013\u00aa\u001d\u0000\u0001\u00d20\u0000\u0001\u00d3C\u0000\u0001\u00d4,\u0000\u0004d\u0001e\u0001\u0000\u0001\u00a8\u0004\u0000\nd\u0001m\u0003d\u0002\u00b8\u000ed\u0011\u0000\u0004d\u0001e\u0001\u0000\u0001\u00a8\u0004\u0000\nd\u0001m\u0007d\u0002\u00d5\nd\u0011\u0000\u0004d\u0001e\u0001\u0000\u0001\u00a8\u0004\u0000\nd\u0001m\u0001d\u0001\u00d6\u0011d\u0011\u0000\u0004d\u0001e\u0001\u0000\u0001\u00a8\u0004\u0000\nd\u0001m\td\u0001\u00d7\td\u0011\u0000\u0004d\u0001e\u0001\u0000\u0001\u00a8\u0004\u0000\nd\u0001m\u0010d\u0001\u00d8\u0002d\u0011\u0000\u0004d\u0001e\u0001\u0000\u0001\u00a8\u0004\u0000\nd\u0001m\u000ed\u0001\u00b8\u0004d\u0011\u0000\u0004d\u0001e\u0001\u0000\u0001\u00a8\u0004\u0000\u0007d\u0002\u00d9\u0001d\u0001m\u0013d\u0011\u0000\u0004d\u0001e\u0001\u0000\u0001\u00a8\u0004\u0000\nd\u0001m\u000fd\u0001\u00da\u0003d\u0011\u0000\u0004d\u0001e\u0001\u0000\u0001\u00a8\u0004\u0000\td\u0001\u00db\u0001m\u0013d\u0011\u0000\u0004d\u0001e\u0001\u0000\u0001\u00dc\u0004\u0000\nd\u0001\u00dd\u0013d\u0011\u0000\u0004d\u0001e\u0001\u0000\u0001\u00a8\u0004\u0000\nd\u0001m\u0001\u00de\u0012d\u0011\u0000\u0004d\u0001e\u0001\u0000\u0001\u00a8\u0004\u0000\u0004d\u0002\u00db\u0004d\u0001m\u0013d4\u0000\u0001\u00df7\u0000\u0001\u00e0\u0013\u0000\bz\u0001\u00bd\u0011z\u0001\u00e1\u001fz\u0001\u0000\u0003\u0090\u0001\u0000\u0004\u00c2\u0007\u0000\n\u00c2\u0001\u0000\u0013\u00c2\r\u0000\u0003\u0095\u0001\u0000\u0004\u00c3\u0007\u0000\n\u00c3\u0001\u0000\u0013\u00c34\u0000\u0001\u00e29\u0000\u0001\u00e3#\u0000\u0002\u00e4.\u0000\u0001\u00e5Y\u0000\u0001\u00e6%\u0000\u0002\u00e7L\u0000\u0001\u00e8*\u0000\u0001\u00e9H\u0000\u0001\u00ea.\u0000\u0001\u00ebD\u0000\u0001\u00ec\u0019\u0000\u0001\u00edC\u0000\u0002\u00ee,\u0000\u0001\u00ef8\u0000\u0004d\u0001e\u0001\u0000\u0001\u00a8\u0004\u0000\u0002d\u0002\u00da\u0006d\u0001m\u0013d\u0011\u0000\u0004d\u0001e\u0001\u0000\u0001\u00a8\u0004\u0000\nd\u0001m\u0007d\u0002\u00f0\nd\u0011\u0000\u0004d\u0001e\u0001\u0000\u0001\u00a8\u0004\u0000\td\u0001\u00f1\u0001m\u0013d\u0011\u0000\u0004d\u0001e\u0001\u0000\u0001\u00a8\u0004\u0000\nd\u0001m\u0001d\u0001\u00f2\u0011d\u0011\u0000\u0004d\u0001e\u0001\u0000\u0001\u00a8\u0004\u0000\nd\u0001m\u0010d\u0001\u00f3\u0002d\u0011\u0000\u0004d\u0001e\u0001\u0000\u0001\u00a8\u0004\u0000\nd\u0001m\u0011d\u0001\u00b8\u0001d\u0011\u0000\u0004d\u0001e\u0001\u0000\u0001\u00a8\u0004\u0000\nd\u0001m\u0007d\u0002\u00b8\nd&\u0000\u0001\u00f4$\u0000\u0004d\u0001e\u0001\u0000\u0001\u00a8\u0004\u0000\td\u0001\u00b8\u0001m\u0013d$\u0000\u0001\u00f5@\u0000\u0001\u00f62\u0000\u0001\u00f79\u0000\u0001\u00f8=\u0000\u0001\u00f95\u0000\u0001\u00fa7\u0000\u0001\u00fb;\u0000\u0001\u00fcA\u0000\u0002\u00fd0\u0000\u0001\u00fe5\u0000\u0002\u00ff<\u0000\u0001\u01005\u0000\u0002\u0101F\u0000\u0001\u0102\u001c\u0000\u0004d\u0001e\u0001\u0000\u0001\u00a8\u0004\u0000\nd\u0001m\nd\u0002\u00b8\u0007d\u0011\u0000\u0001d\u0001\u00b8\u0002d\u0001e\u0001\u0000\u0001\u00a8\u0004\u0000\u0001\u00b8\td\u0001m\u0013d\u0011\u0000\u0004d\u0001e\u0001\u0000\u0001\u00a8\u0004\u0000\u0002d\u0002\u00de\u0006d\u0001m\u0013d\u0011\u0000\u0004d\u0001e\u0001\u0000\u0001\u00a8\u0004\u0000\u0004d\u0002\u00b8\u0004d\u0001m\u0013d\r\u0000\u0001\u0103U\u0000\u0001\u0104:\u0000\u0002\u0105.\u0000\u0002\u0106B\u0000\u0002\u01070\u0000\u0001\u01087\u0000\u0001\u0109<\u0000\u0002\u010a:\u0000\u0001\u010bB\u0000\u0002\u010c/\u0000\u0001\u010d7\u0000\u0002\u010eC\u0000\u0001\u010f+\u0000\u0002\u0110>\u0000\u0001\u0111;\u0000\u0001\u01127\u0000\u0001\u01138\u0000\u0001\u0114T\u0000\u0001\u0115\u001f\u0000\u0001\u01168\u0000\u0001\u0117B\u0000\u0002\u01180\u0000\u0001\u0119\u001f\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unkown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = XHTMLLexer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u001a\u0000\u0016\u0001\u0001\u0000\u0001\u0001\u0002\t\u0001\u0000\u0003\t\u0001\u0000\u0001\u0001\u0001\u0000\u0001\u0001\u0002\t\u0004\u0001\u0004\t\u0001\u0001\u0001\t\u0001\u0001\u0001\t\u0001\u0001\u0004\t\u0004\u0001\u0007\t\u0001\u0001\u0002\t\u0001\u0001\u0001\u0000\u0001\u0001\u0001\t\u0001\u0000\u0005\u0001\u0001\t\u0004\u0001\u0001\t\t\u0001\u0001\u0000\u0001\t\b\u0000\u0001\t\u0002\u0000\u0001\t\u0002\u0000\u0001\t\u0001\u0001\u0001\t\u0002\u0001\u0001\t\u0002\u0000\u0001\t\u0003\u0001\u0002\t\u0003\u0001\u0001\t\u0001\u0001\r\u0000\u0001\t\u0001\u0000\u0002\u0001\u0001\t\u0003\u0000\f\u0001\u0003\u0000\u0004\t\u0002\u0001\f\u0000\u0002\t\u0001\u0000\u0001\t\u0001\u0000\u0007\u0001\u0001\u0000\u0001\t\u0001\u0001\u0002\u0000\u0001\t\u0003\u0000\u0001\t\u0007\u0000\u0001\t\u0002\u0000\u0004\u0001\u0002\t\u0001\u0000\u0002\t\u0001\u0000\u0001\t\u0001\u0000\u0001\t\u0001\u0000\u0001\t\u0001\u0000\u0001\t\u0002\u0000\u0001\t\u0007\u0000\u0001\u0001\u0001\u0000\u0001\u0001\u0002\u0000\u0001\u0001\u0001\t\u0001\u0000\u0004\t\u0001\u0000\u0001\u0001\u0001\t";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[16384];
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private boolean zzEOFDone;
    public static final byte SYM_TEXT = 0;
    public static final byte SYM_INVALID = 10;
    public static final byte SYM_ENTITY = 5;
    public static final byte SYM_AUTO_CLOSING_TAG = 6;
    public static final byte SYM_TAG_START = 6;
    public static final byte SYM_OPEN_TAG_CLOSE = 6;
    public static final byte SYM_OPEN_TAG_END = 6;
    public static final byte SYM_OPEN_START_TAG = 6;
    public static final byte SYM_CLOSE_TAG = 6;
    public static final byte SYM_LT = 6;
    public static final byte SYM_SLASH = 6;
    public static final byte SYM_VOID_TAG = 17;
    public static final byte SYM_INSTR_START = 8;
    public static final byte SYM_INSTR = 8;
    public static final byte SYM_INSTR_END = 8;
    public static final byte SYM_XML_HEADER = 16;
    public static final byte SYM_COMMENT_START = 1;
    public static final byte SYM_COMMENT = 1;
    public static final byte SYM_COMMENT_END = 1;
    public static final byte SYM_CDATA = 11;
    public static final byte SYM_JSP = 8;
    public static final byte SYM_ATTRIBUTE_NAME = 7;
    public static final byte SYM_EQ = 9;
    public static final byte SYM_ATTRIBUTE_VALUE_DQ = 3;
    public static final byte SYM_ATTRIBUTE_VALUE_SQ = 4;
    public static final byte SYM_DOCTYPE_INNER = 12;
    public static final byte SYM_DOCTYPE_INNER_COMMENT = 12;
    public static final byte SYM_DOCTYPE_STRING_DQ = 12;
    public static final byte SYM_DOCTYPE_STRING_SQ = 12;
    public static final byte SYM_DOCTYPE = 2;
    private boolean forPHP = false;
    private boolean isHTML = false;
    private boolean onEscapeableAttr = false;
    private boolean inScript = false;
    private boolean inStyle = false;
    private boolean inTextArea = false;
    private boolean inTitle = false;
    private boolean inVoidTag = false;
    private String tagName = null;
    private static final LexicalState INITIAL_STATE = new LexicalStateOverLong4HTML();

    private static int[] zzUnpackAction() {
        int[] result = new int[281];
        int offset = 0;
        offset = XHTMLLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[281];
        int offset = 0;
        offset = XHTMLLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[11890];
        int offset = 0;
        offset = XHTMLLexer.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[281];
        int offset = 0;
        offset = XHTMLLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    public XHTMLLexer(boolean forPHP, boolean isHTML) {
        this.forPHP = forPHP;
        this.isHTML = isHTML;
    }

    @Override
    protected LexicalState createLexicalState() {
        return new LexicalStateOverLong4HTML();
    }

    @Override
    protected LexicalState getInitialLexicalState() {
        return INITIAL_STATE;
    }

    @Override
    public LexicalState getLexicalState() {
        LexicalState lexicalState = super.getLexicalState();
        LexicalStateOverLong4HTML lsol4h = (LexicalStateOverLong4HTML)lexicalState;
        lsol4h.inSpecialElement = 0;
        if (this.inScript) {
            lsol4h.inSpecialElement = 1;
        } else if (this.inStyle) {
            lsol4h.inSpecialElement = (byte)2;
        } else if (this.inTextArea) {
            lsol4h.inSpecialElement = (byte)3;
        } else if (this.inTitle) {
            lsol4h.inSpecialElement = (byte)4;
        }
        lsol4h.inSpecialAttribute = 0;
        if (this.onEscapeableAttr) {
            lsol4h.inSpecialAttribute = 1;
        }
        lsol4h.inVoidTag = this.inVoidTag;
        lsol4h.tagName = this.tagName;
        return lexicalState;
    }

    @Override
    public void setLexicalState(LexicalState lexicalState) {
        super.setLexicalState(lexicalState);
        LexicalStateOverLong4HTML lsol4h = (LexicalStateOverLong4HTML)lexicalState;
        this.inVoidTag = lsol4h.inVoidTag;
        this.tagName = lsol4h.tagName;
        this.onEscapeableAttr = lsol4h.inSpecialAttribute == 1;
        this.inScript = false;
        this.inStyle = false;
        this.inTextArea = false;
        this.inTitle = false;
        switch (lsol4h.inSpecialElement) {
            case 1: {
                this.inScript = true;
                break;
            }
            case 2: {
                this.inStyle = true;
                break;
            }
            case 3: {
                this.inTextArea = true;
                break;
            }
            case 4: {
                this.inTitle = true;
                break;
            }
        }
    }

    private boolean isSpecialAttribute(String elementName, String attrName) {
        return this.isHTML && (JSAttributesRecognizer.getInstance().isJSAttribute(elementName, attrName) || EscapeableAttributesRecognizer.getInstance().isSpecialAttribute(elementName, attrName));
    }

    private void checkSpecialTags(String tokenText) {
        if (!(this.inScript || this.inTextArea || this.inStyle || this.inTitle)) {
            if (tokenText.equals("<script") || tokenText.equals("<script>")) {
                this.inScript = true;
                return;
            }
            if (!this.isHTML) {
                return;
            }
            if (tokenText.equals("<textarea") || tokenText.equals("<textarea>")) {
                this.inTextArea = true;
                return;
            }
            if (tokenText.equals("<style") || tokenText.equals("<style>")) {
                this.inStyle = true;
                return;
            }
            if (tokenText.equals("<title") || tokenText.equals("<title>")) {
                this.inTitle = true;
                return;
            }
        }
    }

    private boolean isSpecialElement() {
        return this.inScript || this.inStyle || this.inTextArea || this.inTitle;
    }

    private boolean isSpecialAttribute() {
        return this.onEscapeableAttr;
    }

    private void exitSpecialElement() {
        this.inScript = false;
        this.inStyle = false;
        this.inTextArea = false;
        this.inTitle = false;
    }

    @Override
    public String getName() {
        return this.isHTML ? "HTML" : "XML";
    }

    public XHTMLLexer(Reader in) {
        this.zzReader = in;
    }

    public XHTMLLexer(InputStream in) {
        this(new InputStreamReader(in, Charset.forName("UTF-8")));
    }

    private static char[] zzUnpackCMap(String packed) {
        char[] map = new char[65536];
        int i = 0;
        int j = 0;
        while (i < 342) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    private boolean zzRefill() throws IOException {
        int numRead;
        if (this.zzStartRead > 0) {
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length) {
            char[] newBuffer = new char[this.zzCurrentPos * 2];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, this.zzBuffer.length - this.zzEndRead)) > 0) {
            this.zzEndRead += numRead;
            return false;
        }
        if (numRead == 0) {
            int c = this.zzReader.read();
            if (c == -1) {
                return true;
            }
            this.zzBuffer[this.zzEndRead++] = (char)c;
            return false;
        }
        return true;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    @Override
    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzEOFDone = false;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzMarkedPos = 0;
        this.zzCurrentPos = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.zzLexicalState = 0;
        if (this.zzBuffer.length > 16384) {
            this.zzBuffer = new char[16384];
        }
    }

    @Override
    public final int yystate() {
        return this.zzLexicalState;
    }

    @Override
    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    @Override
    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer[this.zzStartRead + pos];
    }

    @Override
    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) throws LexerException {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new LexerException(message);
    }

    public void yypushback(int number) throws LexerException {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    @Override
    public Symbol yylex() throws IOException, LexerException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        char[] zzCMapL = ZZ_CMAP;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block234: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            this.yychar += zzMarkedPosL - this.zzStartRead;
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            int zzAttributes = zzAttrL[this.zzState];
            if ((zzAttributes & 1) == 1) {
                zzAction = this.zzState;
            }
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = zzBufferL[zzCurrentPosL++];
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = zzBufferL[zzCurrentPosL++];
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + zzCMapL[zzInput]];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 1: {
                    return this.symbol((byte)0);
                }
                case 95: {
                    continue block234;
                }
                case 2: {
                    this.yybegin(16);
                    return this.symbol((byte)6);
                }
                case 96: {
                    continue block234;
                }
                case 3: {
                    return this.symbol(this.isHTML ? (byte)0 : 10);
                }
                case 97: {
                    continue block234;
                }
                case 4: {
                    this.cLen += this.yylength();
                }
                case 98: {
                    continue block234;
                }
                case 5: {
                    ++this.cLen;
                }
                case 99: {
                    continue block234;
                }
                case 6: {
                    return this.symbol((byte)7);
                }
                case 100: {
                    continue block234;
                }
                case 7: {
                    this.yybegin(18);
                    this.onEscapeableAttr = this.isSpecialAttribute(this.tagName, this.yytext().trim());
                    return this.symbol((byte)7);
                }
                case 101: {
                    continue block234;
                }
                case 8: {
                    return this.symbol((byte)6);
                }
                case 102: {
                    continue block234;
                }
                case 9: {
                    this.inVoidTag = false;
                    this.onEscapeableAttr = false;
                    this.yypushback(1);
                    this.yybegin(0);
                }
                case 103: {
                    continue block234;
                }
                case 10: {
                    if (this.isSpecialElement()) {
                        this.yybegin(this.popState());
                    } else {
                        this.yybegin(0);
                    }
                    this.onEscapeableAttr = false;
                    if (this.inVoidTag) {
                        this.inVoidTag = false;
                        return this.symbol(this.isHTML ? (byte)17 : 6);
                    }
                    return this.symbol((byte)6);
                }
                case 104: {
                    continue block234;
                }
                case 11: {
                    this.onEscapeableAttr = false;
                    this.yybegin(22);
                    this.cLen = 1;
                }
                case 105: {
                    continue block234;
                }
                case 12: {
                    this.onEscapeableAttr = false;
                    this.yybegin(24);
                    this.cLen = 1;
                }
                case 106: {
                    continue block234;
                }
                case 13: {
                    this.yypushback(1);
                    this.onEscapeableAttr = false;
                    this.yybegin(18);
                }
                case 107: {
                    continue block234;
                }
                case 14: {
                    this.onEscapeableAttr = this.isSpecialAttribute(this.tagName, this.yytext().trim());
                    return this.symbol((byte)7);
                }
                case 108: {
                    continue block234;
                }
                case 15: {
                    this.yypushback(1);
                    this.onEscapeableAttr = false;
                    this.inVoidTag = false;
                    this.yybegin(0);
                }
                case 109: {
                    continue block234;
                }
                case 16: {
                    this.yybegin(0);
                    this.onEscapeableAttr = false;
                    if (this.inVoidTag) {
                        this.inVoidTag = false;
                        return this.symbol(this.isHTML ? (byte)17 : 6);
                    }
                    return this.symbol((byte)6);
                }
                case 110: {
                    continue block234;
                }
                case 17: {
                    this.yybegin(20);
                    return this.symbol((byte)9);
                }
                case 111: {
                    continue block234;
                }
                case 18: {
                    this.onEscapeableAttr = false;
                    String tokenText = this.yytext();
                    int back = tokenText.length() - tokenText.trim().length();
                    if (back > 0) {
                        this.yypushback(back);
                    }
                    this.yybegin(16);
                    return this.symbol((byte)3);
                }
                case 112: {
                    continue block234;
                }
                case 19: {
                    this.yypushback(1);
                    this.inVoidTag = false;
                    this.onEscapeableAttr = false;
                    this.yybegin(0);
                }
                case 113: {
                    continue block234;
                }
                case 20: {
                    this.yybegin(22);
                    this.cLen = 1;
                }
                case 114: {
                    continue block234;
                }
                case 21: {
                    this.yybegin(24);
                    this.cLen = 1;
                }
                case 115: {
                    continue block234;
                }
                case 22: {
                    if (this.onEscapeableAttr) {
                        ++this.cLen;
                    } else {
                        this.yypushback(1);
                        this.inVoidTag = false;
                        this.yybegin(0);
                        return this.flush((byte)3);
                    }
                }
                case 116: {
                    continue block234;
                }
                case 23: {
                    ++this.cLen;
                    this.yybegin(16);
                    this.onEscapeableAttr = false;
                    return this.flush((byte)3);
                }
                case 117: {
                    continue block234;
                }
                case 24: {
                    if (this.onEscapeableAttr) {
                        ++this.cLen;
                    } else {
                        this.yypushback(1);
                        this.inVoidTag = false;
                        this.yybegin(0);
                        return this.flush((byte)4);
                    }
                }
                case 118: {
                    continue block234;
                }
                case 25: {
                    ++this.cLen;
                    this.yybegin(16);
                    this.onEscapeableAttr = false;
                    return this.flush((byte)4);
                }
                case 119: {
                    continue block234;
                }
                case 26: {
                    return this.symbol((byte)7);
                }
                case 120: {
                    continue block234;
                }
                case 27: {
                    this.yypushback(1);
                    this.yybegin(0);
                }
                case 121: {
                    continue block234;
                }
                case 28: {
                    this.yybegin(0);
                    return this.symbol((byte)6);
                }
                case 122: {
                    continue block234;
                }
                case 29: {
                    this.yypushback(1);
                    this.yybegin(0);
                }
                case 123: {
                    continue block234;
                }
                case 30: {
                    ++this.cLen;
                }
                case 124: {
                    continue block234;
                }
                case 31: {
                    this.yypushback(1);
                    this.yybegin(0);
                    return this.flush((byte)2);
                }
                case 125: {
                    continue block234;
                }
                case 32: {
                    this.yybegin(0);
                    ++this.cLen;
                    return this.flush((byte)2);
                }
                case 126: {
                    continue block234;
                }
                case 33: {
                    this.yybegin(40);
                    ++this.cLen;
                }
                case 127: {
                    continue block234;
                }
                case 34: {
                    this.yybegin(42);
                    ++this.cLen;
                }
                case 128: {
                    continue block234;
                }
                case 35: {
                    ++this.cLen;
                    this.yybegin(44);
                    return this.flush((byte)2);
                }
                case 129: {
                    continue block234;
                }
                case 36: {
                    ++this.cLen;
                    this.yybegin(38);
                }
                case 130: {
                    continue block234;
                }
                case 37: {
                    ++this.cLen;
                    this.yybegin(38);
                }
                case 131: {
                    continue block234;
                }
                case 38: {
                    if (this.cLen > 0) {
                        this.yypushback(1);
                        return this.flush((byte)12);
                    }
                    if (this.yycharat(0) == '\"') {
                        this.yybegin(50);
                    } else {
                        this.yybegin(48);
                    }
                    return this.symbol((byte)12);
                }
                case 132: {
                    continue block234;
                }
                case 39: {
                    if (this.cLen > 0) {
                        this.yypushback(1);
                        return this.flush((byte)12);
                    }
                    this.yybegin(38);
                    return this.symbol((byte)2);
                }
                case 133: {
                    continue block234;
                }
                case 40: {
                    this.yybegin(44);
                    return this.symbol((byte)12);
                }
                case 134: {
                    continue block234;
                }
                case 41: {
                    this.checkSpecialTags(this.yytext().toLowerCase());
                    this.tagName = this.yytext().substring(1);
                    if (this.inScript) {
                        this.pushState(30);
                    } else if (this.inStyle) {
                        this.pushState(32);
                    } else if (this.inTextArea) {
                        this.pushState(34);
                    } else if (this.inTitle) {
                        this.pushState(36);
                    }
                    this.yybegin(16);
                    return this.symbol((byte)6);
                }
                case 135: {
                    continue block234;
                }
                case 42: {
                    return this.symbol((byte)6);
                }
                case 136: {
                    continue block234;
                }
                case 43: {
                    return this.symbol((byte)10);
                }
                case 137: {
                    continue block234;
                }
                case 44: {
                    this.yybegin(8);
                    this.yypushback(2);
                    this.cLen = 0;
                }
                case 138: {
                    continue block234;
                }
                case 45: {
                    this.checkSpecialTags(this.yytext().toLowerCase());
                    if (this.inScript) {
                        this.yybegin(30);
                    } else if (this.inStyle) {
                        this.yybegin(32);
                    } else if (this.inTextArea) {
                        this.yybegin(34);
                    } else if (this.inTitle) {
                        this.yybegin(36);
                    }
                    return this.symbol((byte)6);
                }
                case 139: {
                    continue block234;
                }
                case 46: {
                    this.yybegin(6);
                    return this.symbol((byte)8);
                }
                case 140: {
                    continue block234;
                }
                case 47: {
                    return this.symbol((byte)5);
                }
                case 141: {
                    continue block234;
                }
                case 48: {
                    this.yybegin(this.popState());
                    return this.symbol((byte)8);
                }
                case 142: {
                    continue block234;
                }
                case 49: {
                    this.yybegin(0);
                    return this.symbol((byte)8);
                }
                case 143: {
                    continue block234;
                }
                case 50: {
                    this.yybegin(0);
                    return this.symbol((byte)16);
                }
                case 144: {
                    continue block234;
                }
                case 51: {
                    this.cLen += this.yylength();
                    this.yybegin(14);
                }
                case 145: {
                    continue block234;
                }
                case 52: {
                    if (this.cLen > 0) {
                        this.yypushback(2);
                        return this.flush((byte)8);
                    }
                    this.yybegin(this.popState());
                    return this.symbol((byte)8);
                }
                case 146: {
                    continue block234;
                }
                case 53: {
                    this.cLen += this.yylength();
                    this.yybegin(12);
                }
                case 147: {
                    continue block234;
                }
                case 54: {
                    this.yybegin(18);
                    this.onEscapeableAttr = false;
                    return this.symbol((byte)7);
                }
                case 148: {
                    continue block234;
                }
                case 55: {
                    this.yybegin(18);
                    this.onEscapeableAttr = false;
                    return this.symbol((byte)7);
                }
                case 149: {
                    continue block234;
                }
                case 56: {
                    if (this.isSpecialElement()) {
                        this.popState();
                        this.exitSpecialElement();
                    }
                    this.yybegin(0);
                    this.onEscapeableAttr = false;
                    if (this.inVoidTag) {
                        this.inVoidTag = false;
                        return this.symbol(this.isHTML ? (byte)17 : 6);
                    }
                    return this.symbol((byte)6);
                }
                case 150: {
                    continue block234;
                }
                case 57: {
                    this.yypushback(1);
                    return this.symbol((byte)7);
                }
                case 151: {
                    continue block234;
                }
                case 58: {
                    this.onEscapeableAttr = false;
                    return this.symbol((byte)7);
                }
                case 152: {
                    continue block234;
                }
                case 59: {
                    this.onEscapeableAttr = false;
                    return this.symbol((byte)7);
                }
                case 153: {
                    continue block234;
                }
                case 60: {
                    this.yybegin(0);
                    this.onEscapeableAttr = false;
                    if (this.inVoidTag) {
                        this.inVoidTag = false;
                        return this.symbol(this.isHTML ? (byte)17 : 6);
                    }
                    return this.symbol((byte)6);
                }
                case 154: {
                    continue block234;
                }
                case 61: {
                    this.yypushback(1);
                    return this.symbol((byte)12);
                }
                case 155: {
                    continue block234;
                }
                case 62: {
                    if (this.isSpecialElement()) {
                        this.popState();
                        this.exitSpecialElement();
                    }
                    this.yybegin(26);
                    return this.symbol((byte)6);
                }
                case 156: {
                    continue block234;
                }
                case 63: {
                    if (this.isSpecialElement()) {
                        this.popState();
                        this.exitSpecialElement();
                    }
                    return this.symbol((byte)6);
                }
                case 157: {
                    continue block234;
                }
                case 64: {
                    this.inVoidTag = true;
                    this.tagName = this.yytext().substring(1);
                    this.yybegin(16);
                    return this.symbol(this.isHTML ? (byte)17 : 6);
                }
                case 158: {
                    continue block234;
                }
                case 65: {
                    this.yybegin(this.popState());
                    return this.symbol((byte)1);
                }
                case 159: {
                    continue block234;
                }
                case 66: {
                    this.yybegin(0);
                    return this.symbol((byte)11);
                }
                case 160: {
                    continue block234;
                }
                case 67: {
                    this.yypushback(2);
                    return this.symbol((byte)8);
                }
                case 161: {
                    continue block234;
                }
                case 68: {
                    this.cLen += this.yylength() - 2;
                    this.yypushback(2);
                }
                case 162: {
                    continue block234;
                }
                case 69: {
                    this.yybegin(44);
                    this.cLen += 3;
                }
                case 163: {
                    continue block234;
                }
                case 70: {
                    return this.symbol((byte)6);
                }
                case 164: {
                    continue block234;
                }
                case 71: {
                    this.yybegin(2);
                    this.pushState(0);
                    this.cLen = 0;
                    return this.symbol((byte)1);
                }
                case 165: {
                    continue block234;
                }
                case 72: {
                    return this.symbol(this.isHTML ? (byte)17 : 6);
                }
                case 166: {
                    continue block234;
                }
                case 73: {
                    this.yypushback(3);
                    return this.symbol((byte)1);
                }
                case 167: {
                    continue block234;
                }
                case 74: {
                    if (this.cLen > 0) {
                        this.yypushback(this.yylength());
                        return this.flush((byte)0);
                    }
                    this.yybegin(2);
                    this.pushState(30);
                    return this.symbol((byte)1);
                }
                case 168: {
                    continue block234;
                }
                case 75: {
                    this.cLen += 4;
                    this.yybegin(46);
                }
                case 169: {
                    continue block234;
                }
                case 76: {
                    return this.symbol(this.isHTML ? (byte)17 : 6);
                }
                case 170: {
                    continue block234;
                }
                case 77: {
                    this.yypushback(3);
                    this.pushState(0);
                    this.yybegin(this.forPHP ? 12 : 6);
                    return this.symbol((byte)8);
                }
                case 171: {
                    continue block234;
                }
                case 78: {
                    if (this.cLen > 0) {
                        this.yypushback(this.yylength());
                        return this.flush((byte)3);
                    }
                    this.yypushback(3);
                    this.pushState(22);
                    this.yybegin(12);
                    return this.symbol((byte)8);
                }
                case 172: {
                    continue block234;
                }
                case 79: {
                    if (this.cLen > 0) {
                        this.yypushback(this.yylength());
                        return this.flush((byte)4);
                    }
                    this.yypushback(3);
                    this.pushState(24);
                    this.yybegin(12);
                    return this.symbol((byte)8);
                }
                case 173: {
                    continue block234;
                }
                case 80: {
                    if (this.cLen > 0) {
                        this.yypushback(this.yylength());
                        return this.flush((byte)0);
                    }
                    this.yypushback(3);
                    this.pushState(30);
                    this.yybegin(this.forPHP ? 12 : 6);
                    return this.symbol((byte)8);
                }
                case 174: {
                    continue block234;
                }
                case 81: {
                    if (this.cLen > 0) {
                        this.yypushback(this.yylength());
                        return this.flush((byte)0);
                    }
                    this.yypushback(3);
                    this.pushState(32);
                    this.yybegin(this.forPHP ? 12 : 6);
                    return this.symbol((byte)8);
                }
                case 175: {
                    continue block234;
                }
                case 82: {
                    if (this.cLen > 0) {
                        this.yypushback(this.yylength());
                        return this.flush((byte)0);
                    }
                    this.yypushback(3);
                    this.pushState(34);
                    this.yybegin(this.forPHP ? 12 : 6);
                    return this.symbol((byte)8);
                }
                case 176: {
                    continue block234;
                }
                case 83: {
                    if (this.cLen > 0) {
                        this.yypushback(this.yylength());
                        return this.flush((byte)0);
                    }
                    this.yypushback(3);
                    this.pushState(36);
                    this.yybegin(this.forPHP ? 12 : 6);
                    return this.symbol((byte)8);
                }
                case 177: {
                    continue block234;
                }
                case 84: {
                    this.yybegin(10);
                    this.cLen = 0;
                    this.yypushback(6);
                }
                case 178: {
                    continue block234;
                }
                case 85: {
                    if (this.cLen > 0) {
                        this.yypushback(this.yylength());
                        return this.flush((byte)0);
                    }
                    this.inStyle = false;
                    this.yybegin(26);
                    return this.symbol((byte)6);
                }
                case 179: {
                    continue block234;
                }
                case 86: {
                    if (this.cLen > 0) {
                        this.yypushback(this.yylength());
                        return this.flush((byte)0);
                    }
                    this.inTitle = false;
                    this.yybegin(26);
                    return this.symbol((byte)6);
                }
                case 180: {
                    continue block234;
                }
                case 87: {
                    if (this.cLen > 0) {
                        this.yypushback(this.yylength());
                        return this.flush((byte)0);
                    }
                    this.inScript = false;
                    this.yybegin(26);
                    return this.symbol((byte)6);
                }
                case 181: {
                    continue block234;
                }
                case 88: {
                    if (this.cLen > 0) {
                        this.yypushback(this.yylength());
                        return this.flush((byte)0);
                    }
                    this.inStyle = false;
                    this.yybegin(0);
                    return this.symbol((byte)6);
                }
                case 182: {
                    continue block234;
                }
                case 89: {
                    if (this.cLen > 0) {
                        this.yypushback(this.yylength());
                        return this.flush((byte)0);
                    }
                    this.inTitle = false;
                    this.yybegin(0);
                    return this.symbol((byte)6);
                }
                case 183: {
                    continue block234;
                }
                case 90: {
                    this.yybegin(38);
                    this.cLen = 9;
                }
                case 184: {
                    continue block234;
                }
                case 91: {
                    this.yybegin(4);
                    this.cLen = 0;
                    this.yypushback(9);
                }
                case 185: {
                    continue block234;
                }
                case 92: {
                    if (this.cLen > 0) {
                        this.yypushback(this.yylength());
                        return this.flush((byte)0);
                    }
                    this.inScript = false;
                    this.yybegin(0);
                    return this.symbol((byte)6);
                }
                case 186: {
                    continue block234;
                }
                case 93: {
                    if (this.cLen > 0) {
                        this.yypushback(this.yylength());
                        return this.flush((byte)0);
                    }
                    this.inTextArea = false;
                    this.yybegin(26);
                    return this.symbol((byte)6);
                }
                case 187: {
                    continue block234;
                }
                case 94: {
                    if (this.cLen > 0) {
                        this.yypushback(this.yylength());
                        return this.flush((byte)0);
                    }
                    this.inTextArea = false;
                    this.yybegin(0);
                    return this.symbol((byte)6);
                }
                case 188: {
                    continue block234;
                }
            }
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                switch (this.zzLexicalState) {
                    case 2: {
                        return this.flush((byte)1);
                    }
                    case 282: {
                        continue block234;
                    }
                    case 4: {
                        return this.flush((byte)11);
                    }
                    case 283: {
                        continue block234;
                    }
                    case 6: {
                        return this.flush((byte)8);
                    }
                    case 284: {
                        continue block234;
                    }
                    case 8: {
                        return this.flush((byte)8);
                    }
                    case 285: {
                        continue block234;
                    }
                    case 10: {
                        return this.flush((byte)16);
                    }
                    case 286: {
                        continue block234;
                    }
                    case 12: {
                        return this.flush((byte)8);
                    }
                    case 287: {
                        continue block234;
                    }
                    case 14: {
                        return this.flush((byte)8);
                    }
                    case 288: {
                        continue block234;
                    }
                    case 22: {
                        return this.flush((byte)3);
                    }
                    case 289: {
                        continue block234;
                    }
                    case 24: {
                        return this.flush((byte)4);
                    }
                    case 290: {
                        continue block234;
                    }
                    case 26: {
                        this.yybegin(28);
                    }
                    case 291: {
                        continue block234;
                    }
                    case 30: {
                        return this.flush((byte)0);
                    }
                    case 292: {
                        continue block234;
                    }
                    case 32: {
                        return this.flush((byte)0);
                    }
                    case 293: {
                        continue block234;
                    }
                    case 34: {
                        return this.flush((byte)0);
                    }
                    case 294: {
                        continue block234;
                    }
                    case 36: {
                        return this.flush((byte)0);
                    }
                    case 295: {
                        continue block234;
                    }
                    case 38: {
                        return this.flush((byte)2);
                    }
                    case 296: {
                        continue block234;
                    }
                    case 40: {
                        return this.flush((byte)2);
                    }
                    case 297: {
                        continue block234;
                    }
                    case 42: {
                        return this.flush((byte)2);
                    }
                    case 298: {
                        continue block234;
                    }
                    case 44: {
                        return this.flush((byte)12);
                    }
                    case 299: {
                        continue block234;
                    }
                    case 46: {
                        return this.flush((byte)12);
                    }
                    case 300: {
                        continue block234;
                    }
                    case 48: {
                        return this.flush((byte)12);
                    }
                    case 301: {
                        continue block234;
                    }
                    case 50: {
                        return this.flush((byte)12);
                    }
                    case 302: {
                        continue block234;
                    }
                }
                return null;
            }
            this.zzScanError(1);
        }
    }
}

