/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.tokenmarker;

import java.io.IOException;
import java.io.Reader;
import javax.swing.text.Segment;

public class SegmentReader
extends Reader {
    private int idx;
    private Segment segment;

    public SegmentReader(Segment segment) {
        this.segment = segment;
    }

    @Override
    public int read() throws IOException {
        if (this.segment == null) {
            throw new IOException("Cannot read over a closed stream.");
        }
        int rOffset = this.segment.offset + this.idx;
        int rLen = 1;
        if (this.idx + rLen > this.segment.count) {
            rLen = this.segment.count - this.idx;
        }
        int ch = -1;
        if (rLen > 0) {
            ch = this.segment.array[rOffset];
            ++this.idx;
        }
        return ch;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.segment == null) {
            throw new IOException("Cannot read over a closed stream.");
        }
        int rOffset = this.segment.offset + this.idx;
        int rLen = len;
        if (this.idx + rLen > this.segment.count) {
            rLen = this.segment.count - this.idx;
        }
        int count = -1;
        if (rLen > 0) {
            System.arraycopy(this.segment.array, rOffset, cbuf, off, rLen);
            this.idx += rLen;
            count = rLen;
        }
        return count;
    }

    @Override
    public void reset() throws IOException {
        this.idx = 0;
    }

    @Override
    public void close() throws IOException {
        this.idx = 0;
        this.segment = null;
    }
}

