/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.xml;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ro.sync.textsearch.io.TextSearchURIUtil;
import ro.sync.textsearch.util.Normalizer;
import ro.sync.textsearch.util.TextSearchEqualer;
import ro.sync.textsearch.util.TrimUtil;

public class ReviewShredder
extends DefaultHandler {
    private static final String REVIEW_ID = "__mid__";
    public static final String TIMESTAMP_FORMAT = "yyyyMMdd'T'HHmmssZ";
    private SimpleDateFormat dateFormat;
    private Pattern kvPattern;
    private static final Logger logger = LoggerFactory.getLogger((String)ReviewShredder.class.getName());
    private static final List<Document> EMPTY_DOCS = new ArrayList<Document>(0);
    private List<Document> documents;
    private List<UnderConstructionDocument> underConstructionList = new ArrayList<UnderConstructionDocument>();
    private int relativePosition;
    private Normalizer normalizer;
    private int descriptionMaxLength;

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (target.startsWith("oxy_")) {
            UnderConstructionDocument udc;
            if (this.kvPattern == null) {
                this.kvPattern = Pattern.compile("\\b(\\w*?)=\"([^\"]*?)\"");
            }
            Document doc = new Document();
            if (this.documents == null) {
                this.documents = new ArrayList<Document>();
            }
            boolean isHighlight = false;
            String mid = null;
            Matcher matcher = this.kvPattern.matcher(data);
            while (!matcher.hitEnd() && matcher.find()) {
                String unescape;
                String key = matcher.group(1);
                String value = matcher.group(2);
                if ("mid".equals(key)) {
                    mid = value;
                    doc.add((IndexableField)new StringField(REVIEW_ID, mid, Field.Store.YES));
                }
                if ("color".equals(key)) {
                    doc.add((IndexableField)new StringField("__review_highlight_color__", value, Field.Store.YES));
                }
                if ("type".equals(key) && "oxy_content_highlight".equals(value)) {
                    isHighlight = true;
                }
                if ("author".equals(key)) {
                    doc.add((IndexableField)new StringField("__review_author__", value, Field.Store.YES));
                    doc.add((IndexableField)new StringField("__review_lc_author__", value.toLowerCase(), Field.Store.YES));
                }
                if ("content".equals(key)) {
                    unescape = this.unescape(value);
                    doc.add((IndexableField)new TextField("__review_content__", unescape, Field.Store.NO));
                    doc.add((IndexableField)new StringField("__review_description_content__", this.extractDescription(unescape), Field.Store.YES));
                }
                if ("comment".equals(key)) {
                    unescape = this.unescape(value);
                    doc.add((IndexableField)new TextField("__review_content__", unescape, Field.Store.NO));
                    doc.add((IndexableField)new StringField("__review_description_comment__", this.extractDescription(unescape), Field.Store.YES));
                }
                if (!"timestamp".equals(key)) continue;
                try {
                    if (this.dateFormat == null) {
                        this.dateFormat = new SimpleDateFormat(TIMESTAMP_FORMAT);
                    }
                    Date date = this.dateFormat.parse(value);
                    doc.add((IndexableField)new LongPoint("__review_timestamp__", new long[]{date.getTime()}));
                    doc.add((IndexableField)new StoredField("__review_timestamp__", date.getTime()));
                }
                catch (ParseException e) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.warn("Unparsable date :" + value + " when using the format 'yyyyMMdd'T'HHmmssZ'", (Throwable)new Exception());
                }
            }
            if ("oxy_delete".equals(target)) {
                doc.add((IndexableField)new StringField("__review_type__", "delete", Field.Store.YES));
                doc.add((IndexableField)new IntPoint("__review_relative_position__", new int[]{this.relativePosition}));
                doc.add((IndexableField)new StoredField("__review_relative_position__", this.relativePosition));
                ++this.relativePosition;
                this.documents.add(doc);
            } else if ("oxy_custom_start".equals(target)) {
                if (isHighlight) {
                    doc.add((IndexableField)new StringField("__review_type__", "highlight", Field.Store.YES));
                    doc.add((IndexableField)new IntPoint("__review_relative_position__", new int[]{this.relativePosition}));
                    doc.add((IndexableField)new StoredField("__review_relative_position__", this.relativePosition));
                    ++this.relativePosition;
                    udc = new UnderConstructionDocument(doc);
                    this.underConstructionList.add(udc);
                }
            } else if ("oxy_custom_end".equals(target)) {
                this.endCollecting("highlight", mid);
            } else if ("oxy_comment_start".equals(target)) {
                doc.add((IndexableField)new StringField("__review_type__", "comment", Field.Store.YES));
                doc.add((IndexableField)new IntPoint("__review_relative_position__", new int[]{this.relativePosition}));
                doc.add((IndexableField)new StoredField("__review_relative_position__", this.relativePosition));
                ++this.relativePosition;
                udc = new UnderConstructionDocument(doc);
                this.underConstructionList.add(udc);
            } else if ("oxy_comment_end".equals(target)) {
                this.endCollecting("comment", mid);
            } else if ("oxy_insert_start".equals(target)) {
                doc.add((IndexableField)new StringField("__review_type__", "insert", Field.Store.YES));
                doc.add((IndexableField)new IntPoint("__review_relative_position__", new int[]{this.relativePosition}));
                doc.add((IndexableField)new StoredField("__review_relative_position__", this.relativePosition));
                ++this.relativePosition;
                udc = new UnderConstructionDocument(doc);
                this.underConstructionList.add(udc);
            } else if ("oxy_insert_end".equals(target)) {
                this.endCollecting("insert", mid);
            }
        }
    }

    public ReviewShredder(int descriptionMaxLength) {
        this.descriptionMaxLength = descriptionMaxLength;
    }

    private String extractDescription(String text) {
        if (this.normalizer == null) {
            this.normalizer = new Normalizer();
        }
        return TrimUtil.extractDescription(this.normalizer, text, this.descriptionMaxLength);
    }

    private void endCollecting(String reviewType, String mid) {
        if (this.underConstructionList != null) {
            Iterator<UnderConstructionDocument> iterator = this.underConstructionList.iterator();
            while (iterator.hasNext()) {
                UnderConstructionDocument udc = iterator.next();
                Document doc = udc.getDocument();
                if (!reviewType.equals(doc.get("__review_type__")) || !TextSearchEqualer.verifyEquals(mid, doc.get(REVIEW_ID))) continue;
                String text = udc.getText();
                doc.add((IndexableField)new StringField("__review_description_content__", this.extractDescription(text), Field.Store.YES));
                doc.add((IndexableField)new TextField("__review_content__", text, Field.Store.NO));
                doc.removeField(REVIEW_ID);
                iterator.remove();
                if (this.documents == null) {
                    this.documents = new ArrayList<Document>();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("End collecting " + TextSearchURIUtil.maskPasswords(String.valueOf(doc)));
                }
                this.documents.add(doc);
            }
        }
    }

    private String unescape(String txt) {
        txt = txt.replaceAll("&quot;", "\"");
        txt = txt.replaceAll("&apos;", "'");
        txt = txt.replaceAll("&amp;", "&");
        txt = txt.replaceAll("&lt;", "<");
        txt = txt.replaceAll("&gt;", ">");
        return txt;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.underConstructionList != null) {
            for (UnderConstructionDocument ucd : this.underConstructionList) {
                ucd.addText(ch, start, length);
            }
        }
    }

    public List<Document> getLuceneDocuments() {
        List<Document> ret = this.documents == null ? EMPTY_DOCS : this.documents;
        return ret;
    }

    private static final class UnderConstructionDocument {
        private Document doc;
        private StringBuilder buff;

        public UnderConstructionDocument(Document doc) {
            this.doc = doc;
        }

        public void addText(char[] ch, int start, int length) {
            if (this.buff == null) {
                this.buff = new StringBuilder(length);
            }
            this.buff.append(ch, start, length);
        }

        public Document getDocument() {
            return this.doc;
        }

        public String getText() {
            String txt = this.buff == null ? "" : this.buff.toString();
            return txt;
        }
    }
}

