/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.xhtml;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ro.sync.textsearch.io.TextSearchURIUtil;
import ro.sync.textsearch.xml.IShredder;

public class XHTMLLabelShredder
extends DefaultHandler
implements IShredder {
    private static final Logger logger = LoggerFactory.getLogger(XHTMLLabelShredder.class);
    private Deque<State> elementStateStack = new ArrayDeque<State>();
    private List<String> labelsCollected = new ArrayList<String>();

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (logger.isDebugEnabled()) {
            logger.debug("Starting element {} # {} {}", new Object[]{localName, TextSearchURIUtil.maskPasswords(uri), qName});
        }
        State elementState = State.NOT_WH_LABEL;
        if (State.IN_WH_LABEL == this.elementStateStack.peekLast()) {
            elementState = State.IN_WH_LABEL;
        } else {
            String classAttributeValue = atts.getValue("class");
            if ("a".equals(localName) && "wh-label".equals(classAttributeValue)) {
                elementState = State.IN_WH_LABEL;
            }
        }
        this.elementStateStack.add(elementState);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.elementStateStack.peekLast() == State.IN_WH_LABEL) {
            String label = new String(ch, start, length);
            if (!(label = label.trim()).isEmpty()) {
                this.labelsCollected.add(label);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.elementStateStack.removeLast();
    }

    public List<Field> getDocumentFields() {
        ArrayList<Field> documentFields = new ArrayList<Field>();
        for (String label : this.labelsCollected) {
            documentFields.add((Field)new StringField("label", label, Field.Store.NO));
        }
        return documentFields;
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    private static enum State {
        IN_WH_LABEL,
        NOT_WH_LABEL;

    }
}

