/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.webhelp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.spans.SpanNearQuery;
import org.apache.lucene.queries.spans.SpanQuery;
import org.apache.lucene.queries.spans.SpanTermQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopScoreDocCollectorManager;
import org.apache.lucene.search.spell.Dictionary;
import org.apache.lucene.search.spell.LuceneDictionary;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.search.suggest.analyzing.AnalyzingInfixSuggester;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.textsearch.completion.CompletionEngineUtil;
import ro.sync.textsearch.completion.CompletionOptions;
import ro.sync.textsearch.completion.CompletionWhitespaceAnalyzer;
import ro.sync.textsearch.webhelp.SearchSuggestion;

public class TitleSuggestionEngine {
    private static final int MAXIMUM_DISTANCE_BETWEEN_TOKENS_IN_QUERY = 12;
    private static final Logger logger = LoggerFactory.getLogger(TitleSuggestionEngine.class);
    private IndexSearcher searcher;
    private Analyzer searchingAnalyzer;
    private String searchFieldName;
    private List<String> stopWords;

    public TitleSuggestionEngine(String searchFieldName, IndexSearcher searcher, Analyzer searchingAnalyzer, List<String> stopWords) {
        this.searchFieldName = searchFieldName;
        this.searcher = searcher;
        this.searchingAnalyzer = searchingAnalyzer;
        this.stopWords = stopWords;
    }

    public List<SearchSuggestion> getSuggestions(String text, CompletionOptions completionOptions) throws IOException {
        ArrayList<SearchSuggestion> completions = new ArrayList<SearchSuggestion>();
        List<String> prefixTokens = this.getTokens(text, completionOptions);
        while (prefixTokens.size() >= completionOptions.getMinimumPrefixSize()) {
            logger.debug("Tokens {} - size in words: {}", prefixTokens, (Object)prefixTokens.size());
            completions.addAll(this.getSuggestions(prefixTokens, completionOptions));
            if (!completions.isEmpty()) break;
            prefixTokens.remove(0);
        }
        return completions;
    }

    private List<SearchSuggestion> getSuggestions(List<String> tokens, CompletionOptions completionOptions) throws IOException {
        ArrayList<SearchSuggestion> completions = new ArrayList<SearchSuggestion>();
        if (tokens != null) {
            List<String> tokensToSearch = this.computeBestMatchesForPartialTokens(tokens, completionOptions);
            BooleanQuery.Builder bq = new BooleanQuery.Builder();
            this.addIndividualQueries(bq, tokensToSearch, completionOptions);
            SpanQuery spanQuery = this.getSpanNearQuery(tokens, completionOptions);
            if (spanQuery != null) {
                logger.debug("Query {}", (Object)spanQuery);
                bq.add((Query)new BoostQuery((Query)spanQuery, 5.0f), BooleanClause.Occur.SHOULD);
            }
            TopDocs topDocs = (TopDocs)this.searcher.search((Query)bq.build(), (CollectorManager)new TopScoreDocCollectorManager(completionOptions.getMaximumNumberOfCompletions(), null, 0, false));
            ScoreDoc[] hits = topDocs.scoreDocs;
            logger.debug("Found {} documents.", (Object)hits.length);
            for (int i = 0; i < hits.length; ++i) {
                ScoreDoc scoreDoc = hits[i];
                int docId = scoreDoc.doc;
                Document d = this.searcher.storedFields().document(docId);
                String title = d.get("__xml_title__");
                completions.add(new SearchSuggestion(title, scoreDoc.score));
            }
        }
        return completions;
    }

    private List<String> computeBestMatchesForPartialTokens(List<String> searchTokens, CompletionOptions completionOptions) throws IOException {
        ArrayList<String> finalSearchTokens = new ArrayList<String>();
        try (AnalyzingInfixSuggester infixSuggester = new AnalyzingInfixSuggester((Directory)new ByteBuffersDirectory(), (Analyzer)new CompletionWhitespaceAnalyzer());){
            LuceneDictionary dictionary = new LuceneDictionary(this.searcher.getIndexReader(), this.searchFieldName);
            infixSuggester.build((Dictionary)dictionary);
            for (String searchToken : searchTokens) {
                List lookup = infixSuggester.lookup((CharSequence)searchToken, true, completionOptions.getMaximumNumberOfCompletions());
                for (Lookup.LookupResult lookupResult : lookup) {
                    String result = lookupResult.key.toString();
                    if (!result.equals(searchToken.trim())) {
                        List<String> tokens = CompletionEngineUtil.tokenizeString(result, this.searchingAnalyzer, this.searchFieldName, true, this.stopWords);
                        if (tokens.isEmpty()) continue;
                        finalSearchTokens.addAll(tokens);
                        continue;
                    }
                    finalSearchTokens.add(searchToken);
                }
            }
        }
        return !finalSearchTokens.isEmpty() ? finalSearchTokens : searchTokens;
    }

    private void addIndividualQueries(BooleanQuery.Builder builder, List<String> tokens, CompletionOptions completionOptions) {
        int size = tokens.size();
        if (size >= completionOptions.getMinimumPrefixSize()) {
            for (int i = 0; i < size; ++i) {
                TermQuery termQuery = new TermQuery(new Term(this.searchFieldName, tokens.get(i)));
                builder.add((Query)new BoostQuery((Query)termQuery, 1.0f), BooleanClause.Occur.SHOULD);
            }
        }
    }

    private SpanQuery getSpanNearQuery(List<String> prefixTokens, CompletionOptions completionOptions) {
        Object spanQuery = null;
        int size = prefixTokens.size();
        if (size >= completionOptions.getMinimumPrefixSize()) {
            ArrayList<SpanTermQuery> sqs = new ArrayList<SpanTermQuery>();
            for (int i = 0; i < size; ++i) {
                sqs.add(new SpanTermQuery(new Term(this.searchFieldName, prefixTokens.get(i))));
            }
            spanQuery = sqs.size() == 1 ? (SpanQuery)sqs.get(0) : new SpanNearQuery(sqs.toArray(new SpanQuery[sqs.size()]), 12, true);
        }
        return spanQuery;
    }

    public List<String> getTokens(String text, CompletionOptions completionOptions) throws IOException {
        LinkedList<String> result = new LinkedList<String>();
        if (text != null) {
            List<String> tokens = CompletionEngineUtil.tokenizeString(text, this.searchingAnalyzer, this.searchFieldName, true, this.stopWords);
            int count = 0;
            for (int i = tokens.size() - 1; i >= 0; --i) {
                String tk = tokens.get(i);
                result.addFirst(tk);
                if (count >= completionOptions.getMaximumPrefixSize()) break;
            }
        }
        return result;
    }
}

