/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.webhelp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.lucene.search.IndexSearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.textsearch.completion.Completion;
import ro.sync.textsearch.completion.CompletionExtractor;
import ro.sync.textsearch.completion.ContentReconstructor;
import ro.sync.textsearch.webhelp.KeywordsRawSuggestion;

public class KeywordsSuggestionsExtractor
extends CompletionExtractor {
    private static final Logger logger = LoggerFactory.getLogger(KeywordsSuggestionsExtractor.class);
    private String searchFieldName;
    private static final String KEYWORDS_SEPARATOR = ",";

    public KeywordsSuggestionsExtractor(String searchFieldName, IndexSearcher searcher, int maximumCompletionSize) {
        super(searcher, maximumCompletionSize);
        this.searchFieldName = searchFieldName;
    }

    @Override
    public List<Completion> getCompletionsFromDocument(int docId, List<Integer> endsOfSpans) throws IOException {
        return this.getCompletionsFromDocumentInternal(docId, endsOfSpans);
    }

    @Override
    protected List<Completion> getCompletionsFromDocumentInternal(int docId, List<Integer> tokenSpans) throws IOException {
        String documentUri = this.getURI(docId);
        logger.debug("Getting completions from {} {}", (Object)docId, (Object)documentUri);
        LinkedHashSet<KeywordsRawSuggestion> completions = new LinkedHashSet<KeywordsRawSuggestion>();
        ContentReconstructor reconstructor = new ContentReconstructor(this.searchFieldName, this.searcher);
        String[] docTokens = reconstructor.reconstructDocument(docId);
        LinkedHashSet<Integer> tokenSpansSet = new LinkedHashSet<Integer>(tokenSpans);
        if (docTokens != null) {
            for (Integer spanIndex : tokenSpansSet) {
                ArrayList<String> completionTokens = new ArrayList<String>();
                this.collectTokenFromKeywordEnd(docTokens, spanIndex, completionTokens);
                this.collectTokensFromKeywordStart(docTokens, spanIndex, completionTokens);
                completions.add(new KeywordsRawSuggestion(documentUri, completionTokens.toArray(new String[0])));
            }
        }
        return new ArrayList<Completion>(completions);
    }

    private void collectTokensFromKeywordStart(String[] docTokens, Integer spanIndex, List<String> completionTokens) {
        int completionStartIndex = 0;
        for (int i = spanIndex - 2; i >= completionStartIndex && docTokens[i] != null && !docTokens[i].trim().endsWith(KEYWORDS_SEPARATOR) && !KEYWORDS_SEPARATOR.equals(docTokens[i].trim()); --i) {
            completionTokens.add(0, docTokens[i]);
        }
    }

    private void collectTokenFromKeywordEnd(String[] docTokens, Integer spanIndex, List<String> completionTokens) {
        boolean shouldBreak = false;
        int completionEndIndex = this.getCompletionEndIndex(docTokens.length, spanIndex);
        for (int i = spanIndex - 1; i < completionEndIndex; ++i) {
            String currentToken = docTokens[i];
            if (currentToken != null && !KEYWORDS_SEPARATOR.equals(currentToken.trim())) {
                String cToken = currentToken.trim();
                boolean endsWithComma = cToken.endsWith(KEYWORDS_SEPARATOR);
                completionTokens.add(endsWithComma ? currentToken.substring(0, currentToken.indexOf(KEYWORDS_SEPARATOR)) : currentToken);
                if (endsWithComma) {
                    shouldBreak = true;
                }
            } else {
                shouldBreak = true;
            }
            if (shouldBreak) break;
        }
    }

    @Override
    protected int getCompletionEndIndex(int docSize, Integer endIndex) {
        return docSize;
    }
}

