/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.txt;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import ro.sync.basic.io.IOUtil;
import ro.sync.textsearch.DocumentCreator;
import ro.sync.textsearch.fields.StoredTextField;
import ro.sync.textsearch.fields.TextWithTermVectorsAndPositionsField;
import ro.sync.textsearch.util.Normalizer;
import ro.sync.textsearch.webhelp.converter.IContentConverter;
import ro.sync.textsearch.webhelp.embeddings.IEmbeddingProvider;

public class PlainTextDocumentCreator
implements DocumentCreator {
    private final int descLen;
    private final String encoding;
    Normalizer normalizer;
    private static final Logger logger = LoggerFactory.getLogger((String)PlainTextDocumentCreator.class.getName());

    public PlainTextDocumentCreator(String encoding, int descLen) {
        this.encoding = encoding;
        this.descLen = descLen;
        this.normalizer = new Normalizer(descLen);
    }

    @Override
    public Document[] createDocuments(InputSource source, long contentLength, List<String> tagsAndClasesToIgnore, IContentConverter contentConverter, IEmbeddingProvider embeddingsProvider, boolean generateCompletionFields) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("Creating document using encoding {}", (Object)this.encoding);
        }
        Reader reader = source.getCharacterStream();
        InputStream stream = source.getByteStream();
        Document doc = new Document();
        if (reader == null) {
            if (stream != null) {
                reader = this.encoding == null ? new InputStreamReader(stream) : new InputStreamReader(stream, this.encoding);
            } else {
                stream = new URL(source.getSystemId()).openStream();
                reader = this.encoding == null ? new InputStreamReader(stream) : new InputStreamReader(stream, this.encoding);
            }
        }
        char[] cbuf = new char[this.descLen];
        BufferedReader br = new BufferedReader(reader, cbuf.length);
        br.mark(cbuf.length);
        int r = br.read(cbuf);
        if (r > 0) {
            int l = this.normalizer.normalizeArray(cbuf, 0, r, true);
            doc.add((IndexableField)new StringField("__desc__", new String(this.normalizer.getBuffer(), 0, l), Field.Store.YES));
        }
        br.reset();
        String content = IOUtil.read((Reader)br).toString();
        doc.add((IndexableField)new StoredTextField("__text__", content));
        if (generateCompletionFields) {
            doc.add((IndexableField)new TextWithTermVectorsAndPositionsField("__completion_terms__", content));
        }
        return new Document[]{doc};
    }
}

