/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.highlighter;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.search.highlight.SimpleSpanFragmenter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.textsearch.SearchOptions;
import ro.sync.textsearch.highlighter.HTMLEncoder;
import ro.sync.textsearch.util.Normalizer;
import ro.sync.textsearch.xml.IgnorableChunksUtil;

public class HighlighterAndEncoder {
    private static final String SEPARATOR = "...";
    private static final Logger logger = LoggerFactory.getLogger((String)HighlighterAndEncoder.class.getName());
    private Analyzer searchingAnalyzer;
    private SearchOptions searchOptions;
    private Encoder htmlEncoder;
    private Normalizer normalizer;

    public HighlighterAndEncoder(Analyzer searchingAnalyzer, SearchOptions searchOptions) {
        this.searchingAnalyzer = searchingAnalyzer;
        this.searchOptions = searchOptions;
        this.htmlEncoder = new HTMLEncoder();
        this.normalizer = new Normalizer();
    }

    public List<Document> process(Query query, List<Document> docs) throws IOException, ParseException {
        Highlighter highlighter = this.createHighlighter(query);
        int i = 0;
        for (Document document : docs) {
            if (i >= this.searchOptions.getHighlightMaximumHitsNumber()) break;
            if (logger.isDebugEnabled()) {
                logger.debug("Processing {}", (Object)document.get("__uri__"));
            }
            this.processDocument(document, highlighter);
            ++i;
        }
        return docs;
    }

    private Highlighter createHighlighter(Query query) {
        SimpleHTMLFormatter formatter = new SimpleHTMLFormatter(this.searchOptions.getHighlightStartTag(), this.searchOptions.getHighlightEndTag());
        QueryScorer scorer = new QueryScorer(query);
        SimpleSpanFragmenter fragmenter = new SimpleSpanFragmenter(scorer);
        Highlighter highlighter = new Highlighter((Formatter)formatter, (Scorer)scorer);
        highlighter.setTextFragmenter((Fragmenter)fragmenter);
        highlighter.setEncoder(this.htmlEncoder);
        highlighter.setMaxDocCharsToAnalyze(this.searchOptions.getHighlightMaximumDocCharsToAnalyze());
        return highlighter;
    }

    protected void processDocument(Document document, Highlighter highlighter) throws IOException, ParseException {
        this.processField(document, highlighter, "__text__", "__result_highlight__");
        if (document.getField("__result_highlight__") == null) {
            this.processField(document, highlighter, "__review_description_comment__", "__review_description_comment_highlight__");
            this.processField(document, highlighter, "__review_description_content__", "__review_description_content_highlight__");
        }
        this.processField(document, highlighter, "__desc__", "__desc__");
        this.processField(document, highlighter, "__xml_title__", "__xml_title__");
    }

    protected void processField(Document document, Highlighter highlighter, String sourceFieldName, String destinationFieldName) throws IOException, ParseException {
        boolean appliedHighlights = false;
        IndexableField sourceField = document.getField(sourceFieldName);
        if (sourceField != null) {
            String text;
            logger.debug("Processing {}", (Object)sourceFieldName);
            if (this.searchOptions.isHighlighting() && (text = this.getHighlightedValue(highlighter, sourceField)) != null) {
                document.removeFields(destinationFieldName);
                document.add((IndexableField)new StringField(destinationFieldName, text, Field.Store.YES));
                appliedHighlights = true;
            }
        }
        IndexableField destinationField = document.getField(destinationFieldName);
        if (!appliedHighlights && destinationField != null) {
            String text = this.getHTMLEscapedValue(destinationField);
            document.removeFields(destinationFieldName);
            document.add((IndexableField)new StringField(destinationFieldName, text, Field.Store.YES));
        }
    }

    private String getHTMLEscapedValue(IndexableField sourceField) {
        return this.htmlEncoder.encodeText(this.getFilteredAndNormalizedValue(sourceField));
    }

    private String getHighlightedValue(Highlighter highlighter, IndexableField indexableField) throws IOException, ParseException {
        String hlText = null;
        try {
            String text = this.getFilteredAndNormalizedValue(indexableField);
            TokenStream stream = this.searchingAnalyzer.tokenStream(indexableField.name(), text);
            hlText = highlighter.getBestFragments(stream, text, 5, SEPARATOR);
            if (hlText.length() == 0) {
                hlText = null;
            }
        }
        catch (InvalidTokenOffsetsException e) {
            logger.warn("Cannot identify the highlighted text {}", (Object)e.getMessage());
        }
        catch (IndexSearcher.TooManyClauses e) {
            throw new ParseException(e.getLocalizedMessage());
        }
        return hlText;
    }

    private String getFilteredAndNormalizedValue(IndexableField indexableField) {
        String text = (String)indexableField.getCharSequenceValue();
        text = IgnorableChunksUtil.removeAttrsPIsAndCommentsAndNormalize(this.normalizer, text);
        return text;
    }
}

