/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.completion;

import java.util.Arrays;
import java.util.List;
import ro.sync.textsearch.completion.Completion;

public class ScoredCompletion
extends Completion {
    private float score;
    private boolean isWordCompletion;

    public ScoredCompletion(float score, List<String> tokenList) {
        this(score, tokenList.toArray(new String[tokenList.size()]));
    }

    public ScoredCompletion(float score, String[] tokens) {
        super(tokens);
        this.score = score;
    }

    public ScoredCompletion(float score, List<String> tokenList, boolean isWordCompletion) {
        this(score, tokenList.toArray(new String[tokenList.size()]));
        this.isWordCompletion = isWordCompletion;
    }

    public float getScore() {
        return this.score;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.tokens.length;
    }

    @Override
    public boolean equals(Object obj) {
        boolean eq = false;
        if (obj instanceof ScoredCompletion) {
            eq = Arrays.equals(this.tokens, ((ScoredCompletion)obj).tokens);
        }
        return eq;
    }

    @Override
    public String toString() {
        return (float)((int)(this.score * 10.0f)) / 10.0f + " " + super.toString();
    }

    public void setTokens(String[] tokens) {
        this.tokens = tokens;
    }

    public boolean isWordCompletion() {
        return this.isWordCompletion;
    }
}

