/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.analyzer;

import java.io.Reader;
import java.util.HashMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.miscellaneous.WordDelimiterGraphFilterFactory;
import ro.sync.textsearch.analyzer.OriginalStandardAnalyzer;
import ro.sync.textsearch.analyzer.OriginalStandardTokenizer;
import ro.sync.textsearch.io.NonZeroReader;

public final class HyphenAwareCompoundWordAnalyzer
extends OriginalStandardAnalyzer {
    private final boolean breakCompoundWords;

    public HyphenAwareCompoundWordAnalyzer(boolean breakCompoundWords, CharArraySet stopWords) {
        super(stopWords);
        this.breakCompoundWords = breakCompoundWords;
    }

    public HyphenAwareCompoundWordAnalyzer(boolean breakCompoundWords) {
        this.breakCompoundWords = breakCompoundWords;
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        OriginalStandardTokenizer src = new OriginalStandardTokenizer();
        src.setMaxTokenLength(this.getMaxTokenLength());
        OriginalStandardTokenizer tok = src;
        if (this.breakCompoundWords) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("preserveOriginal", "1");
            args.put("splitOnCaseChange", "0");
            WordDelimiterGraphFilterFactory wordDelimiterFilterFactory = new WordDelimiterGraphFilterFactory(args);
            tok = wordDelimiterFilterFactory.create((TokenStream)tok);
        }
        tok = new LowerCaseFilter((TokenStream)tok);
        tok = new StopFilter((TokenStream)tok, this.getStopwordSet());
        return new Analyzer.TokenStreamComponents(r -> {
            src.setMaxTokenLength(this.getMaxTokenLength());
            src.setReader(new NonZeroReader((Reader)r));
        }, (TokenStream)tok);
    }
}

