/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.charstream.CharStream;
import org.apache.lucene.queryparser.charstream.FastCharStream;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.classic.QueryParserTokenManager;
import org.apache.lucene.queryparser.classic.Token;
import org.apache.lucene.queryparser.classic.TokenMgrError;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.textsearch.FieldConstants;
import ro.sync.textsearch.SearchOptions;
import ro.sync.textsearch.scoring.FieldBoostProvider;
import ro.sync.textsearch.util.RegExpUtil;

public class SearchQueryBuilder {
    protected final Analyzer analyzer;
    protected Query query;
    private String termMatchingPattern;
    protected boolean activateWildcardScoring;
    private static String GENERIC_FIELD_NAME = "x2";
    private static final Logger logger = LoggerFactory.getLogger((String)SearchQueryBuilder.class.getName());

    public SearchQueryBuilder(Analyzer analyzer, String text, SearchOptions searchOptions, boolean activateWildcardScoring) throws ParseException, IndexSearcher.TooManyClauses {
        this.analyzer = analyzer;
        this.activateWildcardScoring = activateWildcardScoring;
        SearchOptions.SearchScope searchScope = searchOptions.getSearchScope();
        if (searchScope == SearchOptions.SearchScope.IN_PATHS) {
            this.query = this.buildInPathsQuery(text);
        } else {
            String original = text;
            text = SearchQueryBuilder.rewrite(text, searchOptions, analyzer);
            this.query = searchScope == SearchOptions.SearchScope.IN_CONTENT ? this.buildInContentQuery(original, text, searchOptions) : (searchScope == SearchOptions.SearchScope.IN_REUSABLE_COMPONENTS ? this.buildInReusablesQuery(text, original, searchOptions) : this.buildInReviewsQuery(text, searchOptions));
            this.termMatchingPattern = SearchQueryBuilder.createTermMatchingPattern(text, analyzer);
        }
    }

    public SearchQueryBuilder(Analyzer analyzer, boolean activateWildcardScoring) {
        this.analyzer = analyzer;
        this.activateWildcardScoring = activateWildcardScoring;
    }

    private static String passQueryTokenThroughAnalyzer(String token, Analyzer analyzer) {
        StringBuilder toReturn = new StringBuilder();
        boolean isStopWord = false;
        if (token.startsWith("@")) {
            toReturn.append(token);
        } else {
            ArrayList<String> result = new ArrayList<String>();
            try (TokenStream tokenStream = analyzer.tokenStream(GENERIC_FIELD_NAME, token);){
                CharTermAttribute attr = (CharTermAttribute)tokenStream.addAttribute(CharTermAttribute.class);
                tokenStream.reset();
                boolean bl = isStopWord = !tokenStream.incrementToken();
                if (!isStopWord) {
                    do {
                        int startCp;
                        String toAdd = attr.toString();
                        if (!(result.isEmpty() || toAdd.isEmpty() || Character.isIdeographic(startCp = toAdd.codePointAt(0)) || Character.isWhitespace(startCp))) {
                            result.add(" ");
                        }
                        result.add(toAdd);
                    } while (tokenStream.incrementToken());
                }
                tokenStream.end();
            }
            catch (IOException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug(e.getMessage(), (Throwable)e);
                }
                return token;
            }
            if (isStopWord) {
                toReturn.append(token);
            } else {
                for (String tokenResult : result) {
                    toReturn.append(tokenResult);
                }
            }
        }
        return toReturn.toString();
    }

    private Query buildInReusablesQuery(String text, String original, SearchOptions searchOptions) throws ParseException {
        Object resourceFilter;
        List<String> elementTypeFilters;
        QueryParser parser = new QueryParser("__text__", this.analyzer);
        if (this.activateWildcardScoring) {
            parser.setMultiTermRewriteMethod(MultiTermQuery.SCORING_BOOLEAN_REWRITE);
        }
        Query q = null;
        if (text.trim().length() > 0) {
            q = parser.parse(text);
        }
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        bq.add((Query)new TermQuery(new Term("__reusable__", "true")), BooleanClause.Occur.MUST);
        if (q != null) {
            BooleanQuery.Builder idq;
            block12: {
                idq = new BooleanQuery.Builder();
                QueryParser pathParser = new QueryParser("__reusable_path__", this.analyzer);
                if (this.activateWildcardScoring) {
                    pathParser.setMultiTermRewriteMethod(MultiTermQuery.SCORING_BOOLEAN_REWRITE);
                }
                idq.add(pathParser.parse(text), BooleanClause.Occur.SHOULD);
                idq.add(q, BooleanClause.Occur.SHOULD);
                try {
                    Query descrQuery = SearchQueryBuilder.buildQueryForDescriptionField(original);
                    idq.add(descrQuery, BooleanClause.Occur.SHOULD);
                }
                catch (ParseException ex) {
                    if (!logger.isDebugEnabled()) break block12;
                    logger.debug(ex.getMessage(), (Throwable)ex);
                }
            }
            idq.setMinimumNumberShouldMatch(1);
            bq.add((Query)idq.build(), BooleanClause.Occur.MUST);
        }
        if ((elementTypeFilters = searchOptions.getElementTypeFilter()) != null && !elementTypeFilters.isEmpty()) {
            BooleanQuery.Builder elementTypeQuery = new BooleanQuery.Builder();
            elementTypeQuery.setMinimumNumberShouldMatch(1);
            boolean isValid = false;
            for (String string : elementTypeFilters) {
                if (string.length() <= 0) continue;
                String string2 = "*" + string + "*";
                elementTypeQuery.add((Query)new WildcardQuery(new Term("__reusable_class__", string2)), BooleanClause.Occur.SHOULD);
                isValid = true;
            }
            if (isValid) {
                bq.add((Query)elementTypeQuery.build(), BooleanClause.Occur.MUST);
            }
        }
        if ((resourceFilter = searchOptions.getResourceURLFilter()) != null && ((String)resourceFilter).trim().length() > 0) {
            if (!((String)(resourceFilter = ((String)resourceFilter).toLowerCase())).startsWith("*")) {
                resourceFilter = "*" + (String)resourceFilter;
            }
            if (!((String)resourceFilter).endsWith("*")) {
                resourceFilter = (String)resourceFilter + "*";
            }
            bq.add((Query)new WildcardQuery(new Term("__lc_uri__", (String)resourceFilter)), BooleanClause.Occur.MUST);
        }
        return bq.build();
    }

    static Query buildQueryForDescriptionField(String queryText) throws ParseException {
        Query toReturn = null;
        try {
            QueryParserTokenManager tm = new QueryParserTokenManager((CharStream)new FastCharStream((Reader)new StringReader(queryText)));
            Token nt = tm.getNextToken();
            int boost = 1000;
            if (nt.kind == 19) {
                QueryParser parserDesc = new QueryParser("__reusable_description__", (Analyzer)new KeywordAnalyzer());
                toReturn = parserDesc.parse(nt.image);
                toReturn = new BoostQuery(toReturn, (float)boost);
            } else if (nt.kind == 20) {
                BooleanQuery.Builder b = new BooleanQuery.Builder();
                b.setMinimumNumberShouldMatch(1);
                QueryParser parserDesc = new QueryParser("__reusable_description__", (Analyzer)new KeywordAnalyzer());
                Query q = parserDesc.parse(nt.image);
                b.add((Query)new BoostQuery(q, (float)boost), BooleanClause.Occur.SHOULD);
                RegexpQuery rq = new RegexpQuery(new Term("__reusable_description__", nt.image + "[^\\s]*"));
                b.add((Query)new BoostQuery((Query)rq, (float)boost / 2.0f), BooleanClause.Occur.SHOULD);
                toReturn = b.build();
            } else {
                throw new ParseException("Expression not suited for searching into the description.");
            }
            Token nextToken = tm.getNextToken();
            if (nextToken != null && nextToken.kind != 0) {
                throw new ParseException("Expression not suited for searching into the description.");
            }
        }
        catch (TokenMgrError error) {
            throw new ParseException(error.getMessage());
        }
        return toReturn;
    }

    public Query getQuery() {
        return this.query;
    }

    public String getTermMatchingPattern() {
        return this.termMatchingPattern;
    }

    private Query buildInContentQuery(String original, String text, SearchOptions searchOptions) throws ParseException {
        Query q = this.buildInContentQueryOverMultipleFields(original, text, searchOptions);
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        bq.add(q, BooleanClause.Occur.MUST);
        bq.add((Query)new WildcardQuery(new Term("__reusable__", "*")), BooleanClause.Occur.MUST_NOT);
        if (logger.isDebugEnabled()) {
            logger.debug("Searching in contents: {}", q.getClass());
        }
        return bq.build();
    }

    protected Query buildInContentQueryOverMultipleFields(String original, String text, SearchOptions searchOptions) throws ParseException {
        Map<String, Float> fieldsAndBoosts = searchOptions.isApplyAdvancedScoring() ? FieldBoostProvider.getAdvancedScoringMap() : FieldBoostProvider.getDefaultScoringMap();
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        for (Map.Entry<String, Float> fieldEntry : fieldsAndBoosts.entrySet()) {
            String field = fieldEntry.getKey();
            Float boost = fieldEntry.getValue();
            QueryParser parser = new QueryParser(field, this.analyzer);
            if (this.activateWildcardScoring) {
                parser.setMultiTermRewriteMethod(MultiTermQuery.SCORING_BOOLEAN_REWRITE);
            }
            BoostQuery boosted = new BoostQuery(parser.parse(text), boost.floatValue());
            bq.add((Query)boosted, BooleanClause.Occur.SHOULD);
        }
        return bq.build();
    }

    private Query buildInPathsQuery(String text) throws ParseException {
        String fieldName = "__lc_file_name__";
        if (((String)text).startsWith("/")) {
            text = "file:" + (String)text;
        }
        if (Pattern.matches("[A-Z]:\\\\(.*?)", (CharSequence)text)) {
            text = "file:/" + (String)text;
        }
        if (File.separatorChar == '\\' && ((String)text).indexOf(92) != -1) {
            text = ((String)text).replace('\\', '/');
        }
        text = (String)text + "*";
        String regex = RegExpUtil.convertWildcardToRegexp((String)text, true);
        if (((String)text).indexOf(47) != -1) {
            fieldName = "__lc_uri__";
            regex = regex.replace("/", "\\/");
        }
        regex = regex.toLowerCase();
        BooleanQuery.Builder q = new BooleanQuery.Builder();
        try {
            q.add((Query)new RegexpQuery(new Term(fieldName, regex)), BooleanClause.Occur.MUST);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException(e.getLocalizedMessage());
        }
        q.add((Query)new TermQuery(new Term("__review_type__", "<NULL>")), BooleanClause.Occur.MUST);
        q.add((Query)new WildcardQuery(new Term("__reusable__", "*")), BooleanClause.Occur.MUST_NOT);
        logger.debug("Built the query for in-paths search");
        return q.build();
    }

    private Query buildInReviewsQuery(String text, SearchOptions searchOptions) throws ParseException {
        long reviewTime;
        String authorName;
        SearchOptions.ReviewType reviewType = searchOptions.getReviewType();
        QueryParser parser = new QueryParser("__review_content__", this.analyzer);
        if (this.activateWildcardScoring) {
            parser.setMultiTermRewriteMethod(MultiTermQuery.SCORING_BOOLEAN_REWRITE);
        }
        Query q = null;
        q = text.trim().length() == 0 ? parser.parse("/.*/") : parser.parse(text);
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        if (q != null) {
            bq.add(q, BooleanClause.Occur.MUST);
        }
        if ((authorName = searchOptions.getReviewAuthorName()) != null) {
            bq.add((Query)new TermQuery(new Term("__review_lc_author__", authorName.toLowerCase())), BooleanClause.Occur.MUST);
        }
        if ((reviewTime = searchOptions.getReviewsRecentThan()) != -1L) {
            bq.add(LongPoint.newRangeQuery((String)"__review_timestamp__", (long)reviewTime, (long)Long.MAX_VALUE), BooleanClause.Occur.MUST);
        }
        if (reviewType != null) {
            switch (reviewType) {
                case INSERT: {
                    bq.add((Query)new TermQuery(new Term("__review_type__", "insert")), BooleanClause.Occur.MUST);
                    break;
                }
                case DELETE: {
                    bq.add((Query)new TermQuery(new Term("__review_type__", "delete")), BooleanClause.Occur.MUST);
                    break;
                }
                case INSERT_OR_DELETE: {
                    BooleanQuery.Builder idq = new BooleanQuery.Builder();
                    idq.add((Query)new TermQuery(new Term("__review_type__", "insert")), BooleanClause.Occur.SHOULD);
                    idq.add((Query)new TermQuery(new Term("__review_type__", "delete")), BooleanClause.Occur.SHOULD);
                    idq.setMinimumNumberShouldMatch(1);
                    bq.add((Query)idq.build(), BooleanClause.Occur.MUST);
                    break;
                }
                case COMMENT: {
                    bq.add((Query)new TermQuery(new Term("__review_type__", "comment")), BooleanClause.Occur.MUST);
                    break;
                }
                case HIGHLIGHT: {
                    bq.add((Query)new TermQuery(new Term("__review_type__", "highlight")), BooleanClause.Occur.MUST);
                    break;
                }
            }
        }
        return bq.build();
    }

    static String createTermMatchingPattern(String text, Analyzer analyzer) throws ParseException {
        StringBuilder regexp = new StringBuilder();
        boolean isSimple = true;
        ArrayList<String> proximityQuery = null;
        try {
            ArrayList<String> subRegexps = new ArrayList<String>();
            QueryParserTokenManager tm = new QueryParserTokenManager((CharStream)new FastCharStream((Reader)new StringReader(text)));
            Token token = tm.getNextToken();
            while (token.kind != 0) {
                String tokenImage = token.image;
                Token nextToken = tm.getNextToken();
                switch (token.kind) {
                    case 20: 
                    case 22: 
                    case 23: {
                        if (nextToken.kind != 16 && !SearchQueryBuilder.isStopWord(tokenImage, analyzer)) {
                            subRegexps.add(RegExpUtil.convertWildcardToRegexp(tokenImage, false));
                            break;
                        }
                        if (!tokenImage.startsWith("@")) break;
                        isSimple = false;
                        break;
                    }
                    case 19: {
                        if (nextToken.kind == 21 && Pattern.compile("~\\d+").matcher(nextToken.image).matches()) {
                            if (proximityQuery == null) {
                                proximityQuery = new ArrayList<String>();
                            }
                            proximityQuery.add(tokenImage);
                            break;
                        }
                    }
                    case 24: {
                        subRegexps.add(tokenImage.substring(1, tokenImage.length() - 1));
                        break;
                    }
                }
                token = nextToken;
            }
            Iterator iterator = subRegexps.iterator();
            while (iterator.hasNext()) {
                String re = (String)iterator.next();
                regexp.append(re);
                if (!iterator.hasNext()) continue;
                regexp.append("|");
            }
            String startWord = "(?<=\\b|_)";
            String endWord = "(?=\\b|_)";
            if (!subRegexps.isEmpty()) {
                regexp.insert(0, startWord + "(");
                regexp.append(")").append(endWord);
            }
            if (proximityQuery != null) {
                for (String string : proximityQuery) {
                    String unquoted = string.substring(1, string.length() - 1);
                    StringTokenizer t = new StringTokenizer(unquoted, " ");
                    if (regexp.length() > 0) {
                        regexp.append("|");
                    }
                    regexp.append("(");
                    while (t.hasMoreTokens()) {
                        String nt = t.nextToken().trim();
                        if (nt.length() <= 0 || SearchQueryBuilder.isStopWord(nt, analyzer)) continue;
                        regexp.append(startWord).append(RegExpUtil.convertWildcardToRegexp(nt, false)).append(endWord);
                        if (!t.hasMoreTokens()) continue;
                        regexp.append(".*?");
                    }
                    regexp.append(")");
                }
            }
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ParseException(ex.getMessage());
        }
        catch (TokenMgrError error) {
            throw new ParseException(error.getMessage());
        }
        String ret = null;
        if (isSimple && (ret = regexp.toString()).trim().length() == 0) {
            ret = null;
        }
        return ret;
    }

    static String rewrite(String text, SearchOptions searchOptions, Analyzer analyzer) throws ParseException {
        String ret = text;
        try {
            StringBuilder buf = new StringBuilder();
            boolean isSimple = true;
            String fieldName = null;
            QueryParserTokenManager tm = new QueryParserTokenManager((CharStream)new FastCharStream((Reader)new StringReader(text)));
            Token nt = tm.getNextToken();
            while (nt.kind != 0) {
                String token = nt.image;
                if (nt.kind != 16 && nt.kind != 20) {
                    fieldName = null;
                }
                switch (nt.kind) {
                    case 23: {
                        if (token.startsWith("*") || token.startsWith("?")) {
                            buf.append('/');
                            buf.append(RegExpUtil.convertWildcardToRegexp(token, false));
                            buf.append('/');
                            break;
                        }
                        buf.append(token);
                        break;
                    }
                    case 20: {
                        boolean passTermThroughAnalyzer;
                        boolean bl = passTermThroughAnalyzer = fieldName == null || !FieldConstants.NON_TOKENIZABLE_FIELDS_LIST.contains(fieldName);
                        if (passTermThroughAnalyzer) {
                            buf.append(SearchQueryBuilder.passQueryTokenThroughAnalyzer(token, analyzer));
                        } else {
                            buf.append(token);
                        }
                        if (fieldName != null) {
                            fieldName = null;
                            break;
                        }
                        fieldName = token;
                        break;
                    }
                    case 16: 
                    case 19: 
                    case 22: 
                    case 24: {
                        buf.append(token);
                        break;
                    }
                    default: {
                        isSimple = false;
                        buf.append(nt.image);
                    }
                }
                boolean addSpace = true;
                boolean addStar = false;
                if (nt.kind == 18) {
                    addSpace = false;
                }
                if (!(searchOptions.isExactSearch() || nt.kind != 20 || SearchQueryBuilder.isStopWord(nt.image, analyzer) || SearchQueryBuilder.containsIdeographicChars(nt.image))) {
                    addStar = true;
                }
                nt = tm.getNextToken();
                if (nt.kind == 16) {
                    addStar = false;
                    addSpace = false;
                }
                if (nt.kind == 18 || nt.kind == 21) {
                    addSpace = false;
                }
                if (addStar) {
                    buf.append('*');
                }
                if (!addSpace) continue;
                buf.append(' ');
            }
            ret = isSimple ? SearchQueryBuilder.rewriteWithAndAndWildcard(buf.toString(), searchOptions, analyzer) : buf.toString();
        }
        catch (TokenMgrError error) {
            throw new ParseException(error.getMessage());
        }
        return ret;
    }

    static String rewriteWithAndAndWildcard(String text, SearchOptions searchOptions, Analyzer analyzer) throws ParseException {
        SearchOptions.DefaultJoinOperator joinOperator = searchOptions.getDefaultJoinOperator();
        boolean exactSearch = searchOptions.isExactSearch();
        StringBuilder builder = new StringBuilder();
        try {
            QueryParserTokenManager tm = new QueryParserTokenManager((CharStream)new FastCharStream((Reader)new StringReader(text)));
            Token token = tm.getNextToken();
            while (token.kind != 0) {
                boolean beforeColon = false;
                Token nextToken = tm.getNextToken();
                if (nextToken != null) {
                    beforeColon = nextToken.kind == 16;
                }
                String tokenImage = token.image;
                switch (token.kind) {
                    case 20: {
                        builder.append(tokenImage);
                        if (exactSearch || beforeColon || SearchQueryBuilder.isStopWord(tokenImage, analyzer) || SearchQueryBuilder.containsIdeographicChars(tokenImage)) break;
                        builder.append('*');
                        break;
                    }
                    case 16: 
                    case 19: 
                    case 22: 
                    case 23: 
                    case 24: {
                        builder.append(tokenImage);
                        break;
                    }
                    default: {
                        logger.error("Unexpected token {} kind {} in simple expression", (Object)tokenImage, (Object)token.kind);
                    }
                }
                if (token.kind != 16 && nextToken != null && (nextToken.kind == 20 || nextToken.kind == 23 || nextToken.kind == 22 || nextToken.kind == 24)) {
                    if (joinOperator == SearchOptions.DefaultJoinOperator.AND) {
                        builder.append(" AND ");
                    } else {
                        builder.append(" OR ");
                    }
                }
                token = nextToken;
            }
        }
        catch (TokenMgrError error) {
            throw new ParseException(error.getMessage());
        }
        return builder.toString();
    }

    private static boolean containsIdeographicChars(String tokenImage) {
        int len = tokenImage.length();
        for (int i = 0; i < len; ++i) {
            if (!Character.isIdeographic(tokenImage.charAt(i))) continue;
            return true;
        }
        return false;
    }

    static boolean isStopWord(String tokenText, Analyzer analyzer) throws ParseException {
        boolean isStopWord = false;
        try {
            TokenStream tokenStream = analyzer.tokenStream(GENERIC_FIELD_NAME, (Reader)new StringReader(tokenText));
            tokenStream.reset();
            isStopWord = !tokenStream.incrementToken();
            tokenStream.close();
        }
        catch (IOException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            throw new ParseException("Could not determine if token is a stop word");
        }
        return isStopWord;
    }
}

