/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;
import ro.sync.textsearch.IndexingOptions;
import ro.sync.textsearch.io.TextSearchIOUtil;
import ro.sync.textsearch.io.TextSearchURIUtil;
import ro.sync.textsearch.props.ResourceProperties;

public class ResourceInfo {
    private static final Logger logger = LoggerFactory.getLogger((String)ResourceInfo.class.getName());
    private URI uri;
    private URI uriNoUI;
    private String uriStr;
    private String uriStrNoUI;
    private long lastModified;
    private long contentLength;
    private boolean isHidden;
    private boolean isLocalFile;
    private boolean shouldIndexContent;
    private URL url;

    public URI getUri() {
        return this.uri;
    }

    public URI getUriNoUI() {
        return this.uriNoUI;
    }

    public String getUriStr() {
        return this.uriStr;
    }

    public String getUriStrNoUI() {
        return this.uriStrNoUI;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public boolean isLocalFile() {
        return this.isLocalFile;
    }

    public ResourceInfo(URLConnection connection, IndexingOptions options, ResourceProperties props) throws URISyntaxException {
        this.url = connection.getURL();
        this.uri = this.url.toURI();
        this.uriStr = this.uri.toString();
        if (this.uri.getRawUserInfo() != null) {
            this.uriNoUI = TextSearchURIUtil.removeUserAndPassword(this.uri);
            this.uriStrNoUI = this.uriNoUI.toString();
        } else {
            this.uriNoUI = this.uri;
            this.uriStrNoUI = this.uriStr;
        }
        this.isLocalFile = "file".equals(this.uri.getScheme());
        if (this.isLocalFile && (this.uriNoUI.getFragment() != null || this.uriNoUI.getQuery() != null)) {
            this.uriNoUI = new URI(URLUtil.removeQueryOrAnchorFromName((String)this.uriNoUI.toString()));
            this.uriStrNoUI = this.uriNoUI.toString();
        }
        if (this.isLocalFile) {
            this.isHidden = TextSearchIOUtil.fileFromURI(this.uri).isHidden();
        }
        boolean isIndexingContent = ResourceInfo.isIndexingContent(options, props);
        boolean isIndexingRemoteContent = ResourceInfo.isIndexingRemoteContent(options, props);
        if (this.isLocalFile || isIndexingContent && isIndexingRemoteContent) {
            this.lastModified = this.getLastModified(this.url, this.uri, connection);
            this.contentLength = this.getContentLength(this.url, this.uri, connection);
        }
        this.shouldIndexContent = isIndexingContent;
        if (this.shouldIndexContent && !this.isLocalFile) {
            this.shouldIndexContent = isIndexingRemoteContent;
        }
    }

    private static boolean isIndexingContent(IndexingOptions options, ResourceProperties props) {
        return options.isIndexingContent() || props != null && props.isReusableTopic();
    }

    private static boolean isIndexingRemoteContent(IndexingOptions options, ResourceProperties urlProps) {
        return options.isIndexingRemoteContent() || urlProps != null && urlProps.isReusableTopic();
    }

    public boolean shouldIndexContent() {
        return this.shouldIndexContent;
    }

    private final long getLastModified(URL url, URI uri, URLConnection connection) {
        long lm = "file".equals(url.getProtocol()) ? TextSearchIOUtil.fileFromURI(uri).lastModified() : connection.getLastModified();
        logger.debug("Last modified for {}" + TextSearchURIUtil.maskPasswords(String.valueOf(url)) + " is " + lm);
        return lm;
    }

    private long getContentLength(URL url, URI uri, URLConnection connection) {
        long cl = "file".equals(url.getProtocol()) ? TextSearchIOUtil.fileFromURI(uri).length() : (long)connection.getContentLength();
        if (logger.isDebugEnabled()) {
            logger.debug("Content length for " + TextSearchURIUtil.maskPasswords(String.valueOf(url)) + " is " + cl);
        }
        return cl;
    }

    public boolean shouldIndex() {
        return !this.isHidden && this.contentLength < Integer.MAX_VALUE;
    }

    void setContentLength(long contentLength) {
        this.contentLength = contentLength;
    }

    public URL getUrl() {
        return this.url;
    }
}

