/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.textsearch.IndexingOptions;
import ro.sync.textsearch.io.TextSearchIOUtil;
import ro.sync.textsearch.io.TextSearchURIUtil;

public class Compatibility {
    public static final int COMPATIBILITY_VERSION = 20;
    private static final String COMPATIBILITY_FILE_NAME = "_COMPATIBILITY_";
    private final File index;
    private int version;
    private static final Logger logger = LoggerFactory.getLogger((String)Compatibility.class.getName());

    public Compatibility(File index) {
        this(index, 20);
    }

    Compatibility(File index, int version) {
        this.index = index;
        this.version = version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCompatible(IndexingOptions indexingOptions) throws IOException {
        boolean compatible = true;
        if (this.index.exists()) {
            File cptf = new File(this.index, COMPATIBILITY_FILE_NAME);
            ObjectInputStream ois = null;
            FileInputStream in = null;
            try {
                in = new FileInputStream(cptf);
                ois = new ObjectInputStream(in);
                compatible = this.version == ois.readInt() && indexingOptions.equals(ois.readObject());
            }
            catch (FileNotFoundException | ClassNotFoundException ex) {
                compatible = false;
            }
            finally {
                if (ois != null) {
                    ois.close();
                } else if (in != null) {
                    in.close();
                }
            }
        }
        return compatible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeCompatibilityMarker(IndexingOptions indexingOptions) throws IOException {
        if (!this.index.exists() && !this.index.mkdirs()) {
            throw new IOException("Cannot create the index compatibility file in: " + this.index);
        }
        File cptf = new File(this.index, COMPATIBILITY_FILE_NAME);
        if (this.index.exists()) {
            ObjectOutputStream dos = null;
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(cptf);
                dos = new ObjectOutputStream(out);
                dos.writeInt(this.version);
                dos.writeObject(indexingOptions);
            }
            finally {
                if (dos != null) {
                    dos.close();
                } else if (out != null) {
                    out.close();
                }
            }
        }
    }

    void handleUpgrade() throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("Removing incompatible index: " + TextSearchURIUtil.maskPasswords(String.valueOf(this.index)));
        }
        TextSearchIOUtil.deleteDir(this.index);
    }

    public String getCompatibilityFileName() {
        return COMPATIBILITY_FILE_NAME;
    }

    public void handleCompatibility(IndexingOptions indexingOptions) throws IOException {
        if (this.index.exists()) {
            boolean compatible = false;
            try {
                compatible = this.isCompatible(indexingOptions);
            }
            catch (IOException ex) {
                logger.warn("Could not check the compatibility with the index directory: " + this.index, (Throwable)ex);
                logger.warn("Continuing assuming the index is not compatible.");
            }
            if (!compatible) {
                this.handleUpgrade();
                this.writeCompatibilityMarker(indexingOptions);
            }
        } else {
            if (!this.index.mkdirs()) {
                throw new IOException("Could not create index directory: " + this.index);
            }
            this.writeCompatibilityMarker(indexingOptions);
        }
    }
}

