/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.sql;

import com.saxonica.functions.sql.SQLFunctionSet;
import com.saxonica.functions.sql.SQLTable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;

public class SQLTableFn
extends SystemFunction {
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        Connection connection = SQLFunctionSet.expectConnection(arguments[0], context);
        String tableName = arguments[1].head().getStringValue();
        try {
            DatabaseMetaData dbm = connection.getMetaData();
            ResultSet rs = dbm.getTables(null, null, tableName, null);
            if (!rs.next()) {
                throw new XPathException("sql:table() failed: table " + tableName + " does not exist", "SXSQ0004", context);
            }
            return new SQLTable(connection, tableName, context);
        }
        catch (SQLException ex) {
            throw new XPathException("sql:query() failed: " + ex.getMessage(), "SXSQ0004", context);
        }
    }
}

