/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner.conditional;

import java.util.List;
import org.htmlcleaner.BaseToken;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.conditional.ITagNodeCondition;

public class TagNodeInsignificantBrCondition
implements ITagNodeCondition {
    private static final String BR_TAG = "br";

    @Override
    public boolean satisfy(TagNode tagNode) {
        if (!this.isBrNode(tagNode)) {
            return false;
        }
        TagNode parent = tagNode.getParent();
        List<? extends BaseToken> children = parent.getAllChildren();
        int brIndex = children.indexOf(tagNode);
        return this.checkSublist(0, brIndex, children) || this.checkSublist(brIndex, children.size(), children);
    }

    private boolean isBrNode(TagNode tagNode) {
        return tagNode != null && BR_TAG.equals(tagNode.getName());
    }

    private boolean checkSublist(int start, int end, List list) {
        List sublist = list.subList(start, end);
        for (Object object : sublist) {
            if (!(object instanceof TagNode)) {
                return false;
            }
            TagNode node = (TagNode)object;
            if (this.isBrNode(node) || node.isPruned()) continue;
            return false;
        }
        return true;
    }
}

