/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.yaml.util;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;

public class YAMLUtil {
    public static final int CODE_POINT_LIMIT = 524288000;

    private YAMLUtil() {
    }

    public static Node getYamlNodeFromJsonPointer(String jsonPointer, Node rootNode) {
        String pointer = jsonPointer.substring(jsonPointer.startsWith("#/") ? 2 : 0, jsonPointer.length());
        ArrayList<String> pointerKeys = new ArrayList<String>(Arrays.asList(pointer.split("/")));
        return YAMLUtil.findNode(rootNode, pointerKeys);
    }

    public static List<Node> getYamlRootNodesFromDocument(Reader yamlReader) {
        Iterable yamlTrees = YAMLUtil.createDefaultYamlParser().composeAll(yamlReader);
        return StreamSupport.stream(yamlTrees.spliterator(), false).collect(Collectors.toList());
    }

    private static Node findNode(Node root, List<String> pointerKeys) {
        if (root instanceof MappingNode) {
            return YAMLUtil.findNode((MappingNode)root, pointerKeys);
        }
        if (root instanceof SequenceNode) {
            return YAMLUtil.findNode((SequenceNode)root, pointerKeys);
        }
        return root;
    }

    private static Node findNode(MappingNode root, List<String> pointerKeys) {
        if (pointerKeys.isEmpty()) {
            return root;
        }
        String currentKey = pointerKeys.remove(0);
        for (NodeTuple childNode : root.getValue()) {
            ScalarNode keyNode;
            if (!(childNode.getKeyNode() instanceof ScalarNode) || !(keyNode = (ScalarNode)childNode.getKeyNode()).getValue().equals(currentKey)) continue;
            Node valueNode = childNode.getValueNode();
            return YAMLUtil.findNode((Node)(valueNode instanceof ScalarNode || pointerKeys.isEmpty() ? keyNode : valueNode), pointerKeys);
        }
        return root;
    }

    private static Node findNode(SequenceNode root, List<String> pointerKeys) {
        if (pointerKeys.isEmpty()) {
            return root;
        }
        String currentKey = pointerKeys.remove(0);
        try {
            Node arrayNode = (Node)root.getValue().get(NumberParserUtil.parseInt((String)currentKey));
            return YAMLUtil.findNode(arrayNode, pointerKeys);
        }
        catch (NumberFormatException e) {
            return root;
        }
    }

    public static String detectAssociatedSchema(Reader reader) {
        String detectedSchema = null;
        Iterator events = YAMLUtil.createDefaultYamlParser().parse(reader).iterator();
        while (events.hasNext()) {
            String scalarValue;
            Event event = (Event)events.next();
            if (!event.is(Event.ID.MappingStart) || !events.hasNext()) continue;
            event = (Event)events.next();
            if (!event.is(Event.ID.Scalar) || !"$schema".equals(scalarValue = ((ScalarEvent)event).getValue()) || !events.hasNext() || !(event = (Event)events.next()).is(Event.ID.Scalar)) break;
            detectedSchema = ((ScalarEvent)event).getValue();
            break;
        }
        return detectedSchema;
    }

    public static Yaml createDefaultYamlParser() {
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setAllowDuplicateKeys(false);
        loaderOptions.setAllowRecursiveKeys(true);
        loaderOptions.setCodePointLimit(524288000);
        return new Yaml(loaderOptions);
    }
}

