/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.syntaxhighlight.marker;

import com.google.common.collect.ImmutableMap;
import com.oxygenxml.tokenmarker.LexerTokenMarker;
import com.oxygenxml.tokenmarker.ant.AntLexerTokenMarker;
import com.oxygenxml.tokenmarker.batch.BatchLexerTokenMarker;
import com.oxygenxml.tokenmarker.c.CLexerTokenMarker;
import com.oxygenxml.tokenmarker.cpp.CPPLexerTokenMarker;
import com.oxygenxml.tokenmarker.css.CSSLexerTokenMarker;
import com.oxygenxml.tokenmarker.dockerfile.DockerfileLexerTokenMarker;
import com.oxygenxml.tokenmarker.dtd.DTDLexerTokenMarker;
import com.oxygenxml.tokenmarker.java.JavaLexerTokenMarker;
import com.oxygenxml.tokenmarker.js.JSLexerTokenMarker;
import com.oxygenxml.tokenmarker.json.JSON5LexerTokenMarker;
import com.oxygenxml.tokenmarker.json.JSONLexerTokenMarker;
import com.oxygenxml.tokenmarker.json.JSONSchemaLexerTokenMarker;
import com.oxygenxml.tokenmarker.less.LESSLexerTokenMarker;
import com.oxygenxml.tokenmarker.md.MDLexerTokenMarker;
import com.oxygenxml.tokenmarker.perl.PerlLexerTokenMarker;
import com.oxygenxml.tokenmarker.powershell.PowerShellLexerTokenMarker;
import com.oxygenxml.tokenmarker.properties.PropertiesLexerTokenMarker;
import com.oxygenxml.tokenmarker.python.PythonLexerTokenMarker;
import com.oxygenxml.tokenmarker.rnc.RNCLexerTokenMarker;
import com.oxygenxml.tokenmarker.schematron.SchematronLexerTokenMarker;
import com.oxygenxml.tokenmarker.shell.ShellLexerTokenMarker;
import com.oxygenxml.tokenmarker.sql.SQLLexerTokenMarker;
import com.oxygenxml.tokenmarker.text.TextLexerTokenMarker;
import com.oxygenxml.tokenmarker.xhtml.HTMLLexerTokenMarker;
import com.oxygenxml.tokenmarker.xhtml.PHPXMLLexerTokenMarker;
import com.oxygenxml.tokenmarker.xhtml.XHTMLLexerTokenMarker;
import com.oxygenxml.tokenmarker.xml.XMLLexerTokenMarker;
import com.oxygenxml.tokenmarker.xproc.XProcLexerTokenMarker;
import com.oxygenxml.tokenmarker.xqueryxpath.XQueryXPathLexerTokenMarker;
import com.oxygenxml.tokenmarker.xsd.XSDLexerTokenMarker;
import com.oxygenxml.tokenmarker.xsl.XSLLexerTokenMarker;
import com.oxygenxml.tokenmarker.xspec.XSPECLexerTokenMarker;
import com.oxygenxml.tokenmarker.yaml.YAMLLexerTokenMarker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.exml.options.Options;
import ro.sync.syntaxhighlight.marker.TokenMarker;

@API(type=APIType.NOT_EXTENDABLE, src=SourceType.PRIVATE)
public final class TokenMarkerFactory {
    private static final Logger c = LoggerFactory.getLogger((String)TokenMarkerFactory.class.getName());
    private static final ImmutableMap<String, Class> b = ImmutableMap.builder().put((Object)"text/xml", XMLLexerTokenMarker.class).put((Object)"text/ant", AntLexerTokenMarker.class).put((Object)"text/wsdl", XMLLexerTokenMarker.class).put((Object)"text/sch", SchematronLexerTokenMarker.class).put((Object)"text/nvdl", XMLLexerTokenMarker.class).put((Object)"text/xproc", XProcLexerTokenMarker.class).put((Object)"text/rng", XMLLexerTokenMarker.class).put((Object)"text/html", HTMLLexerTokenMarker.class).put((Object)"application/xhtml+xml", XHTMLLexerTokenMarker.class).put((Object)"text/xsl", XSLLexerTokenMarker.class).put((Object)"text/xspec", XSPECLexerTokenMarker.class).put((Object)"text/exf", XMLLexerTokenMarker.class).put((Object)"text/xsd", XSDLexerTokenMarker.class).put((Object)"text/dockerfile", DockerfileLexerTokenMarker.class).put((Object)"text/dtd", DTDLexerTokenMarker.class).put((Object)"text/rnc", RNCLexerTokenMarker.class).put((Object)"text/plain", TextLexerTokenMarker.class).put((Object)"text/java", JavaLexerTokenMarker.class).put((Object)"text/javascript", JSLexerTokenMarker.class).put((Object)"text/json", JSONLexerTokenMarker.class).put((Object)"text/json5", JSON5LexerTokenMarker.class).put((Object)"text/jsonl", JSONLexerTokenMarker.class).put((Object)"text/json-schema", JSONSchemaLexerTokenMarker.class).put((Object)"text/yaml", YAMLLexerTokenMarker.class).put((Object)"text/c", CLexerTokenMarker.class).put((Object)"text/cc", CPPLexerTokenMarker.class).put((Object)"text/batch", BatchLexerTokenMarker.class).put((Object)"text/shell", ShellLexerTokenMarker.class).put((Object)"text/powershell", PowerShellLexerTokenMarker.class).put((Object)"text/properties", PropertiesLexerTokenMarker.class).put((Object)"text/sql", SQLLexerTokenMarker.class).put((Object)"text/php", PHPXMLLexerTokenMarker.class).put((Object)"text/perl", PerlLexerTokenMarker.class).put((Object)"text/css", CSSLexerTokenMarker.class).put((Object)"text/less", LESSLexerTokenMarker.class).put((Object)"text/markdown", MDLexerTokenMarker.class).put((Object)"text/xquery", XQueryXPathLexerTokenMarker.class).put((Object)"text/xpath", XQueryXPathLexerTokenMarker.class).put((Object)"text/python", PythonLexerTokenMarker.class).build();

    private TokenMarkerFactory() {
    }

    public static ImmutableMap<String, Class> getContentTypesToMarkersMap() {
        return b;
    }

    public static TokenMarker newTokenMarker(String string) {
        TokenMarker tokenMarker = null;
        Class clazz = (Class)TokenMarkerFactory.getContentTypesToMarkersMap().get((Object)string);
        if (clazz != null) {
            try {
                LexerTokenMarker.disableNestedSyntaxHighlight((!Options.getInstance().getBooleanProperty("enable.nested.syntax.highlight") ? 1 : 0) != 0);
                tokenMarker = (TokenMarker)clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                c.error((Object)reflectiveOperationException, (Throwable)reflectiveOperationException);
            }
        }
        return tokenMarker;
    }

    public static boolean hasMarkerFor(String string) {
        return TokenMarkerFactory.getContentTypesToMarkersMap().get((Object)string) != null;
    }

    public static boolean isXmlTokenMarker(TokenMarker tokenMarker) {
        return null != tokenMarker && ("XML".equals(tokenMarker.getName()) || "HTML".equals(tokenMarker.getName()));
    }

    public static boolean isJSONTokenMarker(TokenMarker tokenMarker) {
        return null != tokenMarker && ("JSON".equals(tokenMarker.getName()) || "JSON Schema".equals(tokenMarker.getName()) || "JSON5".equals(tokenMarker.getName()));
    }

    public static boolean isYAMLTokenMarker(TokenMarker tokenMarker) {
        return null != tokenMarker && "YAML".equals(tokenMarker.getName());
    }
}

