/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.fsv.sharepoint.api.rest;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.fsv.sharepoint.api.rest.SpColumnInfo;
import ro.sync.fsv.sharepoint.api.rest.SpContentType;
import ro.sync.fsv.sharepoint.api.rest.SpListInfo;

@SkipObfuscate
@JsonIgnoreProperties(ignoreUnknown=true)
public class SpList {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="list")
    private SpListInfo listInfo;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="displayName")
    private String displayName;
    @JsonProperty(value="webUrl")
    private String webUrl;
    @JsonProperty(value="columns")
    private List<SpColumnInfo> columns = new ArrayList<SpColumnInfo>();
    @JsonProperty(value="contentTypes")
    private List<SpContentType> contentTypes = new ArrayList<SpContentType>();

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getTemplate() {
        return Optional.ofNullable(this.listInfo).map(SpListInfo::getTemplate).orElse(null);
    }

    public boolean isHidden() {
        return Optional.ofNullable(this.listInfo).map(SpListInfo::isHidden).orElse(false);
    }

    public boolean isContentTypesEnabled() {
        return Optional.ofNullable(this.listInfo).map(SpListInfo::isContentTypesEnabled).orElse(false);
    }

    public String getName() {
        return this.name;
    }

    public String getWebUrl() {
        return this.webUrl;
    }

    public SpListInfo getListInfo() {
        return this.listInfo;
    }

    public List<SpColumnInfo> getColumns() {
        return this.columns;
    }

    public List<SpContentType> getContentTypes() {
        return this.contentTypes;
    }

    public String toString() {
        return String.format("SpList [id=%s, listInfo=%s, name=%s, displayName=%s, webUrl=%s, columns=%s, contentTypes=%s, getTemplate()=%s, isHidden()=%s, isContentTypesEnabled()=%s]", this.id, this.listInfo, this.name, this.displayName, this.webUrl, this.columns, this.contentTypes, this.getTemplate(), this.isHidden(), this.isContentTypesEnabled());
    }
}

