/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.fsv.sharepoint.api.rest;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Optional;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.fsv.sharepoint.api.entity.IResourceItem;
import ro.sync.fsv.sharepoint.api.rest.SpDateTime;
import ro.sync.fsv.sharepoint.api.rest.SpIdentitySet;
import ro.sync.fsv.sharepoint.api.rest.SpListItem;
import ro.sync.fsv.sharepoint.api.rest.SpParentRef;
import ro.sync.fsv.sharepoint.api.rest.SpPublication;
import ro.sync.fsv.sharepoint.api.rest.SpPublicationLevel;

@SkipObfuscate
@JsonIgnoreProperties(ignoreUnknown=true)
public class SpDriveItem
implements IResourceItem {
    private static final String CHILD_COUNT = "childCount";
    private static final String MYME_TYPE = "mymeType";
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="webUrl")
    private String url;
    @JsonProperty(value="cTag")
    private String contentTag;
    @JsonProperty
    private String size;
    @JsonProperty
    private SpIdentitySet createdBy;
    @JsonProperty
    private SpIdentitySet lastModifiedBy;
    @JsonProperty(value="createdDateTime")
    private SpDateTime createdDateTime;
    @JsonProperty(value="lastModifiedDateTime")
    private SpDateTime lastModifiedDateTime;
    @JsonProperty(value="listItem")
    private SpListItem listItem;
    @JsonProperty
    private SpPublication publication;
    @JsonProperty
    private SpParentRef parentReference;
    @JsonIgnore
    private boolean isFolder;
    @JsonIgnore
    private boolean isRoot;
    @JsonIgnore
    private String mymeType;
    @JsonIgnore
    private int childCount = 0;

    private static Optional<Object> extractProperty(Map<String, Object> map2, String string) {
        return Optional.ofNullable(map2).map(map -> map.get(string));
    }

    @JsonProperty(value="file")
    private void setFileMetadata(Map<String, Object> map) {
        this.isFolder = false;
        this.mymeType = SpDriveItem.extractProperty(map, MYME_TYPE).map(String::valueOf).orElse(null);
    }

    @JsonProperty(value="root")
    private void setRootMetadata(Map<String, Object> map) {
        this.isRoot = map != null;
    }

    @JsonProperty(value="folder")
    private void setFolderMetadata(Map<String, Object> map) {
        this.isFolder = true;
        this.childCount = SpDriveItem.extractProperty(map, CHILD_COUNT).map(object -> (Integer)object).orElse(0);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    public String getContentTag() {
        return this.contentTag;
    }

    public String getSize() {
        return this.size;
    }

    public SpIdentitySet getCreatedBy() {
        return this.createdBy;
    }

    public SpIdentitySet getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public SpDateTime getCreatedDateTime() {
        return this.createdDateTime;
    }

    public SpDateTime getLastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    public SpPublication getPublication() {
        return this.publication;
    }

    @Override
    public boolean isFolder() {
        return this.isFolder;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public String getMymeType() {
        return this.mymeType;
    }

    public int getChildCount() {
        return this.childCount;
    }

    public SpParentRef getParentReference() {
        return this.parentReference;
    }

    public SpListItem getListItem() {
        return this.listItem;
    }

    public String getDriveId() {
        return Optional.ofNullable(this.parentReference).map(SpParentRef::getDriveId).orElse(null);
    }

    public String getParentId() {
        return Optional.ofNullable(this.parentReference).map(SpParentRef::getId).orElse(null);
    }

    public String getParentPath() {
        return Optional.ofNullable(this.parentReference).map(SpParentRef::getPath).orElse(null);
    }

    public String toString() {
        return String.format("SpDriveItem [id=%s, name=%s, url=%s, contentTag=%s, size=%s, createdBy=%s, lastModifiedBy=%s, createdDateTime=%s, lastModifiedDateTime=%s, listItem=%s, publication=%s, parentReference=%s, isFolder=%s, isRoot=%s, mymeType=%s, childCount=%s]", this.id, this.name, this.url, this.contentTag, this.size, this.createdBy, this.lastModifiedBy, this.createdDateTime, this.lastModifiedDateTime, this.listItem, this.publication, this.parentReference, this.isFolder, this.isRoot, this.mymeType, this.childCount);
    }

    public boolean isCheckedOut() {
        return Optional.ofNullable(this.publication).map(SpPublication::getLevel).filter(spPublicationLevel -> spPublicationLevel == SpPublicationLevel.CHECKOUT).isPresent() || Optional.ofNullable(this.listItem).map(SpListItem::getCheckOutUser).isPresent();
    }
}

