/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.workspace.api.standalone.project.textcompletions;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;

@API(type=APIType.NOT_EXTENDABLE, src=SourceType.PRIVATE)
public final class CompletionProposalsOptions {
    private Builder builder;

    private CompletionProposalsOptions(Builder builder) {
        this.builder = new Builder(builder);
    }

    public int getMaximumNumberOfCompletions() {
        return this.builder.maximumNumberOfCompletions;
    }

    public int getMaximumCompletionSize() {
        return this.builder.maximumCompletionSize;
    }

    public int getMinimumPrefixSize() {
        return this.builder.minimumPrefixSize;
    }

    public int getMaximumPrefixSize() {
        return this.builder.maximumPrefixSize;
    }

    public static class Builder {
        private int maximumNumberOfCompletions = 10;
        private int maximumCompletionSize = 8;
        private int minimumPrefixSize = 2;
        private int maximumPrefixSize = 7;

        public Builder() {
        }

        private Builder(Builder builder) {
            this.maximumNumberOfCompletions = builder.maximumNumberOfCompletions;
            this.maximumCompletionSize = builder.maximumCompletionSize;
            this.minimumPrefixSize = builder.minimumPrefixSize;
            this.maximumPrefixSize = builder.maximumPrefixSize;
        }

        public Builder withMaximumNumberOfCompletions(int n2) {
            this.maximumNumberOfCompletions = n2;
            return this;
        }

        public Builder withMaximumCompletionSize(int n2) {
            this.maximumCompletionSize = n2;
            return this;
        }

        public Builder withMinimumPrefixSize(int n2) {
            this.minimumPrefixSize = n2;
            return this;
        }

        public Builder withMaximumPrefixSize(int n2) {
            this.maximumPrefixSize = n2;
            return this;
        }

        public CompletionProposalsOptions build() {
            return new CompletionProposalsOptions(this);
        }
    }
}

