/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.view.graphics;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.exml.view.graphics.Shape;

@API(type=APIType.EXTENDABLE, src=SourceType.PRIVATE)
@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class Rectangle
implements Shape {
    public int width;
    public int height;
    public int x;
    public int y;

    public Rectangle(int n2, int n3, int n4, int n5) {
        this.width = n4;
        this.height = n5;
        this.x = n2;
        this.y = n3;
    }

    public Rectangle(Rectangle rectangle) {
        this.width = rectangle.width;
        this.height = rectangle.height;
        this.x = rectangle.x;
        this.y = rectangle.y;
    }

    public final boolean intersects(Rectangle rectangle) {
        int n2 = this.width;
        int n3 = this.height;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        if (n4 <= 0 || n5 <= 0 || n2 <= 0 || n3 <= 0) {
            return false;
        }
        int n6 = this.x;
        int n7 = this.y;
        int n8 = rectangle.x;
        int n9 = rectangle.y;
        n5 += n9;
        n2 += n6;
        n3 += n7;
        return !((n4 += n8) >= n8 && n4 <= n6 || n5 >= n9 && n5 <= n7 || n2 >= n6 && n2 <= n8 || n3 >= n7 && n3 <= n9);
    }

    public final boolean intersects(int n2, int n3, int n4, int n5) {
        int n6 = this.width;
        int n7 = this.height;
        if (n4 <= 0 || n5 <= 0 || n6 <= 0 || n7 <= 0) {
            return false;
        }
        int n8 = this.x;
        int n9 = this.y;
        n5 += n3;
        n6 += n8;
        n7 += n9;
        return !((n4 += n2) >= n2 && n4 <= n8 || n5 >= n3 && n5 <= n9 || n6 >= n8 && n6 <= n2 || n7 >= n9 && n7 <= n3);
    }

    public boolean contains(Rectangle rectangle) {
        return this.contains(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public boolean contains(int n2, int n3, int n4, int n5) {
        int n6 = this.width;
        int n7 = this.height;
        if ((n6 | n7 | n4 | n5) < 0) {
            return false;
        }
        int n8 = this.x;
        int n9 = this.y;
        if (n2 < n8 || n3 < n9) {
            return false;
        }
        n6 += n8;
        if ((n4 += n2) <= n2 ? n6 >= n8 || n4 > n6 : n6 >= n8 && n4 > n6) {
            return false;
        }
        n7 += n9;
        return !((n5 += n3) <= n3 ? n7 >= n9 || n5 > n7 : n7 >= n9 && n5 > n7);
    }

    @Override
    public boolean contains(int n2, int n3) {
        return this.inside(n2, n3);
    }

    @Deprecated
    private boolean inside(int n2, int n3) {
        int n4 = this.width;
        int n5 = this.height;
        if ((n4 | n5) < 0) {
            return false;
        }
        int n6 = this.x;
        int n7 = this.y;
        if (n2 < n6 || n3 < n7) {
            return false;
        }
        n5 += n7;
        return !((n4 += n6) >= n6 && n4 <= n2 || n5 >= n7 && n5 <= n3);
    }

    public String toString() {
        return "[x=" + this.x + ",y=" + this.y + ",width=" + this.width + ",height=" + this.height + "]";
    }

    public boolean equals(Object object) {
        if (object instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)object;
            return this.x == rectangle.x && this.y == rectangle.y && this.width == rectangle.width && this.height == rectangle.height;
        }
        return false;
    }

    public int hashCode() {
        return this.x ^ this.y + this.width ^ this.height;
    }

    public Rectangle union(Rectangle rectangle) {
        int n2 = Math.min(this.x, rectangle.x);
        int n3 = Math.max(this.x + this.width, rectangle.x + rectangle.width);
        int n4 = Math.min(this.y, rectangle.y);
        int n5 = Math.max(this.y + this.height, rectangle.y + rectangle.height);
        return new Rectangle(n2, n4, n3 - n2, n5 - n4);
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public boolean adjacent(Rectangle rectangle) {
        boolean bl = false;
        if (!this.intersects(rectangle) && new Rectangle(this.x - 1, this.y - 1, this.width + 2, this.height + 2).intersects(rectangle)) {
            bl = true;
        }
        return bl;
    }

    public Rectangle intersection(Rectangle rectangle) {
        int n2 = this.x;
        int n3 = this.y;
        int n4 = rectangle.x;
        int n5 = rectangle.y;
        long l2 = n2;
        l2 += (long)this.width;
        long l3 = n3;
        l3 += (long)this.height;
        long l4 = n4;
        l4 += (long)rectangle.width;
        long l5 = n5;
        l5 += (long)rectangle.height;
        if (n2 < n4) {
            n2 = n4;
        }
        if (n3 < n5) {
            n3 = n5;
        }
        if (l2 > l4) {
            l2 = l4;
        }
        if (l3 > l5) {
            l3 = l5;
        }
        l3 -= (long)n3;
        if ((l2 -= (long)n2) < Integer.MIN_VALUE) {
            l2 = Integer.MIN_VALUE;
        }
        if (l3 < Integer.MIN_VALUE) {
            l3 = Integer.MIN_VALUE;
        }
        return new Rectangle(n2, n3, (int)l2, (int)l3);
    }

    public static void main(String[] stringArray) {
        Rectangle rectangle = new Rectangle(0, 0, 2, 2);
        Rectangle rectangle2 = new Rectangle(2, 2, 2, 2);
        System.out.println(rectangle.intersects(rectangle2));
    }

    @Override
    public Rectangle getBounds() {
        return this;
    }

    @Override
    public Shape translate(int n2, int n3) {
        return new Rectangle(this.x + n2, this.y + n3, this.width, this.height);
    }

    public Object clone() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }
}

