/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.schemadiagram.abstracts;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.options.Options;
import ro.sync.exml.s.b.b.c;
import ro.sync.exml.schemadiagram.abstracts.bb;
import ro.sync.exml.schemadiagram.abstracts.d;
import ro.sync.exml.schemadiagram.abstracts.f;
import ro.sync.exml.schemadiagram.abstracts.k;
import ro.sync.exml.schemadiagram.abstracts.n;
import ro.sync.exml.schemadiagram.abstracts.q;
import ro.sync.exml.schemadiagram.abstracts.r;
import ro.sync.exml.schemadiagram.abstracts.t;
import ro.sync.exml.schemadiagram.abstracts.u;
import ro.sync.exml.view.HostComponentBase;
import ro.sync.exml.view.Viewport;
import ro.sync.exml.view.e;
import ro.sync.exml.view.g;
import ro.sync.exml.view.graphics.Dimension;
import ro.sync.exml.view.graphics.Font;
import ro.sync.exml.view.graphics.Graphics;
import ro.sync.exml.view.graphics.Rectangle;
import ro.sync.exml.view.h;
import ro.sync.util.z;

@SkipObfuscate(methods=SkipLevel.PRIVATE)
public abstract class AbstractSchemaViewport<TXSDNode>
extends g
implements bb<TXSDNode>,
z,
Viewport {
    protected Rectangle magicXRectangle = null;
    private static final Logger logger = LoggerFactory.getLogger((String)AbstractSchemaViewport.class.getName());
    protected d<TXSDNode> selectionModel = new d(this);
    protected t<TXSDNode> treeModel;
    protected k<TXSDNode> hostComponent;
    protected c textValRenderer;
    protected r<TXSDNode> originalRootView;
    protected u<TXSDNode> viewRenderer;
    protected double scaleFactor = Options.getInstance().getDoubleProperty("schemaDiagram.scaleFactor");
    private boolean centerRootViewOnScreen = false;
    protected boolean scrollToHeader = true;
    private LinkedList<TXSDNode> magicListEastWestNavigation = new LinkedList();
    private boolean lastPressedInExpandArea = false;
    protected boolean readOnly;

    public void setViewRenderer(u<TXSDNode> u2) {
        this.viewRenderer = u2;
    }

    protected AbstractSchemaViewport() {
        this.selectionModel.k(new q<TXSDNode>(){

            @Override
            public void cic(List<r<TXSDNode>> list, r<TXSDNode> r2, List<r<TXSDNode>> list2, r<TXSDNode> r3) {
                if (r3 != null && r2 != null && logger.isDebugEnabled()) {
                    logger.debug("Selection changed. newView : " + URLUtil.filterPasswords((String)String.valueOf(r3.gu())) + ", old : " + URLUtil.filterPasswords((String)String.valueOf(r2.gu())));
                }
                for (r r4 : list) {
                    Rectangle rectangle;
                    Rectangle rectangle2 = null;
                    rectangle2 = r4.lu() ? AbstractSchemaViewport.this.viewToRectangle(r4) : AbstractSchemaViewport.this.viewHeaderToRectangle(r4);
                    if (rectangle2 == null || !(rectangle = AbstractSchemaViewport.this.hostComponent.getViewportBounds()).intersects(rectangle2)) continue;
                    AbstractSchemaViewport.this.repaintView(r4);
                }
                for (r r4 : list2) {
                    AbstractSchemaViewport.this.repaintView(r4);
                }
                if (r3 != null) {
                    AbstractSchemaViewport.this.scrollViewToVisible(r3);
                }
            }
        });
    }

    public void scrollViewToVisible(r<TXSDNode> r2) {
        this.scrollViewToVisible(r2, this.scrollToHeader);
    }

    public void scrollViewToVisible(r<TXSDNode> r2, boolean bl) {
        Rectangle rectangle = this.hostComponent.getViewportBounds();
        Rectangle rectangle2 = null;
        boolean bl2 = false;
        if (r2.lu() && !bl) {
            rectangle2 = this.viewToRectangle(r2);
            bl2 = rectangle2 != null && !rectangle.intersects(rectangle2);
        } else {
            rectangle2 = this.viewHeaderToRectangle(r2);
            boolean bl3 = bl2 = rectangle2 != null && !rectangle.contains(rectangle2);
        }
        if (bl2) {
            this.scrollRectToVisible(new Rectangle(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height));
        }
    }

    private void repaintView(r<TXSDNode> r2) {
        Rectangle rectangle = null;
        rectangle = r2.lu() ? this.viewToRectangle(r2) : this.viewHeaderToRectangle(r2);
        if (rectangle != null) {
            rectangle.x -= 2;
            rectangle.y -= 2;
            rectangle.width += 4;
            rectangle.height += 4;
            this.hostComponent.repaintHost(rectangle);
        } else if (logger.isDebugEnabled()) {
            logger.debug("Cannot select the new view because rectangle for it is null. View : " + r2.gu());
        }
    }

    @Override
    public r<TXSDNode> getRootView() {
        return this.originalRootView;
    }

    public r<TXSDNode> getViewForNode(r<TXSDNode> r2, TXSDNode TXSDNode, boolean bl) {
        r<TXSDNode> r3 = null;
        if (bl || !r2.tv()) {
            if (r2.gu() == TXSDNode) {
                r3 = r2;
            } else {
                int n2 = r2.yu();
                for (int i2 = 0; i2 < n2 && (r3 = this.getViewForNode(r2.fu(i2), TXSDNode, bl)) == null; ++i2) {
                }
            }
        }
        return r3;
    }

    public final void setVisibleSelectionChildren(boolean bl) {
        r<TXSDNode> r2 = this.selectionModel.p();
        if (r2 != null) {
            int n2;
            if (bl) {
                r2.ru(bl);
            }
            if ((n2 = r2.yu()) > 0) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    r<TXSDNode> r3 = r2.fu(i2);
                    r3.ru(bl);
                }
            }
        }
    }

    public final r<TXSDNode> viewToView(int n2, int n3) {
        r<TXSDNode> r2 = this.getRootView();
        if (r2 != null) {
            return r2.tu(this.getRootViewAllocation(r2), (int)((double)n2 / this.scaleFactor), (int)((double)n3 / this.scaleFactor));
        }
        return null;
    }

    public r<TXSDNode> getCircularRefView(int n2, int n3) {
        r<TXSDNode> r2 = this.getRootView();
        if (r2 != null) {
            return r2.qs(this.getRootViewAllocation(r2), (int)((double)n2 / this.scaleFactor), (int)((double)n3 / this.scaleFactor));
        }
        return null;
    }

    private Rectangle getRootViewAllocation(r<TXSDNode> r2) {
        return new Rectangle(0, this.getRootViewStartY(), r2.tt(0) + 1, r2.tt(1) + 1);
    }

    public final boolean containsView(Rectangle rectangle) {
        r<TXSDNode> r2 = this.getRootView();
        if (r2 != null) {
            return r2.lv(this.getRootViewAllocation(r2), new Rectangle((int)((double)rectangle.x / this.scaleFactor), (int)((double)rectangle.y / this.scaleFactor), (int)((double)rectangle.width / this.scaleFactor), (int)((double)rectangle.height / this.scaleFactor)));
        }
        return false;
    }

    public final Rectangle viewHeaderToRectangle(r<TXSDNode> r2) {
        Rectangle rectangle = null;
        r<TXSDNode> r3 = this.getRootView();
        if (r3 != null) {
            rectangle = r3.qv(this.getRootViewAllocation(r3), r2);
        }
        if (rectangle != null) {
            return new Rectangle((int)((double)rectangle.x * this.scaleFactor), (int)((double)rectangle.y * this.scaleFactor), (int)((double)rectangle.width * this.scaleFactor), (int)((double)rectangle.height * this.scaleFactor));
        }
        return null;
    }

    public Rectangle viewToRectangle(r<TXSDNode> r2) {
        Rectangle rectangle = null;
        r<TXSDNode> r3 = this.getRootView();
        if (r3 != null) {
            rectangle = r3.wt(this.getRootViewAllocation(r3), r2);
        }
        if (rectangle != null) {
            return new Rectangle((int)((double)rectangle.x * this.scaleFactor), (int)((double)rectangle.y * this.scaleFactor), (int)((double)rectangle.width * this.scaleFactor), (int)((double)rectangle.height * this.scaleFactor));
        }
        return null;
    }

    public boolean isExpandArea(int n2, int n3) {
        r<TXSDNode> r2 = this.getRootView();
        if (r2 != null) {
            return r2.nv(this.getRootViewAllocation(r2), (int)((double)n2 / this.scaleFactor), (int)((double)n3 / this.scaleFactor));
        }
        return false;
    }

    public d<TXSDNode> getSelectionModel() {
        return this.selectionModel;
    }

    private void setSelectionPaths(List<TXSDNode[]> list) {
        ArrayList arrayList = new ArrayList(list.size());
        for (TXSDNode[] TXSDNodeArray : list) {
            arrayList.add(this.expandPathToView(TXSDNodeArray));
        }
        this.selectionModel.m(arrayList, arrayList.isEmpty() ? null : (r)arrayList.get(arrayList.size() - 1));
    }

    private r<TXSDNode> expandPathToView(TXSDNode[] TXSDNodeArray) {
        r<TXSDNode> r2 = this.originalRootView;
        block0: for (int i2 = 0; i2 < TXSDNodeArray.length - 1 && r2 != null; ++i2) {
            if (!r2.wv()) {
                r2.ru(true);
            }
            int n2 = r2.yu();
            for (int i3 = 0; i3 < n2; ++i3) {
                r<TXSDNode> r3 = r2.fu(i3);
                if (r3.gu() != TXSDNodeArray[i2 + 1]) continue;
                r2 = r3;
                continue block0;
            }
        }
        return r2;
    }

    public void setSelectionPath(TXSDNode[] TXSDNodeArray) {
        ArrayList<TXSDNode[]> arrayList = new ArrayList<TXSDNode[]>(1);
        arrayList.add(TXSDNodeArray);
        this.setSelectionPaths(arrayList);
    }

    public void invalidate(r<TXSDNode> r2, int n2, TXSDNode[] TXSDNodeArray) {
        if (logger.isDebugEnabled()) {
            logger.debug("Searching for a view associated with: " + TXSDNodeArray[n2] + " into " + r2.gu());
        }
        if (TXSDNodeArray[n2] == r2.gu()) {
            if (n2 == TXSDNodeArray.length - 1) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Found the view: " + r2);
                }
                boolean bl = this.selectionModel.p() == r2;
                r<TXSDNode> r3 = r2.ut();
                if (r3 == null) {
                    r2.iu();
                    r2.vt();
                } else if (r3.yv(TXSDNodeArray[n2])) {
                    r2 = r3.zs(TXSDNodeArray[n2]);
                }
                if (bl) {
                    this.selectionModel.h(r2);
                }
            } else {
                int n3 = r2.yu();
                for (int i2 = 0; i2 < n3; ++i2) {
                    this.invalidate(r2.fu(i2), n2 + 1, TXSDNodeArray);
                }
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("Not found.");
        }
    }

    public t<TXSDNode> getTreeModel() {
        return this.treeModel;
    }

    public List<r<TXSDNode>> getPathToView(r<TXSDNode> r2) {
        ArrayList<r<TXSDNode>> arrayList = new ArrayList<r<TXSDNode>>();
        while (r2 != null) {
            arrayList.add(0, r2);
            r2 = r2.ut();
        }
        return arrayList;
    }

    public r<TXSDNode> getViewForNodePath(TXSDNode[] TXSDNodeArray, boolean bl, boolean bl2) {
        r r2 = this.getRootView();
        r[] rArray = new r[]{r2};
        int n2 = 0;
        block0: while (n2 < TXSDNodeArray.length) {
            for (int i2 = 0; i2 < rArray.length; ++i2) {
                r r3 = rArray[i2];
                if (r3.gu() != TXSDNodeArray[n2]) continue;
                r2 = r3;
                if (++n2 == TXSDNodeArray.length) continue block0;
                int n3 = r3.yu();
                if (bl && n3 == 0 && r3.ao == null) {
                    r3.ru(true);
                    n3 = r3.yu();
                }
                rArray = new r[n3];
                for (int i3 = 0; i3 < n3; ++i3) {
                    rArray[i3] = r3.fu(i3);
                }
                continue block0;
            }
            if (bl2) break;
            ++n2;
        }
        if (bl2 && n2 != TXSDNodeArray.length) {
            r2 = null;
        }
        return r2;
    }

    public void expandPath(r<TXSDNode>[] rArray) {
        for (int i2 = 0; i2 < rArray.length; ++i2) {
            r<TXSDNode> r2 = rArray[i2];
            if (r2.wv()) continue;
            r2.ru(true);
        }
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void mouseEvent(ro.sync.exml.view.k var1_1) {
        var2_2 = this.viewToView(var1_1.getX(), var1_1.getY());
        if (var2_2 != null) {
            var3_3 = this.isExpandArea(var1_1.getX(), var1_1.getY());
            if (var1_1.getState() == 1) {
                this.resetMagicX();
                this.lastPressedInExpandArea = false;
                if (var3_3 && !var1_1.isPopupTrigger()) {
                    this.lastPressedInExpandArea = true;
                    if (AbstractSchemaViewport.logger.isDebugEnabled()) {
                        AbstractSchemaViewport.logger.debug("Is expand area!");
                    }
                    var4_4 = var2_2.mu().i();
                    this.hostComponent.xnk(false);
                    try {
                        var5_5 = this.viewHeaderToRectangle(var2_2).y;
                        var6_6 = this.hostComponent.getViewportBounds().y;
                        var2_2.mu().u(true);
                        var7_7 = var2_2.wv() == false;
                        var2_2.ru(var7_7);
                        var8_8 = this.hostComponent.getViewportBounds().y;
                        var9_9 = this.viewHeaderToRectangle(var2_2).y;
                        var10_10 = var9_9 - var5_5 - (var8_8 - var6_6);
                        if (var10_10 == 0) ** GOTO lbl61
                        var11_11 = new Rectangle(this.hostComponent.getViewportBounds());
                        var11_11.y += var10_10;
                        this.hostComponent.scrollRectToVisible(var11_11);
                    }
                    finally {
                        var2_2.mu().u(var4_4);
                        this.hostComponent.xnk(true);
                    }
                } else if (this.allowsMultipleSelection() && var1_1.isShiftPressed() && !var1_1.isPopupTrigger()) {
                    this.selectFromOriginToView(var1_1.isCommandPressed(), var2_2);
                    this.clearWestEastMagicMarkers();
                } else if (!this.allowsMultipleSelection() || !var1_1.isCommandPressed() || var1_1.isPopupTrigger()) {
                    if (this.allowsMultipleSelection()) {
                        if (!this.selectionModel.e().contains(var2_2)) {
                            this.selectionModel.h(var2_2);
                            this.clearWestEastMagicMarkers();
                        } else if (this.selectionModel.p() != var2_2) {
                            this.selectionModel.d(var2_2);
                            this.selectionModel.f(var2_2);
                            this.clearWestEastMagicMarkers();
                        }
                    } else {
                        this.selectionModel.h(var2_2);
                        this.clearWestEastMagicMarkers();
                    }
                }
            } else if (var1_1.getState() == 3 && !var3_3 && !this.lastPressedInExpandArea) {
                if (!(var1_1.isCommandPressed() || var1_1.isShiftPressed() || var1_1.isPopupTrigger())) {
                    this.selectionModel.h(var2_2);
                } else if (this.allowsMultipleSelection() && var1_1.isCommandPressed() && !var1_1.isShiftPressed() && !var1_1.isPopupTrigger()) {
                    if (this.selectionModel.e().contains(var2_2)) {
                        this.selectionModel.d(var2_2);
                        this.clearWestEastMagicMarkers();
                    } else {
                        this.selectionModel.f(var2_2);
                        this.selectionModel.l(var2_2);
                        this.clearWestEastMagicMarkers();
                    }
                }
            }
        }
lbl61:
        // 15 sources

        this.fireMouseEvent(var1_1);
    }

    public boolean isLastPressedInExpandArea() {
        return this.lastPressedInExpandArea;
    }

    protected void clearWestEastMagicMarkers() {
        this.magicListEastWestNavigation.clear();
    }

    protected void resetMagicX() {
        this.magicXRectangle = null;
    }

    private void selectFromOriginToView(boolean bl, r<TXSDNode> r2) {
        r<TXSDNode> r3 = this.selectionModel.o();
        if (r3 == null) {
            r3 = this.selectionModel.p();
        }
        if (r3 != null) {
            List<Object> list = null;
            if (!bl) {
                list = new ArrayList();
                list.add(r3);
            } else {
                list = this.selectionModel.e();
            }
            r<TXSDNode> r4 = r2.ut();
            if (r4 != null && r4 == r3.ut()) {
                int n2 = r4.rv(r2);
                int n3 = r4.rv(r3);
                if (n2 != -1 && n3 != -1) {
                    int n4;
                    if (n2 > n3) {
                        n4 = n2;
                        n2 = n3;
                        n3 = n4;
                    }
                    for (n4 = n2; n4 <= n3; ++n4) {
                        r<TXSDNode> r5 = r4.fu(n4);
                        list.remove(r5);
                        list.add(r5);
                    }
                    list.remove(r2);
                    list.add(r2);
                    this.selectionModel.m(list, r2);
                }
            }
            this.selectionModel.l(r3);
        }
    }

    @Override
    public void keyEvent(e e2) {
        r<TXSDNode> r2 = this.selectionModel.p();
        if (r2 != null) {
            if (e2.f == 4) {
                if (!r2.wv()) {
                    r2.ru(true);
                }
            } else if (e2.f == 5) {
                if (r2.wv()) {
                    r2.ru(false);
                }
            } else if (e2.f == 21 || e2.f == 22 || e2.f == 19 || e2.f == 20 || e2.f == 0 || e2.f == 1 || e2.f == 2 || e2.f == 3) {
                r<TXSDNode> r3 = null;
                if (e2.f == 21) {
                    r3 = this.getRootView();
                } else if (e2.f == 22) {
                    r<TXSDNode> r4 = r2;
                    do {
                        if (!r4.wv() && r4.ou()) {
                            r4.ru(true);
                        }
                        if (r4.yu() > 0) {
                            r3 = r4.fu(r4.yu() - 1);
                        }
                        r4 = r3;
                    } while (r3 != null && r3.pu());
                } else if (e2.f == 19) {
                    r<TXSDNode> r5 = r2.ut();
                    if (r5 != null) {
                        r3 = r5.fu(0);
                    }
                } else if (e2.f == 20) {
                    r<TXSDNode> r6 = r2.ut();
                    if (r6 != null) {
                        r3 = r6.fu(r6.yu() - 1);
                    }
                } else {
                    TXSDNode TXSDNode;
                    r<TXSDNode> r7;
                    if ((e2.f == 0 || e2.f == 1) && this.magicXRectangle == null) {
                        this.magicXRectangle = this.viewHeaderToRectangle(r2);
                    }
                    r3 = r2.ft(e2.f);
                    if (e2.f == 3) {
                        if (this.selectionModel.e().size() == 1 && r3 != null && r3 != r2) {
                            this.magicListEastWestNavigation.addFirst(r2.gu());
                        }
                    } else if (e2.f == 2 && !this.magicListEastWestNavigation.isEmpty() && r3 != null && r3.ut() != null && (r7 = this.getViewForNode(r2, TXSDNode = this.magicListEastWestNavigation.removeFirst(), true)) != null) {
                        r3 = r7;
                    }
                }
                if (r3 != null) {
                    if (e2.f != 2 && e2.f != 3) {
                        this.clearWestEastMagicMarkers();
                    }
                    if (e2.f != 0 && e2.f != 1) {
                        this.resetMagicX();
                    }
                    if (e2.b && this.allowsMultipleSelection() && (e2.f == 0 || e2.f == 1 || e2.f == 21 || e2.f == 22 || e2.f == 19 || e2.f == 20)) {
                        this.selectFromOriginToView(e2.g, r3);
                    } else {
                        this.selectionModel.h(r3);
                    }
                }
            } else {
                e2.e = false;
                if (logger.isDebugEnabled()) {
                    logger.debug("Unknown or uninteresting key action " + e2.f);
                }
            }
        } else {
            e2.e = false;
        }
    }

    protected boolean allowsMultipleSelection() {
        return false;
    }

    @Override
    public void paint(Graphics graphics, Rectangle rectangle) {
        r<TXSDNode> r2 = this.getRootView();
        if (r2 != null) {
            rectangle.y += this.getRootViewStartY();
            r2.dt(graphics, rectangle);
        }
    }

    @Override
    public void recomputeLayout() {
        this.recomputeLayout(true);
    }

    @Override
    public void recomputeLayout(boolean bl) {
        Dimension dimension = this.hostComponent.getHostPreferredSize();
        r<TXSDNode> r2 = this.getRootView();
        if (r2 != null) {
            r2.zt(bl);
        }
        Dimension dimension2 = this.hostComponent.getHostPreferredSize();
        this.fireViewportResized(dimension, dimension2);
    }

    @Override
    public String getTooltipText(int n2, int n3, boolean bl) {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        r<TXSDNode> r2 = this.viewToView(n2, n3);
        if (r2 != null && r2.gu() != null && (string = r2.mu().x().c(r2.gu())) != null) {
            stringBuilder.append("<html><body>");
            stringBuilder.append(string);
            stringBuilder.append("</body></html>");
        }
        return stringBuilder.length() > 0 ? stringBuilder.toString() : null;
    }

    public void setScaleFactor(double d2) {
        this.scaleFactor = d2;
    }

    @Override
    public h getSelectedView() {
        return this.selectionModel.p();
    }

    @Override
    public void setFont(Font font) {
        this.recomputeLayout();
    }

    @Override
    public boolean supportsHorizontalScroll() {
        return true;
    }

    @Override
    public Rectangle getSize() {
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        r<TXSDNode> r2 = this.getRootView();
        if (r2 != null) {
            rectangle = this.getRootViewAllocation(r2);
        }
        return rectangle;
    }

    public void setTextValueRenderer(c c2) {
        this.textValRenderer = c2;
    }

    @Override
    public void setHostComponent(HostComponentBase hostComponentBase) {
        this.hostComponent = (k)hostComponentBase;
        this.setFont(this.hostComponent.getHostFont());
    }

    public int[] getViewIndexPath(r<TXSDNode> object) {
        int n2;
        r<TXSDNode> r2;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (object != null) {
            r2 = ((r)object).ut();
            if (r2 != null) {
                n2 = -1;
                int n3 = r2.yu();
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (r2.fu(i2) != object) continue;
                    n2 = i2;
                    break;
                }
            } else {
                arrayList.add(0, 0);
                break;
            }
            arrayList.add(0, n2);
            object = r2;
        }
        r2 = (r<TXSDNode>)new int[arrayList.size()];
        for (n2 = 0; n2 < ((Object)r2).length; ++n2) {
            r2[n2] = (Integer)arrayList.get(n2);
        }
        return r2;
    }

    public boolean isAnnotationArea(int n2, int n3) {
        r<TXSDNode> r2 = this.getRootView();
        if (r2 != null) {
            return r2.ss(this.getRootViewAllocation(r2), (int)((double)n2 / this.scaleFactor), (int)((double)n3 / this.scaleFactor));
        }
        return false;
    }

    private int getRootViewStartY() {
        r<TXSDNode> r2;
        int n2;
        int n3;
        int n4 = this.getRootViewPadding();
        if (this.centerRootViewOnScreen() && (n3 = (int)((double)this.hostComponent.getViewportBounds().height / this.scaleFactor)) >= (n2 = (r2 = this.getRootView()).tt(1) + 2 * this.getRootViewPadding())) {
            n4 += (n3 - n2) / 2;
        }
        return n4;
    }

    protected int getRootViewPadding() {
        return 0;
    }

    private final boolean centerRootViewOnScreen() {
        return this.centerRootViewOnScreen;
    }

    public final void setCenterRootViewOnScreen(boolean bl) {
        this.centerRootViewOnScreen = bl;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public void setShowGoToSchemaIcon(boolean bl, boolean bl2) {
    }

    public static String getSelID(r r2) {
        Object TViewNode;
        f f2;
        n n2;
        String string = null;
        if (r2 != null && (string = (n2 = (n)(f2 = (f)r2.mu().x()).r(TViewNode = r2.gu())).v(TViewNode, r2.ut() != null ? (Object)r2.ut().gu() : null)) != null && string.trim().length() > 0) {
            string = string.replace('\\', '_').replace('/', '_');
        }
        return string;
    }

    @Override
    public void schemaDimensionChanged() {
        Rectangle rectangle = this.getSize();
        this.hostComponent.setHostPreferredSize(new Dimension(rectangle.width, rectangle.height));
        this.hostComponent.invalidateHost();
    }

    @Override
    public Rectangle getVisibleRect() {
        return this.hostComponent.getViewportBounds();
    }

    @Override
    public void scrollRectToVisible(Rectangle rectangle) {
        this.hostComponent.scrollRectToVisible(rectangle);
    }

    @Override
    public Rectangle getStartRectangle() throws Exception {
        h h2 = this.getSelectedView();
        if (h2 != null) {
            return this.viewHeaderToRectangle((r)h2);
        }
        throw new IllegalAccessException();
    }

    @Override
    public Rectangle getEndRectangle() throws Exception {
        return this.getStartRectangle();
    }
}

