/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.editor.validate;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.dt.PersistentObjectField;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.util.PlatformDetector;
import ro.sync.exml.dd;
import ro.sync.exml.editor.og;
import ro.sync.exml.editor.state.EditorStateInfo;
import ro.sync.exml.editor.state.b;
import ro.sync.i18n.r;
import ro.sync.options.InvalidPersistentObjException;
import ro.sync.options.PersistentObject;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class ValidationUnitType
implements PersistentObject {
    private static final Logger logger = LoggerFactory.getLogger((String)ValidationUnitType.class.getName());
    public static final ValidationUnitType VALIDATION_TYPE_XML = new ValidationUnitType("text/xml", "XML Document", "XML Documents");
    public static final ValidationUnitType VALIDATION_TYPE_XSL = new ValidationUnitType("text/xsl", "XSLT Document", "XSLT Stylesheets");
    public static final ValidationUnitType VALIDATION_TYPE_DTD = new ValidationUnitType("text/dtd", "DTD Document", "DTDs");
    public static final ValidationUnitType VALIDATION_TYPE_XSD = new ValidationUnitType("text/xsd", "XML Schema Document", "XML Schemas");
    public static final ValidationUnitType VALIDATION_TYPE_RNG = new ValidationUnitType("text/rng", "RNG Document", "RelaxNG Schemas");
    public static final ValidationUnitType VALIDATION_TYPE_RNC = new ValidationUnitType("text/rnc", "RNC Document", "RelaxNG Compact Schemas");
    public static final ValidationUnitType VALIDATION_TYPE_NVDL = new ValidationUnitType("text/nvdl", "NVDL Document", "NVDL Scripts");
    public static final ValidationUnitType VALIDATION_TYPE_XPROC = new ValidationUnitType("text/xproc", "XProc Document", "XProc Documents");
    public static final ValidationUnitType VALIDATION_TYPE_WSDL = new ValidationUnitType("text/wsdl", "WSDL Document", "WSDL Documents");
    public static final ValidationUnitType VALIDATION_TYPE_SCHEMATRON = new ValidationUnitType("text/sch", "Schematron Document", "Schematron Schemas");
    public static final ValidationUnitType VALIDATION_TYPE_XQUERY = new ValidationUnitType("text/xquery", "XQuery Document", "XQuery Modules");
    public static final ValidationUnitType VALIDATION_TYPE_CSS = new ValidationUnitType("text/css", "CSS Document", "CSS Stylesheets");
    public static final ValidationUnitType VALIDATION_TYPE_LESS = new ValidationUnitType("text/less", "LESS Document", "LESS CSS Stylesheets");
    public static final ValidationUnitType VALIDATION_TYPE_JSON = new ValidationUnitType("text/json", "JSON Document", "JSON Documents");
    public static final ValidationUnitType VALIDATION_TYPE_JSON5 = new ValidationUnitType("text/json5", "JSON5 Document", "JSON5 Documents");
    public static final ValidationUnitType VALIDATION_TYPE_JSONL = new ValidationUnitType("text/jsonl", "JSON-L Document", "JSON-L Documents");
    public static final ValidationUnitType VALIDATION_TYPE_JSON_SCHEMA = new ValidationUnitType("text/json-schema", "JSON Schema Document", "JSON Schema Documents");
    public static final ValidationUnitType VALIDATION_TYPE_YAML = new ValidationUnitType("text/yaml", "YAML Document", "YAML Documents");
    public static final ValidationUnitType VALIDATION_TYPE_HTML = new ValidationUnitType("text/html", "HTML Document", "HTML Documents");
    public static final ValidationUnitType VALIDATION_TYPE_SQL = new ValidationUnitType("text/sql", "SQL Document", "SQL Modules");
    public static final ValidationUnitType VALIDATION_TYPE_DETECTED_FROM_INPUT = new ValidationUnitType("text/any", "Detected from input URL extension", "Unknown scenario type");
    public static final ValidationUnitType VALIDATION_TYPE_ANT = new ValidationUnitType("text/ant", "Ant Document", "Ant builds");
    private static final List<ValidationUnitType> ALL_VALIDATION_UNITS = Collections.unmodifiableList(Arrays.asList(VALIDATION_TYPE_DETECTED_FROM_INPUT, VALIDATION_TYPE_XML, VALIDATION_TYPE_XSL, VALIDATION_TYPE_DTD, VALIDATION_TYPE_XSD, VALIDATION_TYPE_RNG, VALIDATION_TYPE_RNC, VALIDATION_TYPE_NVDL, VALIDATION_TYPE_XPROC, VALIDATION_TYPE_WSDL, VALIDATION_TYPE_SCHEMATRON, VALIDATION_TYPE_XQUERY, VALIDATION_TYPE_CSS, VALIDATION_TYPE_HTML, VALIDATION_TYPE_JSON, VALIDATION_TYPE_JSONL, VALIDATION_TYPE_JSON_SCHEMA, VALIDATION_TYPE_YAML, VALIDATION_TYPE_LESS, VALIDATION_TYPE_SQL, VALIDATION_TYPE_ANT));
    @PersistentObjectField(hasEditorVariables=false)
    private String validationInputType;
    @PersistentObjectField(hasEditorVariables=false)
    private transient String description;
    @PersistentObjectField(hasEditorVariables=false)
    private transient String scenarioTypeDescription;
    private static final List<ValidationUnitType> JSON_EDITOR_VALIDATION_UNITS = Collections.unmodifiableList(Arrays.asList(VALIDATION_TYPE_DETECTED_FROM_INPUT, VALIDATION_TYPE_CSS, VALIDATION_TYPE_HTML, VALIDATION_TYPE_JSON, VALIDATION_TYPE_JSONL, VALIDATION_TYPE_JSON_SCHEMA, VALIDATION_TYPE_YAML, VALIDATION_TYPE_LESS));

    public ValidationUnitType() {
    }

    private ValidationUnitType(String string, String string2, String string3) {
        this.validationInputType = string;
        this.description = string2;
        this.scenarioTypeDescription = string3;
    }

    @Override
    public void checkValid() throws InvalidPersistentObjException {
        if (this.validationInputType == null) {
            throw new InvalidPersistentObjException("No validation input type");
        }
        this.description = VALIDATION_TYPE_DETECTED_FROM_INPUT.getDescription();
        this.scenarioTypeDescription = VALIDATION_TYPE_DETECTED_FROM_INPUT.getScenarioTypeDescription();
        if (ValidationUnitType.VALIDATION_TYPE_XML.validationInputType.equals(this.validationInputType)) {
            this.description = VALIDATION_TYPE_XML.getDescription();
            this.scenarioTypeDescription = VALIDATION_TYPE_XML.getScenarioTypeDescription();
        } else if (ValidationUnitType.VALIDATION_TYPE_XSL.validationInputType.equals(this.validationInputType)) {
            this.description = VALIDATION_TYPE_XSL.getDescription();
            this.scenarioTypeDescription = VALIDATION_TYPE_XSL.getScenarioTypeDescription();
        } else if (ValidationUnitType.VALIDATION_TYPE_DTD.validationInputType.equals(this.validationInputType)) {
            this.description = VALIDATION_TYPE_DTD.getDescription();
            this.scenarioTypeDescription = VALIDATION_TYPE_DTD.getScenarioTypeDescription();
        } else if (ValidationUnitType.VALIDATION_TYPE_XSD.validationInputType.equals(this.validationInputType)) {
            this.description = VALIDATION_TYPE_XSD.getDescription();
            this.scenarioTypeDescription = VALIDATION_TYPE_XSD.getScenarioTypeDescription();
        } else if (ValidationUnitType.VALIDATION_TYPE_RNG.validationInputType.equals(this.validationInputType)) {
            this.description = VALIDATION_TYPE_RNG.getDescription();
            this.scenarioTypeDescription = VALIDATION_TYPE_RNG.getScenarioTypeDescription();
        } else if (ValidationUnitType.VALIDATION_TYPE_RNC.validationInputType.equals(this.validationInputType)) {
            this.description = VALIDATION_TYPE_RNC.getDescription();
            this.scenarioTypeDescription = VALIDATION_TYPE_RNC.getScenarioTypeDescription();
        } else if (ValidationUnitType.VALIDATION_TYPE_NVDL.validationInputType.equals(this.validationInputType)) {
            this.description = VALIDATION_TYPE_NVDL.getDescription();
            this.scenarioTypeDescription = VALIDATION_TYPE_NVDL.getScenarioTypeDescription();
        } else if (ValidationUnitType.VALIDATION_TYPE_XPROC.validationInputType.equals(this.validationInputType)) {
            this.description = VALIDATION_TYPE_XPROC.getDescription();
            this.scenarioTypeDescription = VALIDATION_TYPE_XPROC.getScenarioTypeDescription();
        } else if (ValidationUnitType.VALIDATION_TYPE_WSDL.validationInputType.equals(this.validationInputType)) {
            this.description = VALIDATION_TYPE_WSDL.getDescription();
            this.scenarioTypeDescription = VALIDATION_TYPE_WSDL.getScenarioTypeDescription();
        } else if (ValidationUnitType.VALIDATION_TYPE_SCHEMATRON.validationInputType.equals(this.validationInputType)) {
            this.description = VALIDATION_TYPE_SCHEMATRON.getDescription();
            this.scenarioTypeDescription = VALIDATION_TYPE_SCHEMATRON.getScenarioTypeDescription();
        } else if (ValidationUnitType.VALIDATION_TYPE_XQUERY.validationInputType.equals(this.validationInputType)) {
            this.description = VALIDATION_TYPE_XQUERY.getDescription();
            this.scenarioTypeDescription = VALIDATION_TYPE_XQUERY.getScenarioTypeDescription();
        } else if (ValidationUnitType.VALIDATION_TYPE_CSS.validationInputType.equals(this.validationInputType)) {
            this.description = VALIDATION_TYPE_CSS.getDescription();
            this.scenarioTypeDescription = VALIDATION_TYPE_CSS.getScenarioTypeDescription();
        } else if (ValidationUnitType.VALIDATION_TYPE_LESS.validationInputType.equals(this.validationInputType)) {
            this.description = VALIDATION_TYPE_LESS.getDescription();
            this.scenarioTypeDescription = VALIDATION_TYPE_LESS.getScenarioTypeDescription();
        } else if (ValidationUnitType.VALIDATION_TYPE_SQL.validationInputType.equals(this.validationInputType)) {
            this.description = VALIDATION_TYPE_SQL.getDescription();
            this.scenarioTypeDescription = VALIDATION_TYPE_SQL.getScenarioTypeDescription();
        } else if (ValidationUnitType.VALIDATION_TYPE_ANT.validationInputType.equals(this.validationInputType)) {
            this.description = VALIDATION_TYPE_ANT.getDescription();
            this.scenarioTypeDescription = VALIDATION_TYPE_ANT.getScenarioTypeDescription();
        } else if (ValidationUnitType.VALIDATION_TYPE_JSON.validationInputType.equals(this.validationInputType)) {
            this.description = VALIDATION_TYPE_JSON.getDescription();
            this.scenarioTypeDescription = VALIDATION_TYPE_JSON.getScenarioTypeDescription();
        } else if (ValidationUnitType.VALIDATION_TYPE_JSONL.validationInputType.equals(this.validationInputType)) {
            this.description = VALIDATION_TYPE_JSONL.getDescription();
            this.scenarioTypeDescription = VALIDATION_TYPE_JSONL.getScenarioTypeDescription();
        } else if (ValidationUnitType.VALIDATION_TYPE_JSON_SCHEMA.validationInputType.equals(this.validationInputType)) {
            this.description = VALIDATION_TYPE_JSON_SCHEMA.getDescription();
            this.scenarioTypeDescription = VALIDATION_TYPE_JSON_SCHEMA.getScenarioTypeDescription();
        } else if (ValidationUnitType.VALIDATION_TYPE_YAML.validationInputType.equals(this.validationInputType)) {
            this.description = VALIDATION_TYPE_YAML.getDescription();
            this.scenarioTypeDescription = VALIDATION_TYPE_YAML.getScenarioTypeDescription();
        } else if (ValidationUnitType.VALIDATION_TYPE_HTML.validationInputType.equals(this.validationInputType)) {
            this.description = VALIDATION_TYPE_HTML.getDescription();
            this.scenarioTypeDescription = VALIDATION_TYPE_HTML.getScenarioTypeDescription();
        }
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return null;
    }

    @Override
    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            logger.error((Object)cloneNotSupportedException, (Throwable)cloneNotSupportedException);
        }
        return object;
    }

    public String getValidationInputType(String string) {
        String string2 = this.validationInputType;
        if (string != null && ValidationUnitType.VALIDATION_TYPE_DETECTED_FROM_INPUT.validationInputType.equals(this.validationInputType)) {
            string2 = ValidationUnitType.getValidationUnitTypeFromURL((String)string).validationInputType;
        }
        return string2;
    }

    public String getDescription() {
        return this.description;
    }

    public static List<ValidationUnitType> getAllValidationUnitTypes() {
        ArrayList<ValidationUnitType> arrayList = new ArrayList<ValidationUnitType>(dd.k() ? JSON_EDITOR_VALIDATION_UNITS : ALL_VALIDATION_UNITS);
        if (PlatformDetector.isEclipse() || dd.m() || dd.d() || dd.q()) {
            arrayList.remove(VALIDATION_TYPE_ANT);
        }
        return arrayList;
    }

    public String toString() {
        return this.description;
    }

    public boolean equals(Object object) {
        boolean bl;
        boolean bl2 = bl = object == this;
        if (!bl && object instanceof ValidationUnitType) {
            bl = this.validationInputType.equals(((ValidationUnitType)object).getValidationInputType(null));
        }
        return bl;
    }

    public int hashCode() {
        return this.validationInputType.hashCode();
    }

    public static ValidationUnitType getValidationUnitType(String string) {
        ValidationUnitType validationUnitType = VALIDATION_TYPE_DETECTED_FROM_INPUT;
        if (string != null) {
            List<ValidationUnitType> list = ValidationUnitType.getAllValidationUnitTypes();
            for (ValidationUnitType validationUnitType2 : list) {
                if (!validationUnitType2.validationInputType.equals(string)) continue;
                validationUnitType = validationUnitType2;
                break;
            }
        }
        return validationUnitType;
    }

    public static ValidationUnitType getValidationUnitTypeFromURL(String string) {
        ValidationUnitType validationUnitType = VALIDATION_TYPE_DETECTED_FROM_INPUT;
        if (string != null) {
            String string2 = og.p(string);
            EditorStateInfo editorStateInfo = b.k().i(string);
            if (editorStateInfo != null) {
                string2 = editorStateInfo.getContentType();
            }
            validationUnitType = ValidationUnitType.getValidationUnitType(string2);
        }
        return validationUnitType;
    }

    public static ValidationUnitType getValidationUnitTypeFromURL(URL uRL, String string) {
        ValidationUnitType validationUnitType = VALIDATION_TYPE_DETECTED_FROM_INPUT;
        if (uRL == null) {
            if (string != null) {
                validationUnitType = ValidationUnitType.getValidationUnitType(string);
            }
        } else {
            validationUnitType = ValidationUnitType.getValidationUnitTypeFromURL(uRL.toString());
        }
        return validationUnitType;
    }

    public String getScenarioTypeDescription() {
        return this.scenarioTypeDescription;
    }

    public static String getUnitTypeShortDescription(ValidationUnitType validationUnitType) {
        String string = validationUnitType.getDescription();
        if (VALIDATION_TYPE_LESS.equals(validationUnitType)) {
            string = "LESS";
        } else if (VALIDATION_TYPE_CSS.equals(validationUnitType)) {
            string = "CSS";
        } else if (VALIDATION_TYPE_DETECTED_FROM_INPUT.equals(validationUnitType)) {
            string = r.m().getString("All");
        } else if (VALIDATION_TYPE_DTD.equals(validationUnitType)) {
            string = "DTD";
        } else if (VALIDATION_TYPE_NVDL.equals(validationUnitType)) {
            string = "NVDL";
        } else if (VALIDATION_TYPE_RNC.equals(validationUnitType)) {
            string = "RNC";
        } else if (VALIDATION_TYPE_RNG.equals(validationUnitType)) {
            string = "RNG";
        } else if (VALIDATION_TYPE_SCHEMATRON.equals(validationUnitType)) {
            string = "Schematron";
        } else if (VALIDATION_TYPE_SQL.equals(validationUnitType)) {
            string = "SQL";
        } else if (VALIDATION_TYPE_WSDL.equals(validationUnitType)) {
            string = "WSDL";
        } else if (VALIDATION_TYPE_XML.equals(validationUnitType)) {
            string = "XML";
        } else if (VALIDATION_TYPE_XPROC.equals(validationUnitType)) {
            string = "XProc";
        } else if (VALIDATION_TYPE_XQUERY.equals(validationUnitType)) {
            string = "XQuery";
        } else if (VALIDATION_TYPE_XSD.equals(validationUnitType)) {
            string = "XSD";
        } else if (VALIDATION_TYPE_XSL.equals(validationUnitType)) {
            string = "XSL";
        } else if (VALIDATION_TYPE_ANT.equals(validationUnitType)) {
            string = "ANT";
        } else if (VALIDATION_TYPE_JSON.equals(validationUnitType)) {
            string = "JSON";
        } else if (VALIDATION_TYPE_JSONL.equals(validationUnitType)) {
            string = "JSONL";
        } else if (VALIDATION_TYPE_JSON_SCHEMA.equals(validationUnitType)) {
            string = "JSONSchema";
        } else if (VALIDATION_TYPE_YAML.equals(validationUnitType)) {
            string = "YAML";
        } else if (VALIDATION_TYPE_HTML.equals(validationUnitType)) {
            string = "HTML";
        }
        return string;
    }
}

