/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.addons;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.execution.StoppedByUserException;
import ro.sync.basic.util.Equaler;
import ro.sync.basic.util.SortedList;
import ro.sync.basic.util.URLUtil;
import ro.sync.document.DocumentPositionedInfo;
import ro.sync.exml.addons.ExtensionInfo;
import ro.sync.exml.addons.b;
import ro.sync.exml.addons.h;
import ro.sync.exml.addons.l;
import ro.sync.exml.editor.re;
import ro.sync.exml.plugin.PluginUtil;
import ro.sync.exml.v;
import ro.sync.io.ProgressEvent;
import ro.sync.io.ProgressListener;
import ro.sync.o.e;
import ro.sync.util.jb;

@API(type=APIType.INTERNAL, src=SourceType.PRIVATE)
public class ExtensionsManager {
    private static final Logger c = LoggerFactory.getLogger((String)ExtensionsManager.class.getName());
    protected static final Comparator<ExtensionInfo> EXTENSION_ID_COMPARATOR = new Comparator<ExtensionInfo>(){

        public int b(ExtensionInfo extensionInfo, ExtensionInfo extensionInfo2) {
            return extensionInfo.getExtensionId().compareTo(extensionInfo2.getExtensionId());
        }
    };
    protected Map<URL, List<ExtensionInfo>> updateSitesMap;
    private List<b> d = new SortedList(EXTENSION_ID_COMPARATOR);
    private final l b;

    public ExtensionsManager(l l2) {
        this(l2, false);
    }

    public ExtensionsManager(l l2, boolean bl) {
        this(l2, null);
    }

    public ExtensionsManager(l l2, Predicate<b> predicate) {
        this.b = l2;
        this.updateSitesMap = new HashMap<URL, List<ExtensionInfo>>();
        File[] fileArray = l2.d();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            if (!fileArray[i2].exists()) continue;
            b[] bArray = ro.sync.exml.addons.b.f(fileArray[i2]);
            List<b> list = ExtensionsManager.d(bArray, this.d, predicate);
            this.d.addAll(list);
        }
    }

    static List<b> d(b[] bArray, List<b> list, Predicate<b> predicate) {
        Predicate<b> predicate2 = b2 -> {
            boolean bl = true;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                b b3 = (b)iterator.next();
                if (c.isDebugEnabled()) {
                    c.debug("Already loaded: " + b3.getExtensionId() + " version: " + b3.getVersion());
                }
                if (!Equaler.verifyEquals((Object)b2.getExtensionId(), (Object)b3.getExtensionId())) continue;
                int n2 = ExtensionsManager.c(b2, b3);
                boolean bl2 = bl = n2 > 0;
                if (!bl) break;
                iterator.remove();
                break;
            }
            return bl;
        };
        if (predicate != null) {
            predicate2 = predicate.and(predicate2);
        }
        return Arrays.stream(bArray).filter(predicate2).collect(Collectors.toList());
    }

    private static int c(b b2, b b3) {
        int n2 = 0;
        String string = jb.e().c().getAbsolutePath();
        String string2 = b2.g().getAbsolutePath();
        String string3 = b3.g().getAbsolutePath();
        if (string2.startsWith(string) && !string3.startsWith(string)) {
            n2 = 1;
        } else if (!string2.startsWith(string) && string3.startsWith(string)) {
            n2 = -1;
        } else {
            n2 = b2.getVersion().f(b3.getVersion());
            if (n2 == 0) {
                File file = new File(string2, "extension.xml");
                File file2 = new File(string3, "extension.xml");
                n2 = file.lastModified() > file2.lastModified() ? 1 : -1;
            }
        }
        if (c.isDebugEnabled()) {
            c.debug("First  to compare " + string2 + " version " + b2.getVersion());
            c.debug("Second to compare " + string3 + " version " + b3.getVersion());
            c.debug("Result " + n2);
        }
        return n2;
    }

    public l getExtensionsLocationsProvider() {
        return this.b;
    }

    public void collectUpdateInformation(URL[] uRLArray, ProgressListener progressListener) throws StoppedByUserException {
        Object object;
        int n2;
        this.updateSitesMap.clear();
        HashSet<Object> hashSet = new HashSet<Object>();
        if (uRLArray != null) {
            hashSet.addAll(Arrays.asList(uRLArray));
        }
        for (n2 = 0; n2 < this.d.size(); ++n2) {
            object = this.d.get(n2).getUpdateSiteUrl();
            if (object == null) continue;
            hashSet.add(object);
        }
        n2 = 1;
        if (!hashSet.isEmpty()) {
            n2 = 100 / hashSet.size();
        }
        object = hashSet.iterator();
        int n3 = 1;
        while (object.hasNext()) {
            Object object2;
            block12: {
                URL uRL = (URL)object.next();
                if (progressListener != null) {
                    progressListener.changeDetailsMessage(uRL.toExternalForm());
                }
                if (c.isDebugEnabled()) {
                    c.debug("Read " + URLUtil.filterPasswords((String)String.valueOf(uRL)));
                }
                try {
                    object2 = ExtensionInfo.loadExtensions(uRL);
                    SortedList sortedList = new SortedList(EXTENSION_ID_COMPARATOR);
                    sortedList.addAll(Arrays.asList(object2));
                    this.updateSitesMap.put(uRL, (List<ExtensionInfo>)sortedList);
                }
                catch (IOException iOException) {
                    if (c.isDebugEnabled()) {
                        c.debug((Object)iOException, (Throwable)iOException);
                    }
                    if (progressListener == null) break block12;
                    v.getInstance().addProblemResult("Extensions update errors", new DocumentPositionedInfo(2, iOException.getMessage(), uRL.toString()), re.s, false, false);
                }
            }
            if (progressListener != null) {
                object2 = new ProgressEvent(n2 * n3);
                progressListener.change((ProgressEvent)object2);
                if (((ProgressEvent)object2).getCanceled()) {
                    throw new StoppedByUserException();
                }
            }
            ++n3;
        }
        if (progressListener != null) {
            progressListener.done();
        }
    }

    public ExtensionInfo[] getUpdateSitesExtensions() {
        ArrayList<ExtensionInfo> arrayList = new ArrayList<ExtensionInfo>();
        Set<URL> set = this.updateSitesMap.keySet();
        for (URL uRL : set) {
            List<ExtensionInfo> list = this.updateSitesMap.get(uRL);
            if (list == null) continue;
            arrayList.addAll(list);
        }
        return arrayList.toArray(new ExtensionInfo[0]);
    }

    public ExtensionInfo[] getUpdateSitesExtensions(URL[] uRLArray) {
        ArrayList<ExtensionInfo> arrayList = new ArrayList<ExtensionInfo>();
        for (int i2 = 0; i2 < uRLArray.length; ++i2) {
            URL uRL = uRLArray[i2];
            List<ExtensionInfo> list = this.updateSitesMap.get(uRL);
            if (list == null) continue;
            arrayList.addAll(list);
        }
        return arrayList.toArray(new ExtensionInfo[0]);
    }

    /*
     * WARNING - void declaration
     */
    public List<h> computeUpdateInformation(ExtensionInfo[] extensionInfoArray) {
        ArrayList<h> arrayList = new ArrayList<h>();
        for (int i2 = 0; i2 < extensionInfoArray.length; ++i2) {
            h._b _b2;
            int n2;
            ExtensionInfo extensionInfo = extensionInfoArray[i2];
            SortedList sortedList = new SortedList((Comparator)new Comparator<ExtensionInfo>(){

                public int b(ExtensionInfo extensionInfo, ExtensionInfo extensionInfo2) {
                    return extensionInfo2.getVersion().f(extensionInfo.getVersion());
                }
            });
            b b2 = null;
            if (extensionInfo instanceof b) {
                b2 = (b)extensionInfo;
            } else {
                sortedList.add(extensionInfo);
            }
            String string = extensionInfo.getExtensionId();
            if (b2 == null && (n2 = Collections.binarySearch(this.d, new ExtensionInfo(string), EXTENSION_ID_COMPARATOR)) >= 0 && !ExtensionsManager.canWriteAtLocation((b2 = this.d.get(n2)).g())) {
                if (n2 > 0 && string.equals(this.d.get(n2 - 1).getExtensionId()) && ExtensionsManager.canWriteAtLocation(this.d.get(n2 - 1).g())) {
                    b2 = this.d.get(n2 - 1);
                } else if (n2 < this.d.size() - 1 && string.equals(this.d.get(n2 + 1).getExtensionId()) && ExtensionsManager.canWriteAtLocation(this.d.get(n2 + 1).g())) {
                    b2 = this.d.get(n2 + 1);
                }
            }
            if (sortedList.isEmpty()) {
                if (b2 != null && b2.getUpdateSiteUrl() != null) {
                    if (c.isDebugEnabled()) {
                        c.debug(String.format("Connect %s", URLUtil.filterPasswords((String)String.valueOf(b2.getUpdateSiteUrl()))));
                    }
                    List<ExtensionInfo> list = this.updateSitesMap.get(b2.getUpdateSiteUrl());
                    if (c.isDebugEnabled()) {
                        c.debug(list);
                    }
                    if (list != null) {
                        for (int i3 = 0; i3 < list.size(); ++i3) {
                            if (!string.equals(list.get(i3).getExtensionId())) continue;
                            sortedList.add(list.get(i3));
                        }
                    }
                }
                for (List<ExtensionInfo> list : this.updateSitesMap.values()) {
                    for (ExtensionInfo extensionInfo2 : list) {
                        if (!string.equals(extensionInfo2.getExtensionId())) continue;
                        sortedList.add(extensionInfo2);
                    }
                }
            }
            h._b _b3 = _b2 = b2 != null ? h._b.b : h._b.e;
            if (c.isDebugEnabled()) {
                c.debug("Choose candidate " + sortedList.size());
            }
            h h2 = null;
            if (!sortedList.isEmpty()) {
                void var11_19;
                Object object2 = null;
                h._b _b4 = _b2;
                for (int i3 = 0; i3 < sortedList.size(); ++i3) {
                    ExtensionInfo extensionInfo3 = (ExtensionInfo)sortedList.get(i3);
                    if (c.isDebugEnabled()) {
                        c.debug("extensionInfo " + extensionInfo3.getExtensionId() + " v " + extensionInfo3.getVersion());
                    }
                    h._b _b5 = _b2;
                    if (b2 != null && extensionInfo3.getVersion().f(b2.getVersion()) > 0 && ExtensionsManager.isSupportedExtension(extensionInfo3.getOxyVersion(), e.c().getVersion())) {
                        _b5 = h._b.e;
                    }
                    if (b2 == null && !ExtensionsManager.isSupportedExtension(extensionInfo3.getOxyVersion(), e.c().getVersion())) {
                        _b5 = h._b.d;
                    }
                    if (object2 == null || _b5 == h._b.e || _b5 == h._b.b && var11_19 == h._b.d) {
                        object2 = extensionInfo3;
                        h._b _b6 = _b5;
                    }
                    if (var11_19 == h._b.e) break;
                }
                File file = null;
                file = b2 != null ? b2.g().getParentFile() : this.b.c((ExtensionInfo)sortedList.get(0));
                h2 = new h((h._b)var11_19, (ExtensionInfo)object2, file, b2 != null ? b2 : null);
            } else {
                h2 = new h(h._b.f, b2, b2.g().getParentFile(), b2);
            }
            arrayList.add(h2);
        }
        return arrayList;
    }

    public static int compareVersions(String string, String string2) {
        return PluginUtil.compareVersions(string, string2);
    }

    public static boolean isSupportedExtension(String string, String string2) {
        boolean bl = false;
        int n2 = string.lastIndexOf(43);
        if (n2 != -1) {
            string = string.substring(0, n2);
        }
        int n3 = ExtensionsManager.compareVersions(string, string2);
        bl = n2 != -1 ? n3 <= 0 : n3 == 0;
        return bl;
    }

    public b[] getInstalledExtensions() {
        return this.d.toArray(new b[0]);
    }

    public b getInstalledExtension(String string) {
        b b2 = null;
        for (int i2 = 0; i2 < this.d.size(); ++i2) {
            if (!this.d.get(i2).getExtensionId().equals(string)) continue;
            b2 = this.d.get(i2);
            break;
        }
        return b2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canWriteAtLocation(File file) {
        boolean bl = true;
        File file2 = new File(file, "write_test" + System.currentTimeMillis() + ".txt");
        try {
            file.mkdirs();
            file2.createNewFile();
        }
        catch (IOException iOException) {
            if (c.isDebugEnabled()) {
                c.debug((Object)iOException, (Throwable)iOException);
            }
            bl = false;
        }
        finally {
            if (file2.exists()) {
                file2.delete();
            }
        }
        return bl;
    }

    public URL[] getUpdateSites() {
        return this.updateSitesMap.keySet().toArray(new URL[0]);
    }
}

