/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.support;

import java.util.List;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.AuthorTableColumnWidthProviderBase;
import ro.sync.ecss.extensions.api.WidthRepresentation;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.commons.table.support.CALSTableCellInfoProvider;
import ro.sync.ecss.extensions.commons.table.support.HTMLTableCellInfoProvider;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class CALSandHTMLTableCellInfoProvider
extends AuthorTableColumnWidthProviderBase
implements AuthorTableCellSpanProvider {
    private CALSTableCellInfoProvider calsTableCellInfoProvider = new CALSTableCellInfoProvider();
    private HTMLTableCellInfoProvider htmlTableCellInfoProvider = new HTMLTableCellInfoProvider();

    @Override
    public Integer getColSpan(AuthorElement authorElement) {
        Integer n2 = this.htmlTableCellInfoProvider.getColSpan(authorElement);
        if (n2 == null) {
            n2 = this.calsTableCellInfoProvider.getColSpan(authorElement);
        }
        return n2;
    }

    @Override
    public Integer getRowSpan(AuthorElement authorElement) {
        Integer n2 = this.htmlTableCellInfoProvider.getRowSpan(authorElement);
        if (n2 == null) {
            n2 = this.calsTableCellInfoProvider.getRowSpan(authorElement);
        }
        return n2;
    }

    @Override
    public void init(AuthorElement authorElement) {
        this.calsTableCellInfoProvider.init(authorElement);
        this.htmlTableCellInfoProvider.init(authorElement);
    }

    @Override
    public String getDescription() {
        return "Provides information about cells in CALS and HTML tables";
    }

    public AuthorTableCellSpanProvider getCALSTableCellSpanProvider() {
        return this.calsTableCellInfoProvider;
    }

    public AuthorTableCellSpanProvider getXHTMLTableCellSpanProvider() {
        return this.htmlTableCellInfoProvider;
    }

    @Override
    public boolean hasColumnSpecifications(AuthorElement authorElement) {
        boolean bl = false;
        bl = "tgroup".equalsIgnoreCase(authorElement.getLocalName()) ? this.calsTableCellInfoProvider.hasColumnSpecifications(authorElement) : this.htmlTableCellInfoProvider.hasColumnSpecifications(authorElement);
        return bl;
    }

    @Override
    public List<WidthRepresentation> getCellWidth(AuthorElement authorElement, int n2, int n3) {
        List<WidthRepresentation> list = this.htmlTableCellInfoProvider.getCellWidth(authorElement, n2, n3);
        if (list == null) {
            list = this.calsTableCellInfoProvider.getCellWidth(authorElement, n2, n3);
        }
        return list;
    }

    @Override
    public void commitColumnWidthModifications(AuthorDocumentController authorDocumentController, WidthRepresentation[] widthRepresentationArray, String string) throws AuthorOperationException {
        this.calsTableCellInfoProvider.commitColumnWidthModifications(authorDocumentController, widthRepresentationArray, string);
        this.htmlTableCellInfoProvider.commitColumnWidthModifications(authorDocumentController, widthRepresentationArray, string);
    }

    @Override
    public void commitTableWidthModification(AuthorDocumentController authorDocumentController, int n2, String string) throws AuthorOperationException {
        this.calsTableCellInfoProvider.commitTableWidthModification(authorDocumentController, n2, string);
        this.htmlTableCellInfoProvider.commitTableWidthModification(authorDocumentController, n2, string);
    }

    @Override
    public WidthRepresentation getTableWidth(String string) {
        WidthRepresentation widthRepresentation = this.calsTableCellInfoProvider.getTableWidth(string);
        if (widthRepresentation == null) {
            widthRepresentation = this.htmlTableCellInfoProvider.getTableWidth(string);
        }
        return widthRepresentation;
    }

    @Override
    public boolean isTableAcceptingWidth(String string) {
        return this.calsTableCellInfoProvider.isTableAcceptingWidth(string) || this.htmlTableCellInfoProvider.isTableAcceptingWidth(string);
    }

    @Override
    public boolean isTableAndColumnsResizable(String string) {
        return this.calsTableCellInfoProvider.isTableAndColumnsResizable(string) || this.htmlTableCellInfoProvider.isTableAndColumnsResizable(string);
    }

    @Override
    public boolean isAcceptingFixedColumnWidths(String string) {
        return this.calsTableCellInfoProvider.isAcceptingFixedColumnWidths(string) || this.htmlTableCellInfoProvider.isAcceptingFixedColumnWidths(string);
    }

    @Override
    public boolean isAcceptingPercentageColumnWidths(String string) {
        return this.calsTableCellInfoProvider.isAcceptingPercentageColumnWidths(string) || this.htmlTableCellInfoProvider.isAcceptingPercentageColumnWidths(string);
    }

    @Override
    public boolean isAcceptingProportionalColumnWidths(String string) {
        return this.calsTableCellInfoProvider.isAcceptingProportionalColumnWidths(string) || this.htmlTableCellInfoProvider.isAcceptingProportionalColumnWidths(string);
    }

    @Override
    public List<WidthRepresentation> getAllColspecWidthRepresentations() {
        List<WidthRepresentation> list = this.htmlTableCellInfoProvider.getAllColspecWidthRepresentations();
        if (list == null) {
            list = this.calsTableCellInfoProvider.getAllColspecWidthRepresentations();
        }
        return list;
    }

    @Override
    public boolean isPreferPercentageColumnWidths(String string) {
        return this.htmlTableCellInfoProvider.isPreferPercentageColumnWidths(string);
    }
}

