/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations;

import java.awt.Frame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.ContentInterval;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.access.AuthorTableAccess;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;
import ro.sync.ecss.extensions.commons.table.operations.AbstractTableOperation;
import ro.sync.ecss.extensions.commons.table.operations.AuthorTableHelper;
import ro.sync.ecss.extensions.commons.table.operations.ECTableSplitCustomizerDialog;
import ro.sync.ecss.extensions.commons.table.operations.InsertColumnOperationBase;
import ro.sync.ecss.extensions.commons.table.operations.InsertRowOperationBase;
import ro.sync.ecss.extensions.commons.table.operations.JoinOperationBase;
import ro.sync.ecss.extensions.commons.table.operations.SATableSplitCustomizerDialog;
import ro.sync.exml.workspace.api.Platform;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=false)
@WebappRestSafe
public abstract class SplitOperationBase
extends AbstractTableOperation {
    private static final Logger logger = LoggerFactory.getLogger((String)SplitOperationBase.class.getName());

    public SplitOperationBase(AuthorTableHelper authorTableHelper) {
        super(authorTableHelper);
    }

    @Override
    protected void doOperationInternal(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException {
        block21: {
            try {
                Object object;
                Object object2;
                AuthorElement authorElement = null;
                if (authorAccess.getEditorAccess().hasSelection() && (object2 = authorAccess.getEditorAccess().getFullySelectedNode()) != null) {
                    authorElement = this.getElementAncestor((AuthorNode)object2, 0);
                }
                if (authorElement == null) {
                    int n2 = authorAccess.getEditorAccess().getCaretOffset();
                    object = authorAccess.getDocumentController().getNodeAtOffset(n2);
                    authorElement = this.getElementAncestor((AuthorNode)object, 0);
                }
                if (authorElement != null) {
                    Object object3;
                    object2 = authorAccess.getTableAccess();
                    object = object2.getTableRowSpanIndices(authorElement);
                    int[] nArray = object2.getTableColSpanIndices(authorElement);
                    Object object4 = object[0];
                    Object object5 = object[1];
                    int n3 = nArray[0];
                    int n4 = nArray[1];
                    reference var11_13 = object5 - object4 + true;
                    int n5 = n4 - n3 + 1;
                    AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
                    boolean bl = var11_13 > true || n5 > 1;
                    reference var15_17 = bl ? var11_13 : (reference)20;
                    int n6 = bl ? n5 : 20;
                    int[] nArray2 = null;
                    int[] nArray3 = SplitOperationBase.getSplitInfoFromArguments(argumentsMap);
                    if (nArray3 != null) {
                        nArray2 = new int[]{nArray3[0], nArray3[1]};
                    } else if (var15_17 == 2 && n6 == 1 || var15_17 == true && n6 == 2) {
                        nArray2 = new int[]{n6, (int)var15_17};
                    } else {
                        Object object6;
                        object3 = authorAccess.getWorkspaceAccess().getPlatform();
                        if (Platform.STANDALONE == object3) {
                            object6 = new SATableSplitCustomizerDialog((Frame)authorAccess.getWorkspaceAccess().getParentFrame(), authorAccess.getAuthorResourceBundle(), n6, (int)var15_17){

                                @Override
                                public String getHelpPageID() {
                                    return SplitOperationBase.this.getHelpPageID();
                                }
                            };
                            nArray2 = ((SATableSplitCustomizerDialog)object6).getSplitInformation();
                        } else if (Platform.ECLIPSE == object3) {
                            object6 = new ECTableSplitCustomizerDialog(authorAccess.getWorkspaceAccess().getParentFrame(), authorAccess.getAuthorResourceBundle(), n6, (int)var15_17, this.getHelpPageID());
                            nArray2 = ((ECTableSplitCustomizerDialog)((Object)object6)).getSplitInformation();
                        }
                    }
                    if (nArray2 != null) {
                        object3 = this.getElementAncestor(authorElement, 2);
                        int n7 = nArray2[0];
                        int n8 = nArray2[1];
                        if (n8 > 1 || n7 > 1) {
                            if (bl) {
                                this.splitWithInitialSpan(authorAccess, authorElement, (AuthorElement)object3, (int)var11_13, n5, authorDocumentController, n7, n8);
                            } else {
                                this.splitNoInitialSpan(authorAccess, authorElement, (AuthorElement)object3, authorDocumentController, n7 - 1, n8 - 1);
                            }
                        }
                        ArrayList<ContentInterval> arrayList = new ArrayList<ContentInterval>();
                        int n9 = 0;
                        int n10 = 0;
                        for (int i2 = 0; i2 < n8; ++i2) {
                            int n11 = -1;
                            int n12 = -1;
                            n10 = 0;
                            int n13 = -1;
                            for (int i3 = 0; i3 < n7; ++i3) {
                                int n14;
                                int n15;
                                int[] nArray4;
                                AuthorElement authorElement2 = object2.getTableCellAt((int)(object4 + n9 + i2), n3 + n10 + i3, (AuthorElement)object3);
                                if (n13 == -1) {
                                    nArray4 = object2.getTableRowSpanIndices(authorElement);
                                    n15 = nArray4[0];
                                    n14 = nArray4[1];
                                    n13 = n14 - n15;
                                }
                                nArray4 = object2.getTableColSpanIndices(authorElement);
                                n15 = nArray4[0];
                                n14 = nArray4[1];
                                int n16 = n14 - n15;
                                n10 += n16;
                                if (i2 == 0 && i3 == 0) {
                                    authorAccess.getEditorAccess().setCaretPosition(authorElement2.getStartOffset());
                                }
                                if (i3 == 0) {
                                    n11 = authorElement2.getStartOffset();
                                }
                                n12 = authorElement2.getEndOffset() + 1;
                            }
                            n9 += n13;
                            if (n11 < 0 || n12 < 0) continue;
                            arrayList.add(new ContentInterval(n11, n12));
                        }
                        authorAccess.getEditorAccess().getAuthorSelectionModel().addSelectionIntervals(arrayList, false);
                    }
                    break block21;
                }
                object2 = new AuthorOperationException("The caret must be inside a table cell.");
                ((AuthorOperationException)object2).setOperationRejectedOnPurpose(true);
                throw object2;
            }
            catch (BadLocationException badLocationException) {
                throw new AuthorOperationException("The operation cannot be performed due to: " + badLocationException.getMessage(), badLocationException);
            }
        }
    }

    private static int[] getSplitInfoFromArguments(ArgumentsMap argumentsMap) {
        String string;
        String[] stringArray;
        int[] nArray = null;
        Object object = argumentsMap.getArgumentValue("split_info");
        if (object instanceof String && (stringArray = (string = (String)object).split(",")).length == 2) {
            String string2 = stringArray[0].trim();
            String string3 = stringArray[1].trim();
            try {
                nArray = new int[]{NumberParserUtil.valueOfInteger((String)string2), NumberParserUtil.valueOfInteger((String)string3)};
            }
            catch (NumberFormatException numberFormatException) {
                logger.error((Throwable)numberFormatException);
            }
        }
        return nArray;
    }

    private void splitNoInitialSpan(AuthorAccess authorAccess, AuthorElement authorElement, AuthorElement authorElement2, AuthorDocumentController authorDocumentController, int n2, int n3) throws BadLocationException, AuthorOperationException {
        Object[] objectArray;
        Object object4;
        int n4;
        int n5;
        String string = authorAccess.getDocumentController().getXPathExpression(authorElement.getStartOffset());
        int n6 = authorElement.getEndOffset();
        HashSet<String[]> hashSet = null;
        HashSet<String[]> hashSet2 = null;
        AuthorTableAccess authorTableAccess = authorAccess.getTableAccess();
        int[] nArray = authorTableAccess.getTableCellIndex(authorElement);
        int n7 = nArray[0];
        int n8 = nArray[1];
        if (n3 >= 1) {
            hashSet2 = new HashSet<String[]>();
            n5 = authorTableAccess.getTableNumberOfColumns(authorElement2);
            for (n4 = 0; n4 < n5; ++n4) {
                if (n4 == n8 || (object4 = authorTableAccess.getTableCellAt(n7, n4, authorElement2)) == null) continue;
                hashSet2.add((String[])object4);
            }
        }
        if (n2 >= 1) {
            hashSet = new HashSet<String[]>();
            n5 = authorTableAccess.getTableRowCount(authorElement2);
            for (n4 = 0; n4 < n5; ++n4) {
                if (n4 == n7 || (object4 = authorTableAccess.getTableCellAt(n4, n8, authorElement2)) == null || (objectArray = authorTableAccess.getTableColSpanIndices((AuthorElement)object4))[1] != n8) continue;
                hashSet.add((String[])object4);
            }
        }
        this.getInsertRowOperation().insertRows(authorAccess, string, authorElement.getNamespace(), authorElement, authorElement2, n3, "After");
        this.getInsertColumnOperation().insertColumns(authorAccess, authorElement2, authorElement.getNamespace(), "After", n6, n2);
        if (hashSet != null || hashSet2 != null) {
            try {
                int n9;
                int n10;
                Object object2;
                int n11;
                int n12;
                Object object3;
                JoinOperationBase joinOperationBase = this.getJoinOperation();
                if (hashSet != null) {
                    for (Object object4 : hashSet) {
                        objectArray = authorTableAccess.getTableCellIndex((AuthorElement)object4);
                        object3 = authorTableAccess.getTableRowSpanIndices((AuthorElement)object4);
                        int[] nArray2 = authorTableAccess.getTableColSpanIndices((AuthorElement)object4);
                        n12 = objectArray[0];
                        n11 = objectArray[1];
                        object2 = object3[1];
                        int n13 = n11 + n2 + (nArray2[1] - nArray2[0]);
                        HashSet<AuthorElement> hashSet3 = new HashSet<AuthorElement>();
                        for (n10 = n12; n10 <= object2; ++n10) {
                            for (int i2 = n11; i2 <= n13; ++i2) {
                                AuthorElement authorElement3 = authorTableAccess.getTableCellAt(n10, i2, authorElement2);
                                if (authorElement3 == null) continue;
                                hashSet3.add(authorElement3);
                            }
                        }
                        if (hashSet3.size() <= 1) continue;
                        joinOperationBase.joinCells(authorAccess, authorElement2, new ArrayList<AuthorElement>(hashSet3));
                    }
                }
                if (hashSet2 != null) {
                    for (Object object4 : hashSet2) {
                        objectArray = authorTableAccess.getTableCellIndex((AuthorElement)object4);
                        object3 = authorTableAccess.getTableColSpanIndices((AuthorElement)object4);
                        int n14 = objectArray[0];
                        n12 = objectArray[1];
                        n11 = n14 + n3;
                        object2 = object3[1];
                        HashSet<AuthorElement> hashSet4 = new HashSet<AuthorElement>();
                        for (int i3 = n14; i3 <= n11; ++i3) {
                            for (n10 = n12; n10 <= object2; ++n10) {
                                AuthorElement authorElement4 = authorTableAccess.getTableCellAt(i3, n10, authorElement2);
                                if (authorElement4 == null) continue;
                                hashSet4.add(authorElement4);
                            }
                        }
                        if (hashSet4.size() <= 1) continue;
                        joinOperationBase.joinCells(authorAccess, authorElement2, new ArrayList<AuthorElement>(hashSet4));
                    }
                }
                if ((n9 = authorElement.getAttributesCount()) > 0) {
                    object4 = this.getIgnoredAttributesForColumnSplit();
                    objectArray = this.getIgnoredAttributesForRowSplit();
                    object3 = null;
                    if (object4 != null || objectArray != null) {
                        object3 = new ArrayList();
                        if (object4 != null) {
                            object3.addAll(Arrays.asList(object4));
                        }
                        if (objectArray != null) {
                            object3.addAll(Arrays.asList(objectArray));
                        }
                    }
                    LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                    for (n12 = 0; n12 < n9; ++n12) {
                        String string2 = authorElement.getAttributeAtIndex(n12);
                        AttrValue attrValue = authorElement.getAttribute(string2);
                        if (!attrValue.isSpecified() || object3 != null && object3.contains(string2)) continue;
                        linkedHashMap.put(string2, attrValue.getValue());
                    }
                    if (linkedHashMap.size() > 0) {
                        for (n12 = n7; n12 <= n7 + n3; ++n12) {
                            for (int i4 = n8; i4 <= n8 + n2; ++i4) {
                                AuthorElement authorElement5;
                                if (n12 == n7 && i4 == n8 || (authorElement5 = authorTableAccess.getTableCellAt(n12, i4, authorElement2)) == null) continue;
                                Set set = linkedHashMap.keySet();
                                for (String string3 : set) {
                                    authorDocumentController.setAttribute(string3, new AttrValue((String)linkedHashMap.get(string3)), authorElement5);
                                }
                            }
                        }
                    }
                }
            }
            catch (AuthorOperationException authorOperationException) {
                AuthorOperationException authorOperationException2 = new AuthorOperationException("The split operation cannot be completed.", authorOperationException);
                logger.error((Object)authorOperationException, (Throwable)authorOperationException);
                authorOperationException2.setOperationRejectedOnPurpose(authorOperationException.isOperationRejectedOnPurpose());
                throw authorOperationException2;
            }
        }
    }

    protected abstract InsertRowOperationBase getInsertRowOperation();

    protected abstract InsertColumnOperationBase getInsertColumnOperation();

    protected abstract JoinOperationBase getJoinOperation();

    private void splitWithInitialSpan(AuthorAccess authorAccess, AuthorElement authorElement, AuthorElement authorElement2, int n2, int n3, AuthorDocumentController authorDocumentController, int n4, int n5) throws BadLocationException, AuthorOperationException {
        int n6 = 0;
        AuthorElement authorElement3 = authorElement;
        for (int i2 = 1; i2 <= n5 && authorElement3 != null; ++i2) {
            Object object;
            int n7;
            int[] nArray = authorAccess.getTableAccess().getTableCellIndex(authorElement3);
            if (i2 > 1) {
                n7 = this.findCellInsertionOffset(authorAccess, authorElement2, nArray[0] + n6, nArray[1]);
                if (n7 != -1) {
                    object = this.createEmptyCell(authorAccess, authorElement3, this.getIgnoredAttributesForRowSplit());
                    authorDocumentController.insertFragment(n7, (AuthorDocumentFragment)object);
                    AuthorNode authorNode = authorAccess.getDocumentController().getNodeAtOffset(n7 + 1);
                    authorElement3 = this.getElementAncestor(authorNode, 0);
                } else {
                    object = new AuthorOperationException("Could not determine the location where the split will occur.");
                    ((AuthorOperationException)object).setOperationRejectedOnPurpose(true);
                    throw object;
                }
            }
            n6 = SplitOperationBase.determineCurrentSpan(n6, n5, n2, i2);
            this.tableHelper.updateTableRowSpan(authorAccess, authorElement3, n6);
            n7 = 0;
            object = authorElement3;
            for (int i3 = 1; i3 <= n4 && object != null; ++i3) {
                if (i3 > 1) {
                    int n8 = object.getEndOffset() + 1;
                    AuthorDocumentFragment authorDocumentFragment = this.createEmptyCell(authorAccess, (AuthorElement)object, this.getIgnoredAttributesForColumnSplit());
                    authorDocumentController.insertFragment(n8, authorDocumentFragment);
                    AuthorNode authorNode = authorAccess.getDocumentController().getNodeAtOffset(n8 + 1);
                    object = this.getElementAncestor(authorNode, 0);
                }
                n7 = SplitOperationBase.determineCurrentSpan(n7, n4, n3, i3);
                this.updateColSpan(authorAccess, this.tableHelper.getTableCellSpanProvider(authorElement2), (AuthorElement)object, n7);
            }
        }
    }

    private static int determineCurrentSpan(int n2, int n3, int n4, int n5) {
        if (n5 == n3) {
            n2 = n4 - n2 * (n3 - 1);
        } else {
            n2 = Math.round((float)n4 / (float)n3);
            if (n4 - n2 * (n3 - 1) <= 0) {
                n2 = n4 / n3;
            }
        }
        return n2;
    }

    @Override
    public String getDescription() {
        return "Split the selected table cell (or the cell at caret when there is no selection), if it spans over multiple rows or columns";
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return new ArgumentDescriptor[]{new ArgumentDescriptor("split_info", 5, "", "${ask('', generic, '2,2')}")};
    }

    protected abstract String[] getIgnoredAttributesForRowSplit();

    protected abstract String[] getIgnoredAttributesForColumnSplit();

    private void updateColSpan(AuthorAccess authorAccess, AuthorTableCellSpanProvider authorTableCellSpanProvider, AuthorElement authorElement, int n2) throws AuthorOperationException {
        int[] nArray = authorAccess.getTableAccess().getTableColSpanIndices(authorElement);
        int n3 = nArray[0] + 1;
        int n4 = n3 + n2 - 1;
        this.tableHelper.updateTableColSpan(authorAccess, authorTableCellSpanProvider, authorElement, n3, n4);
    }

    protected String getHelpPageID() {
        return null;
    }
}

