/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.XPathVersion;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class PseudoClassOperation
implements AuthorOperation {
    private static final Logger logger = LoggerFactory.getLogger((String)PseudoClassOperation.class.getName());
    private static final String ARGUMENT_PSEUDOCLASS_NAME = "name";
    private static final String ARGUMENT_ELEMENT_XPATH_LOCATION = "elementLocation";
    private static final String ARGUMENT_INCLUDE_ALL_NODES = "includeAllNodes";
    private static final String YES = "yes";
    private static final String NO = "no";
    private ArgumentDescriptor[] arguments = new ArgumentDescriptor[3];

    public PseudoClassOperation() {
        ArgumentDescriptor argumentDescriptor;
        this.arguments[0] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_ELEMENT_XPATH_LOCATION, 2, "An XPath expression indicating the element or elements whose pseudo-class will be changed.\nNote: If this is not defined then the element at the caret position will be used.");
        this.arguments[1] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_PSEUDOCLASS_NAME, 0, "The pseudo-class name.");
        this.arguments[2] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_INCLUDE_ALL_NODES, 3, "The value should be \"yes\" in order to include comments, text and CDATA nodes in the XPath execution, \"no\" to ignore them.", new String[]{YES, NO}, NO);
    }

    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException {
        Object object = argumentsMap.getArgumentValue(ARGUMENT_ELEMENT_XPATH_LOCATION);
        Object object2 = argumentsMap.getArgumentValue(ARGUMENT_PSEUDOCLASS_NAME);
        Object object3 = argumentsMap.getArgumentValue(ARGUMENT_INCLUDE_ALL_NODES);
        if (object2 instanceof String) {
            String string = ((String)object2).trim();
            if (object instanceof String) {
                if (object3 instanceof String) {
                    boolean bl = object3.equals(YES);
                    AuthorNode[] authorNodeArray = authorAccess.getDocumentController().findNodesByXPath((String)object, null, !bl, !bl, !bl, false, XPathVersion.XPATH_2_0, true);
                    if (authorNodeArray.length > 0) {
                        for (int i2 = 0; i2 < authorNodeArray.length; ++i2) {
                            AuthorNode authorNode = authorNodeArray[i2];
                            if (authorNode instanceof AuthorElement) {
                                AuthorElement authorElement = (AuthorElement)authorNode;
                                this.execute(authorAccess, string, authorElement);
                                continue;
                            }
                            logger.warn("The XPath location selected a node different from element - " + authorNode.getDisplayName() + ": " + object);
                        }
                    } else {
                        logger.warn("The XPath location returned no results: " + object);
                    }
                }
            } else {
                AuthorNode authorNode = null;
                try {
                }
                catch (BadLocationException badLocationException) {
                    throw new AuthorOperationException("Cannot identify the current element", badLocationException);
                }
                for (authorNode = authorAccess.getDocumentController().getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset()); authorNode != null && !(authorNode instanceof AuthorElement); authorNode = authorNode.getParent()) {
                }
                if (!(authorNode instanceof AuthorElement)) {
                    throw new AuthorOperationException("You need to have the carret inside an element.");
                }
                AuthorElement authorElement = (AuthorElement)authorNode;
                this.execute(authorAccess, string, authorElement);
            }
        } else {
            throw new IllegalArgumentException("The argument \"name\" was not defined!");
        }
    }

    protected abstract void execute(AuthorAccess var1, String var2, AuthorElement var3);

    @Override
    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }
}

