/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import java.util.List;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodePredicate;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.commons.operations.ElementLocationPath;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class GetCurrentElementSaxonExtension
extends ExtensionFunctionDefinition {
    private static final Logger logger = LoggerFactory.getLogger((String)GetCurrentElementSaxonExtension.class.getName());
    private final ElementLocationPath elementLocation;
    private NodeInfo cachedElement = null;

    public GetCurrentElementSaxonExtension(ElementLocationPath elementLocationPath) {
        this.elementLocation = elementLocationPath;
    }

    public StructuredQName getFunctionQName() {
        return new StructuredQName("oxy", "http://www.oxygenxml.com/ns/author/xpath-extension-functions", "current-element");
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[0];
    }

    public SequenceType getResultType(SequenceType[] sequenceTypeArray) {
        return SequenceType.OPTIONAL_NODE;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new ExtensionFunctionCallImpl();
    }

    private final class ExtensionFunctionCallImpl
    extends ExtensionFunctionCall {
        private ExtensionFunctionCallImpl() {
        }

        public Sequence call(XPathContext xPathContext, Sequence[] sequenceArray) throws XPathException {
            Item item;
            if (GetCurrentElementSaxonExtension.this.cachedElement == null && (item = xPathContext.getContextItem()) instanceof NodeInfo) {
                item = ((NodeInfo)item).getRoot();
                GetCurrentElementSaxonExtension.this.cachedElement = this.getNodeByLocation(item, GetCurrentElementSaxonExtension.this.elementLocation);
            }
            return GetCurrentElementSaxonExtension.this.cachedElement != null ? GetCurrentElementSaxonExtension.this.cachedElement : EmptySequence.getInstance();
        }

        private NodeInfo getNodeByLocation(Item item, ElementLocationPath elementLocationPath) {
            NodeInfo nodeInfo = ((NodeInfo)item).getRoot();
            List<ElementLocationPath.ElementLocationPathComponent> list = elementLocationPath.getPath();
            for (ElementLocationPath.ElementLocationPathComponent elementLocationPathComponent : list) {
                if (logger.isDebugEnabled()) {
                    logger.debug("XPath part: " + elementLocationPathComponent);
                }
                nodeInfo = this.nextNode(nodeInfo, elementLocationPathComponent);
            }
            return nodeInfo;
        }

        private NodeInfo nextNode(NodeInfo nodeInfo, ElementLocationPath.ElementLocationPathComponent elementLocationPathComponent) {
            NodeInfo nodeInfo2;
            if (elementLocationPathComponent instanceof ElementLocationPath.Root) {
                nodeInfo2 = this.getNthChild(nodeInfo.getRoot(), 1);
            } else if (elementLocationPathComponent instanceof ElementLocationPath.Parent) {
                nodeInfo2 = nodeInfo.getParent();
            } else if (elementLocationPathComponent instanceof ElementLocationPath.Child) {
                ElementLocationPath.Child child = (ElementLocationPath.Child)elementLocationPathComponent;
                nodeInfo2 = this.getNthChild(nodeInfo, child.getIndex());
            } else {
                throw new IllegalArgumentException("XPath component not supported: " + elementLocationPathComponent.toXPath());
            }
            return nodeInfo2;
        }

        private NodeInfo getNthChild(NodeInfo nodeInfo, int n2) {
            AxisIterator axisIterator = nodeInfo.iterateAxis(3, (NodePredicate)NodeKindTest.ELEMENT);
            NodeInfo nodeInfo2 = null;
            for (int i2 = 0; i2 < n2; ++i2) {
                nodeInfo2 = axisIterator.next();
            }
            return nodeInfo2;
        }
    }
}

