/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.api.webapp.plugin;

import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.webapp.plugin.URLStreamHandlerWithContextUtil;
import ro.sync.exml.plugin.lock.LockException;
import ro.sync.exml.plugin.lock.LockHandlerBase;

@API(src=SourceType.PRIVATE, type=APIType.EXTENDABLE)
public abstract class LockHandlerWithContext
extends LockHandlerBase {
    private static final Logger logger = LoggerFactory.getLogger((String)LockHandlerWithContext.class.getName());

    @Override
    public final boolean isSaveAllowed(URL uRL, int n2) {
        String string = this.getUrlContextId(uRL);
        URL uRL2 = this.stripUrlContextId(uRL);
        return this.isSaveAllowed(string, uRL2, n2);
    }

    public abstract boolean isSaveAllowed(String var1, URL var2, int var3);

    @Override
    public final void unlock(URL uRL) throws LockException {
        String string = this.getUrlContextId(uRL);
        URL uRL2 = this.stripUrlContextId(uRL);
        this.unlock(string, uRL2);
    }

    public abstract void unlock(String var1, URL var2) throws LockException;

    @Override
    public final void updateLock(URL uRL, int n2) throws LockException {
        String string = this.getUrlContextId(uRL);
        URL uRL2 = this.stripUrlContextId(uRL);
        this.updateLock(string, uRL2, n2);
    }

    public abstract void updateLock(String var1, URL var2, int var3) throws LockException;

    private URL stripUrlContextId(URL uRL) {
        String string = URLStreamHandlerWithContextUtil.getInstance().toStrippedExternalForm(uRL);
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            logger.error((Object)malformedURLException, (Throwable)malformedURLException);
            return null;
        }
    }

    private String getUrlContextId(URL uRL) {
        return URLStreamHandlerWithContextUtil.getInstance().getUrlContextId(uRL);
    }
}

